/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.questlog;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.SwitchView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.quests.FinishedQuest;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.questlog.WindowQuestLogAvailableQuestModule;
import com.minecolonies.core.client.gui.questlog.WindowQuestLogFinishedQuestModule;
import com.minecolonies.core.client.gui.questlog.WindowQuestLogInProgressQuestQuestModule;
import com.minecolonies.core.client.gui.questlog.WindowQuestLogQuestModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WindowQuestLog
extends AbstractWindowSkeleton {
    private final Map<String, QuestModuleContainer<?>> moduleMap = new HashMap();

    public WindowQuestLog(@NotNull IColonyView colonyView) {
        super(new ResourceLocation("minecolonies", "gui/windowquestlog.xml"));
        this.registerButton("questLocator", this::locateCitizenClickedInternal);
        this.moduleMap.put("pageInProgress", new QuestModuleContainer<IQuestInstance>(new WindowQuestLogInProgressQuestQuestModule(), colonyView, this.switchView, "pageInProgress"));
        this.moduleMap.put("pageAvailable", new QuestModuleContainer<IQuestInstance>(new WindowQuestLogAvailableQuestModule(), colonyView, this.switchView, "pageAvailable"));
        this.moduleMap.put("pageFinished", new QuestModuleContainer<FinishedQuest>(new WindowQuestLogFinishedQuestModule(), colonyView, this.switchView, "pageFinished"));
    }

    private void locateCitizenClickedInternal(@NotNull Button button) {
        String pageId;
        QuestModuleContainer<?> module;
        if (this.switchView.getCurrentView() != null && (module = this.moduleMap.get(pageId = this.switchView.getCurrentView().getID())) != null) {
            module.trackQuest(button);
        }
    }

    @Override
    public void onUpdate() {
        String pageId;
        QuestModuleContainer<?> module;
        super.onUpdate();
        if (this.switchView.getCurrentView() != null && (module = this.moduleMap.get(pageId = this.switchView.getCurrentView().getID())) != null) {
            module.onUpdate();
        }
    }

    private static class QuestModuleContainer<T> {
        private final WindowQuestLogQuestModule<T> module;
        private final IColonyView colonyView;
        private final ScrollingList questsList;
        private List<T> questItems;

        public QuestModuleContainer(final WindowQuestLogQuestModule<T> module, final IColonyView colonyView, SwitchView switchView, String pageId) {
            this.module = module;
            this.colonyView = colonyView;
            Pane parent = switchView.getChildren().stream().filter(f -> f.getID().equals(pageId)).findFirst().orElseThrow();
            this.questsList = (ScrollingList)parent.findPaneOfTypeByID("quests", ScrollingList.class);
            this.questItems = module.getQuestItems(colonyView);
            this.questsList.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return questItems.size();
                }

                public void updateElement(int index, Pane rowPane) {
                    module.renderQuestItem(questItems.get(index), colonyView, rowPane);
                    ButtonImage questLocator = (ButtonImage)rowPane.findPaneOfTypeByID("questLocator", ButtonImage.class);
                    if (questLocator != null) {
                        ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.translatableEscape((String)"com.minecolonies.coremod.item.questlog.gui.track_citizen", (Object[])new Object[0]))).hoverPane((Pane)questLocator).build();
                    }
                }
            });
        }

        void onUpdate() {
            this.questItems = this.module.getQuestItems(this.colonyView);
        }

        void trackQuest(Button button) {
            int row = this.questsList.getListElementIndexByPane((Pane)button);
            this.module.trackQuest(this.questItems.get(row));
        }
    }
}

