/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.MinerLevelManagementModuleView;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerRepairLevelMessage;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerSetLevelMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowHutMinerModule
extends AbstractModuleWindow<MinerLevelManagementModuleView> {
    private static final String LIST_LEVELS = "levels";
    private static final String TEXT_LEVEL = "level";
    private static final String BUTTON_MINE_LEVEL = "mine";
    private static final String BUTTON_REPAIR = "repair";
    private static final String TEXT_DEPTH = "depth";
    private static final String TEXT_NODE_COUNT = "nodes";
    private ScrollingList levelList;

    public WindowHutMinerModule(MinerLevelManagementModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutminermodule.xml"));
        this.registerButton(BUTTON_REPAIR, this::repairClicked);
        this.registerButton(BUTTON_MINE_LEVEL, this::mineLevelClicked);
    }

    private void repairClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        new MinerRepairLevelMessage(this.buildingView, row).sendToServer();
        MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.miner.repair.enqueued", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
    }

    private void mineLevelClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        if (row != ((MinerLevelManagementModuleView)this.moduleView).current && row >= 0 && row < ((MinerLevelManagementModuleView)this.moduleView).levelsInfo.size()) {
            ((MinerLevelManagementModuleView)this.moduleView).current = row;
            new MinerSetLevelMessage(this.buildingView, row).sendToServer();
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.levelList = (ScrollingList)this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        this.levelList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((MinerLevelManagementModuleView)((WindowHutMinerModule)WindowHutMinerModule.this).moduleView).levelsInfo.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                boolean isCurrentLevel = index == ((MinerLevelManagementModuleView)((WindowHutMinerModule)WindowHutMinerModule.this).moduleView).current;
                ((Text)rowPane.findPaneOfTypeByID(WindowHutMinerModule.TEXT_LEVEL, Text.class)).setText(Component.literal((String)String.format("%02d", index + 1)));
                ((Button)rowPane.findPaneOfTypeByID(WindowHutMinerModule.BUTTON_REPAIR, Button.class)).setEnabled(!((MinerLevelManagementModuleView)WindowHutMinerModule.this.moduleView).doesWorkOrderExist(index));
                ((Button)rowPane.findPaneOfTypeByID(WindowHutMinerModule.BUTTON_MINE_LEVEL, Button.class)).setEnabled(!isCurrentLevel);
                ((Text)rowPane.findPaneOfTypeByID(WindowHutMinerModule.TEXT_DEPTH, Text.class)).setText(Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.minerleveldepth").append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)String.valueOf((Integer)((MinerLevelManagementModuleView)((WindowHutMinerModule)WindowHutMinerModule.this).moduleView).levelsInfo.get(index).getB() + 1))));
                ((Text)rowPane.findPaneOfTypeByID(WindowHutMinerModule.TEXT_NODE_COUNT, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.minernode", (Object[])new Object[0]).append(": ").append(String.valueOf(((MinerLevelManagementModuleView)((WindowHutMinerModule)WindowHutMinerModule.this).moduleView).levelsInfo.get(index).getA())));
            }
        });
    }
}

