/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.MateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeInput;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.WindowSelectRes;
import com.minecolonies.core.client.gui.modules.building.WindowSelectRequest;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.buildings.moduleviews.DOCraftingModuleView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DOCraftingWindow
extends AbstractModuleWindow<DOCraftingModuleView> {
    private final ScrollingList inputs;
    private final List<ItemIcon> inputIcons = new ArrayList<ItemIcon>();
    private final ScrollingList resourceList;
    public final Container inputInventory = new SimpleContainer(this, MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount()){};
    private final OptionalPredicate<ItemStack> validator = ((DOCraftingModuleView)this.moduleView).getIngredientValidator();

    public DOCraftingWindow(DOCraftingModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutdocrafting.xml"));
        this.inputs = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.inputIcons.addAll(Collections.nCopies(this.inputInventory.getContainerSize(), null));
        this.inputs.setDataProvider(() -> ((Container)this.inputInventory).getContainerSize(), this::updateInputs);
        this.registerButton("add", this::addRecipe);
        this.registerButton("request", this::showRequests);
    }

    private void updateInputs(int index, Pane rowPane) {
        ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.docrafting.block", (Object[])new Object[]{index + 1}));
        ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class);
        this.inputIcons.set(index, icon);
        ((Button)rowPane.findPaneOfTypeByID("resourceAdd", Button.class)).setHandler(btn -> new WindowSelectRes(this, stack -> MateriallyTexturedBlockManager.getInstance().doesItemStackContainsMaterialForSlot(index, stack), (stack, qty) -> {
            this.inputInventory.setItem(index, stack);
            icon.setItem(stack);
            this.updateStockList();
        }, false).open());
    }

    private void showRequests() {
        new WindowSelectRequest((CraftingModuleView)this.moduleView, this::matchingRequest, this::reopenWithRequest).open();
    }

    private boolean matchingRequest(@NotNull IRequest<?> request) {
        ItemStack stack = DomumOrnamentumUtils.getRequestedStack(request);
        if (stack.isEmpty()) {
            return false;
        }
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack((ItemStack)stack);
        if (textureData.isEmpty()) {
            return false;
        }
        for (Block block : textureData.getTexturedComponents().values()) {
            if (!this.validator.test(new ItemStack((ItemLike)block)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void reopenWithRequest(@Nullable IRequest<?> request) {
        if (request != null) {
            ItemStack stack = DomumOrnamentumUtils.getRequestedStack(request);
            IMateriallyTexturedBlock block = DomumOrnamentumUtils.getBlock(stack);
            MaterialTextureData textureData = MaterialTextureData.readFromItemStack((ItemStack)stack);
            if (block != null && !textureData.isEmpty()) {
                int slot = 0;
                for (IMateriallyTexturedBlockComponent component : block.getComponents()) {
                    ItemStack componentBlock = new ItemStack((ItemLike)textureData.getTexturedComponents().getOrDefault(component.getId(), Blocks.AIR));
                    this.inputInventory.setItem(slot, componentBlock);
                    this.inputIcons.get(slot).setItem(componentBlock);
                    ++slot;
                }
                while (slot < this.inputInventory.getContainerSize()) {
                    this.inputInventory.setItem(slot, ItemStack.EMPTY);
                    this.inputIcons.get(slot).setItem(ItemStack.EMPTY);
                    ++slot;
                }
                this.updateStockList();
            }
        }
        this.open();
    }

    private void addRecipe() {
        List list = Minecraft.getInstance().level.getRecipeManager().getRecipesFor((RecipeType)com.ldtteam.domumornamentum.recipe.ModRecipeTypes.ARCHITECTS_CUTTER.get(), (RecipeInput)new ArchitectsCutterRecipeInput(this.inputInventory), (Level)Minecraft.getInstance().level);
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        if (this.inputInventory.isEmpty() || list.isEmpty()) {
            return;
        }
        for (RecipeHolder recipe : list) {
            ItemStack result = ((ArchitectsCutterRecipe)recipe.value()).assemble(new ArchitectsCutterRecipeInput(this.inputInventory), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copy();
            IMateriallyTexturedBlock doBlock = DomumOrnamentumUtils.getBlock(result);
            if (doBlock == null) continue;
            int components = doBlock.getComponents().size();
            List inputList = map.getOrDefault(components, new ArrayList());
            inputList.add(list.indexOf(recipe));
            map.put(components, inputList);
        }
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        for (int i = 0; i < this.inputInventory.getContainerSize(); ++i) {
            ItemStack atPos = this.inputInventory.getItem(i).copy();
            if (ItemStackUtils.isEmpty(atPos)) continue;
            atPos.setCount(1);
            input.add(new ItemStorage(atPos));
        }
        List inputIndizes = (List)map.get(input.size());
        if (inputIndizes == null) {
            return;
        }
        ArrayList<ItemStack> additionalOutput = new ArrayList<ItemStack>();
        for (int i = 1; i < inputIndizes.size(); ++i) {
            additionalOutput.add(((ArchitectsCutterRecipe)((RecipeHolder)list.get((Integer)inputIndizes.get(i))).value()).assemble(new ArchitectsCutterRecipeInput(this.inputInventory), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copy());
        }
        RecipeStorage storage = RecipeStorage.builder().withInputs(input).withPrimaryOutput(((ArchitectsCutterRecipe)((RecipeHolder)list.get((Integer)inputIndizes.get(0))).value()).assemble(new ArchitectsCutterRecipeInput(this.inputInventory), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copy()).withAlternateOutputs(additionalOutput).withGridSize(3).withRecipeType(ModRecipeTypes.MULTI_OUTPUT_ID).build();
        new AddRemoveRecipeMessage(this.buildingView, false, storage, ((DOCraftingModuleView)this.moduleView).getProducer().getRuntimeID()).sendToServer();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.resourceList.enable();
        this.resourceList.show();
        List list = Minecraft.getInstance().level.getRecipeManager().getRecipesFor((RecipeType)com.ldtteam.domumornamentum.recipe.ModRecipeTypes.ARCHITECTS_CUTTER.get(), (RecipeInput)new ArchitectsCutterRecipeInput(this.inputInventory), (Level)Minecraft.getInstance().level);
        int inputCount = 0;
        for (int i = 0; i < this.inputInventory.getContainerSize(); ++i) {
            if (this.inputInventory.getItem(i).isEmpty()) continue;
            ++inputCount;
        }
        final ArrayList<ArchitectsCutterRecipe> filteredList = new ArrayList<ArchitectsCutterRecipe>();
        for (RecipeHolder recipe : list) {
            ItemStack result = ((ArchitectsCutterRecipe)recipe.value()).assemble(new ArchitectsCutterRecipeInput(this.inputInventory), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copy();
            IMateriallyTexturedBlock doBlock = DomumOrnamentumUtils.getBlock(result);
            if (doBlock == null || doBlock.getComponents().size() != inputCount) continue;
            filteredList.add((ArchitectsCutterRecipe)recipe.value());
        }
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return filteredList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((ArchitectsCutterRecipe)filteredList.get(index)).assemble(new ArchitectsCutterRecipeInput(DOCraftingWindow.this.inputInventory), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copy();
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.getHoverName());
                ((Text)rowPane.findPaneOfTypeByID("resourceQty", Text.class)).setText(Component.literal((String)String.valueOf(resource.getCount())));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }
}

