/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IStackBasedTask;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowRequestDetail;
import com.minecolonies.core.client.gui.modules.IWindowWithLayoutModule;
import com.minecolonies.core.colony.requestsystem.requests.AbstractRequest;
import com.minecolonies.core.colony.requestsystem.requests.StandardRequests;
import com.minecolonies.core.network.messages.server.colony.UpdateRequestStateMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class RequestTreeWindowModule
implements IWindowWithLayoutModule {
    private static final int AUTO_REFRESH_TICKS = 100;
    protected final AbstractWindowSkeleton parent;
    protected final IColonyView colony;
    private final Inventory inventory;
    private final boolean isCreative;
    protected ScrollingList resourceList;
    private int lifeCount = 0;
    private List<RequestWrapper> cachedOpenRequests;
    private int ticks = 0;

    public RequestTreeWindowModule(AbstractWindowSkeleton parent, IColonyView colony) {
        this.parent = parent;
        this.colony = colony;
        this.inventory = Minecraft.getInstance().player.getInventory();
        this.isCreative = Minecraft.getInstance().player.isCreative();
    }

    @Override
    public void onLayoutMounted(Pane rootPane) {
        this.parent.registerButton("detail", this::detailedClicked);
        this.parent.registerButton("cancel", this::cancel);
        this.parent.registerButton("fulfill", this::onFulfill);
        this.resourceList = (ScrollingList)rootPane.findPaneOfTypeByID("requests", ScrollingList.class);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return RequestTreeWindowModule.this.getCachedOpenRequests().size();
            }

            public void updateElement(int index, Pane rowPane) {
                RequestWrapper wrapper = RequestTreeWindowModule.this.getCachedOpenRequests().get(index);
                rowPane.setPosition(rowPane.getX() + 2 * wrapper.depth(), rowPane.getY());
                rowPane.setSize(rowPane.getParent().getWidth() - 2 * wrapper.depth(), rowPane.getHeight());
                IRequest<?> request = wrapper.request();
                ItemIcon exampleStackDisplay = (ItemIcon)rowPane.findPaneOfTypeByID("requestStack", ItemIcon.class);
                List<ItemStack> displayStacks = request.getDisplayStacks();
                Image logo = (Image)rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                if (!displayStacks.isEmpty()) {
                    logo.setVisible(false);
                    exampleStackDisplay.setVisible(true);
                    exampleStackDisplay.setItem(displayStacks.get(RequestTreeWindowModule.this.lifeCount / 30 % displayStacks.size()));
                    ((Text)rowPane.findPaneOfTypeByID("requester", Text.class)).setText(request.getRequester().getRequesterDisplayName(RequestTreeWindowModule.this.colony.getRequestManager(), request));
                } else {
                    exampleStackDisplay.setVisible(false);
                    if (!request.getDisplayIcon().equals((Object)AbstractRequest.MISSING)) {
                        logo.setVisible(true);
                        logo.setImage(request.getDisplayIcon(), false);
                        PaneBuilders.tooltipBuilder().hoverPane((Pane)logo).build().setText(request.getResolverToolTip(RequestTreeWindowModule.this.colony));
                    }
                }
                if (request instanceof IStackBasedTask) {
                    IStackBasedTask stackBasedTask = (IStackBasedTask)((Object)request);
                    ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID("detailIcon", ItemIcon.class);
                    ItemStack copyStack = stackBasedTask.getTaskStack().copy();
                    copyStack.setCount(stackBasedTask.getDisplayCount());
                    icon.setItem(copyStack);
                    icon.setVisible(true);
                    ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(stackBasedTask.getDisplayPrefix().withStyle(ChatFormatting.BLACK));
                } else if (request instanceof StandardRequests.ItemTagRequest) {
                    ((ItemIcon)rowPane.findPaneOfTypeByID("detailIcon", ItemIcon.class)).setVisible(false);
                    if (!displayStacks.isEmpty()) {
                        ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(request.getDisplayStacks().get(RequestTreeWindowModule.this.lifeCount / 30 % displayStacks.size()).getHoverName());
                    }
                } else {
                    ((ItemIcon)rowPane.findPaneOfTypeByID("detailIcon", ItemIcon.class)).setVisible(false);
                    ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(Component.literal((String)request.getShortDisplayString().getString().replace("\u00a7f", "")).withStyle(ChatFormatting.BLACK));
                }
                PaneBuilders.tooltipBuilder().hoverPane(RequestTreeWindowModule.this.parent.findPaneByID("detail")).build().setText(Component.translatable((String)"com.minecolonies.gui.details"));
                if (!RequestTreeWindowModule.this.isCancellable(request)) {
                    ((ButtonImage)rowPane.findPaneOfTypeByID("cancel", ButtonImage.class)).hide();
                }
                Button fulfillButton = (Button)rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class);
                fulfillButton.setVisible(RequestTreeWindowModule.this.isFulfillable(request));
            }
        });
    }

    @Override
    @NotNull
    public final ResourceLocation getLayout() {
        return new ResourceLocation("minecolonies", "gui/layouthuts/layoutrequeststree.xml");
    }

    @Override
    public void onUpdate() {
        if (!Screen.hasShiftDown()) {
            ++this.lifeCount;
        }
        ++this.ticks;
        if (this.ticks >= 100) {
            this.refreshOpenRequests();
            this.ticks = 0;
        }
    }

    public final void refreshOpenRequests() {
        this.cachedOpenRequests = null;
    }

    private List<RequestWrapper> getCachedOpenRequests() {
        if (this.cachedOpenRequests == null) {
            ArrayList<RequestWrapper> requests = new ArrayList<RequestWrapper>();
            for (IRequest<?> request : this.getOpenRequests()) {
                this.constructTreeFromRequest(request, requests, 0);
            }
            this.cachedOpenRequests = requests;
        }
        return this.cachedOpenRequests;
    }

    private void constructTreeFromRequest(@NotNull IRequest<?> request, @NotNull List<RequestWrapper> list, int currentDepth) {
        list.add(new RequestWrapper(request, currentDepth));
        if (request.hasChildren() && this.canDisplayChildRequests()) {
            for (IToken token : request.getChildren()) {
                IRequest<?> childRequest = this.colony.getRequestManager().getRequestForToken(token);
                if (childRequest == null) continue;
                this.constructTreeFromRequest(childRequest, list, currentDepth + 1);
            }
        }
    }

    public final boolean isCancellable(IRequest<?> request) {
        RequestWrapper wrapper = this.getCachedOpenRequests().stream().filter(f -> f.request().getId().equals(request.getId())).findFirst().orElse(null);
        if (wrapper == null) {
            return false;
        }
        return wrapper.depth() <= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFulfillable(IRequest<?> request) {
        if (!(this instanceof IRequestTreeSupportsFulfill)) return false;
        Object obj = request.getRequest();
        if (!(obj instanceof IDeliverable)) return false;
        IDeliverable deliverable = (IDeliverable)obj;
        RequestWrapper wrapper = this.getCachedOpenRequests().stream().filter(f -> f.request().getId().equals(request.getId())).findFirst().orElse(null);
        if (wrapper == null) {
            return false;
        }
        if (this.isCreative) return true;
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((Container)this.inventory), deliverable::matches)) return false;
        return true;
    }

    protected abstract Collection<IRequest<?>> getOpenRequests();

    protected boolean canDisplayChildRequests() {
        return true;
    }

    private void cancel(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        this.cancel(this.getCachedOpenRequests().get(row).request());
    }

    public final void cancel(@NotNull IRequest<?> request) {
        new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.CANCELLED, null).sendToServer();
        this.refreshOpenRequests();
        this.onCancel(request);
    }

    protected void onCancel(@NotNull IRequest<?> request) {
    }

    private void onFulfill(@NotNull Button button) {
        RequestTreeWindowModule requestTreeWindowModule = this;
        if (!(requestTreeWindowModule instanceof IRequestTreeSupportsFulfill)) {
            return;
        }
        IRequestTreeSupportsFulfill fulfill = (IRequestTreeSupportsFulfill)((Object)requestTreeWindowModule);
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        if (this.getCachedOpenRequests().size() > row && row >= 0) {
            IRequest<?> request = this.getCachedOpenRequests().get(row).request();
            try {
                fulfill.onFulfill(request);
            }
            catch (Exception e) {
                Log.getLogger().warn("Failed to fulfill request. This could happen by double clicking the fulfill button.", (Throwable)e);
            }
        }
        button.disable();
        this.refreshOpenRequests();
    }

    private void detailedClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        this.openDetails(this.getCachedOpenRequests().get(row).request());
    }

    public final void openDetails(IRequest<?> request) {
        new WindowRequestDetail(this.parent, request, this.colony.getID(), this).open();
    }

    private record RequestWrapper(IRequest<?> request, int depth) {
    }

    public static interface IRequestTreeSupportsFulfill {
        public void onFulfill(@NotNull IRequest<?> var1);
    }
}

