/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.core.client.gui.modules.building.WindowSelectRequest;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowFurnaceCrafting
extends AbstractContainerScreen<ContainerCraftingFurnace> {
    private static final ResourceLocation CRAFTING_FURNACE = new ResourceLocation("minecolonies", "textures/gui/furnace.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int REQUEST_X_OFFSET = 90 - WindowConstants.CRAFTING_SWITCH_SIZE.width / 2;
    private static final int REQUEST_Y_OFFSET = 70 - WindowConstants.CRAFTING_SWITCH_SIZE.height;
    private final ContainerCraftingFurnace container;
    private final AbstractBuildingView building;
    private final CraftingModuleView module;
    private final Map<IRequest<?>, List<ItemStack>> requestables = new HashMap();

    public WindowFurnaceCrafting(ContainerCraftingFurnace container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.container = container;
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.player.level().dimension(), container.getPos());
        this.module = (CraftingModuleView)this.building.getModuleView(container.getModuleId());
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    protected void init() {
        super.init();
        MutableComponent buttonDisplay = Component.translatableEscape((String)(this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get()) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"), (Object[])new Object[0]);
        Button doneButton = new Button.Builder((Component)buttonDisplay, (Button.OnPress)new OnButtonPress()).pos(this.leftPos + 1, this.topPos + 170).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        if (!this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
            doneButton.active = false;
        }
        ImageButton requestsButton = new ImageButton(this.leftPos + REQUEST_X_OFFSET, this.topPos + REQUEST_Y_OFFSET, WindowConstants.CRAFTING_SWITCH_SIZE.width, WindowConstants.CRAFTING_SWITCH_SIZE.height, WindowConstants.CRAFTING_LIST, btn -> {
            this.requestables.clear();
            new WindowSelectRequest(this.module, this::matchingRequest, this::reopenWithRequest).open();
        });
        requestsButton.visible = Compatibility.jeiProxy.isLoaded();
        this.addRenderableWidget((GuiEventListener)requestsButton);
    }

    private boolean matchingRequest(@NotNull IRequest<?> request) {
        if (!DomumOrnamentumUtils.getRequestedStack(request).isEmpty()) {
            return false;
        }
        Object obj = request.getRequest();
        if (obj instanceof IConcreteDeliverable) {
            IConcreteDeliverable deliverable = (IConcreteDeliverable)obj;
            this.requestables.put(request, deliverable.getRequestedItems());
            return true;
        }
        return false;
    }

    private void reopenWithRequest(@Nullable IRequest<?> request) {
        this.minecraft.setScreen((Screen)this);
        List stacks = this.requestables.getOrDefault(request, new ArrayList());
        if (!stacks.isEmpty()) {
            Compatibility.jeiProxy.showRecipes(stacks);
        }
    }

    protected void renderBg(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        stack.blit(CRAFTING_FURNACE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics stack, int x, int y, float z) {
        super.render(stack, x, y, z);
        this.renderTooltip(stack, x, y);
    }

    public class OnButtonPress
    implements Button.OnPress {
        public void onPress(@NotNull Button button) {
            if (WindowFurnaceCrafting.this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
                ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
                input.add(new ItemStorage(((Slot)WindowFurnaceCrafting.this.container.slots.get(0)).getItem()));
                ItemStack primaryOutput = ((Slot)WindowFurnaceCrafting.this.container.slots.get(1)).getItem().copy();
                if (!ItemStackUtils.isEmpty(primaryOutput)) {
                    new AddRemoveRecipeMessage((IBuildingView)WindowFurnaceCrafting.this.building, input, 1, primaryOutput, false, Blocks.FURNACE, WindowFurnaceCrafting.this.module.getProducer().getRuntimeID()).sendToServer();
                }
            }
        }
    }
}

