/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.client.gui.AbstractBuildingMainWindow;
import com.minecolonies.core.client.gui.WindowHireWorker;
import com.minecolonies.core.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.core.network.messages.server.colony.building.ChangeDeliveryPriorityMessage;
import com.minecolonies.core.network.messages.server.colony.building.ForcePickupMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.RecallCitizenMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowWorkerModuleBuilding<B extends IBuildingView>
extends AbstractBuildingMainWindow<B> {
    private static final String BUTTON_HIRE = "hire";
    private static final String LIST_WORKERS = "workers";
    private static final String BUTTON_RECALL = "recall";
    private static final String LABEL_PRIO_VALUE = "prioValue";
    private static final String LABEL_WORKERNAME = "workerName";
    private static final String BUTTON_DP_UP = "deliveryPrioUp";
    private static final String BUTTON_DP_DOWN = "deliveryPrioDown";
    private static final String BUTTON_FORCE_PICKUP = "forcePickup";
    private int prio;

    protected AbstractWindowWorkerModuleBuilding(B building, ResourceLocation resource) {
        super(building, resource);
        this.prio = this.buildingView.getBuildingDmPrio();
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton(BUTTON_RECALL, this::recallClicked);
        super.registerButton(BUTTON_DP_UP, this::deliveryPriorityUp);
        super.registerButton(BUTTON_DP_DOWN, this::deliveryPriorityDown);
        super.registerButton(BUTTON_FORCE_PICKUP, this::forcePickup);
    }

    private void updatePriorityLabel() {
        MutableComponent component = this.prio == 0 ? Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.buildprio", (Object[])new Object[0]).append((Component)Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.deliveryprio.never", (Object[])new Object[0])) : Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.buildprio", (Object[])new Object[0]).append((Component)Component.literal((String)(this.prio + "/10")));
        ((Text)this.findPaneOfTypeByID(LABEL_PRIO_VALUE, Text.class)).setText((Component)component);
    }

    private void deliveryPriorityUp() {
        if (this.prio != 10) {
            ++this.prio;
        }
        new ChangeDeliveryPriorityMessage(this.buildingView, true).sendToServer();
        this.updatePriorityLabel();
    }

    private void deliveryPriorityDown() {
        if (this.prio != 0) {
            --this.prio;
        }
        new ChangeDeliveryPriorityMessage(this.buildingView, false).sendToServer();
        this.updatePriorityLabel();
    }

    private void forcePickup() {
        new ForcePickupMessage(this.buildingView).sendToServer();
    }

    protected void hireClicked(@NotNull Button button) {
        if (!this.buildingView.allowsAssignment()) {
            MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.level0", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
            return;
        }
        new WindowHireWorker(this.buildingView.getColony(), this.buildingView.getPosition()).open();
    }

    private void recallClicked() {
        new RecallCitizenMessage(this.buildingView).sendToServer();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        final ArrayList<Tuple<String, Integer>> workers = new ArrayList<Tuple<String, Integer>>();
        for (WorkerBuildingModuleView module : this.buildingView.getModuleViews(WorkerBuildingModuleView.class)) {
            for (int worker : module.getAssignedCitizens()) {
                workers.add(new Tuple<String, Integer>(Component.translatableEscape((String)module.getJobEntry().getTranslationKey(), (Object[])new Object[0]).getString(), worker));
            }
        }
        if (this.findPaneByID(LIST_WORKERS) != null) {
            ScrollingList workerList = (ScrollingList)this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
            workerList.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return workers.size();
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    ICitizenDataView worker = AbstractWindowWorkerModuleBuilding.this.buildingView.getColony().getCitizen((Integer)((Tuple)workers.get(index)).getB());
                    if (worker != null) {
                        Text workerNameField = (Text)rowPane.findPaneOfTypeByID(AbstractWindowWorkerModuleBuilding.LABEL_WORKERNAME, Text.class);
                        workerNameField.setText(Component.literal((String)(Component.translatable((String)((String)((Tuple)workers.get(index)).getA())).getString() + ": " + worker.getName())));
                        PaneBuilders.tooltipBuilder().hoverPane((Pane)workerNameField).build().setText(Component.literal((String)(worker.getName() + " (" + worker.getId() + ")")));
                    }
                }
            });
        }
        this.updatePriorityLabel();
    }
}

