/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.client.gui.AbstractBuildingWindow;
import com.minecolonies.core.client.gui.WindowBuildBuilding;
import com.minecolonies.core.client.gui.WindowHutAllInventory;
import com.minecolonies.core.client.gui.WindowHutNameEntry;
import com.minecolonies.core.client.gui.WindowInfo;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.building.BuildRequestMessage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractBuildingMainWindow<B extends IBuildingView>
extends AbstractBuildingWindow<B> {
    private final Text title;
    private final Button buttonBuild;

    public AbstractBuildingMainWindow(B buildingView, ResourceLocation resource) {
        super(buildingView, resource);
        this.registerButton("build", this::buildClicked);
        this.registerButton("info", this::infoClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.registerButton("allinventory", this::allInventoryClicked);
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        Button buttonInfo = (Button)this.findPaneOfTypeByID("info", Button.class);
        if (buttonInfo != null) {
            buttonInfo.setVisible(I18n.exists((String)("com.minecolonies.coremod.info." + buildingView.getBuildingType().getTranslationKey().replace("com.minecolonies.building.", "") + ".0")));
        }
    }

    @Override
    public void setPage(boolean relative, int page) {
        super.setPage(relative, page);
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
    }

    private void editName() {
        new WindowHutNameEntry(this.buildingView).open();
    }

    private void infoClicked() {
        new WindowInfo(this.buildingView).open();
    }

    private void allInventoryClicked() {
        new WindowHutAllInventory(this.buildingView, this).open();
    }

    private void buildClicked() {
        String buttonLabel;
        String string = buttonLabel = this.buttonBuild.getText().getContents() instanceof TranslatableContents ? ((TranslatableContents)this.buttonBuild.getText().getContents()).getKey() : this.buttonBuild.getTextAsString();
        if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelbuild") || buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelupgrade")) {
            new BuildRequestMessage(this.buildingView, BuildRequestMessage.Mode.BUILD, BlockPos.ZERO).sendToServer();
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelrepair")) {
            new BuildRequestMessage(this.buildingView, BuildRequestMessage.Mode.REPAIR, BlockPos.ZERO).sendToServer();
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.canceldeconstruction")) {
            new BuildRequestMessage(this.buildingView, BuildRequestMessage.Mode.REMOVE, BlockPos.ZERO).sendToServer();
        } else {
            new WindowBuildBuilding(this.buildingView.getColony(), this.buildingView).open();
        }
    }

    private void inventoryClicked() {
        new OpenInventoryMessage(this.buildingView).sendToServer();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateButtonBuild(this.buildingView);
    }

    private void updateButtonBuild(IBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild", (Object[])new Object[0]));
            } else {
                this.buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.cancelupgrade", (Object[])new Object[0]));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair", (Object[])new Object[0]));
        } else if (buildingView.isDeconstructing()) {
            this.buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.canceldeconstruction", (Object[])new Object[0]));
        } else {
            this.buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.buildrepair", (Object[])new Object[0]));
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.setPage(false, 0);
        if (this.title != null) {
            MutableComponent component = Component.translatableEscape((String)this.buildingView.getBuildingDisplayName(), (Object[])new Object[0]);
            MutableComponent componentWithLevel = component.append(" ").append(String.valueOf(this.buildingView.getBuildingLevel()));
            this.title.setText(componentWithLevel);
        }
    }
}

