/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.core.tileentities.TileEntityRack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTileEntityColonyBuilding
extends TileEntityRack
implements IBlueprintDataProviderBE {
    private static final String TAG_VERSION = "version";
    private static final int VERSION = 2;
    private BlockPos corner1 = BlockPos.ZERO;
    private BlockPos corner2 = BlockPos.ZERO;
    private String schematicName = "";
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
    private int version = 0;
    private Map<String, Set<BlockPos>> worldTagMapCache = null;
    private Map<String, List<BlockPos>> worldTagMapCacheWithList;

    public AbstractTileEntityColonyBuilding(BlockEntityType<? extends AbstractTileEntityColonyBuilding> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends TileEntityRack>)type, pos, state);
    }

    public static boolean isInTileEntity(IItemHandlerCapProvider entity, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryFunctions.matchFirstInProvider(entity, itemStackSelectionPredicate);
    }

    public abstract int getColonyId();

    public abstract IColony getColony();

    public abstract void setColony(IColony var1);

    public abstract BlockPos getPosition();

    @Nullable
    public abstract BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> var1);

    public abstract IBuilding getBuilding();

    public abstract void setBuilding(IBuilding var1);

    public abstract IBuildingView getBuildingView();

    public abstract boolean hasAccessPermission(Player var1);

    public abstract void setRotationMirror(RotationMirror var1);

    public abstract RotationMirror getRotationMirror();

    public abstract StructurePackMeta getStructurePack();

    public abstract void setStructurePack(StructurePackMeta var1);

    public abstract void setBlueprintPath(String var1);

    public abstract String getBlueprintPath();

    public abstract ResourceLocation getBuildingName();

    public String getSchematicName() {
        return this.schematicName.replace(".blueprint", "");
    }

    public void setSchematicName(String name) {
        this.schematicName = name;
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public Map<String, Set<BlockPos>> getWorldTagNamePosMap() {
        if (this.worldTagMapCache == null) {
            this.worldTagMapCache = super.getWorldTagNamePosMap();
        }
        return this.worldTagMapCache;
    }

    public Map<String, List<BlockPos>> getCachedWorldTagNamePosMap() {
        if (this.worldTagMapCacheWithList == null) {
            Map<String, Set<BlockPos>> worldTagNamePosMap = this.getWorldTagNamePosMap();
            this.worldTagMapCacheWithList = new HashMap<String, List<BlockPos>>();
            for (Map.Entry<String, Set<BlockPos>> entry : worldTagNamePosMap.entrySet()) {
                this.worldTagMapCacheWithList.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
        }
        return this.worldTagMapCacheWithList;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.worldTagMapCache = null;
        this.worldTagMapCacheWithList = null;
        this.setChanged();
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
        this.setChanged();
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.readSchematicDataFromNBT(compound);
        this.version = compound.getInt(TAG_VERSION);
    }

    public void readSchematicDataFromNBT(CompoundTag originalCompound) {
        String old = this.getSchematicName();
        super.readSchematicDataFromNBT(originalCompound);
        if (this.level == null || this.level.isClientSide || this.getColony() == null || this.getColony().getBuildingManager() == null) {
            return;
        }
        IBuilding building = this.getColony().getBuildingManager().getBuilding(this.worldPosition);
        if (building != null) {
            building.onUpgradeSchematicTo(old, this.getSchematicName(), this);
        }
        this.version = 2;
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.writeSchematicDataToNBT(compound);
        compound.putInt(TAG_VERSION, this.version);
    }

    public BlockPos getTilePos() {
        return this.worldPosition;
    }

    public boolean isOutdated() {
        return this.version < 2;
    }
}

