/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCraftingBrewingstand
extends AbstractContainerMenu {
    private final IItemHandler brewingStandInventory;
    private final Inventory playerInventory;
    public final BlockPos buildingPos;
    private int moduleId;

    public static ContainerCraftingBrewingstand fromFriendlyByteBuf(int windowId, Inventory inv, RegistryFriendlyByteBuf packetBuffer) {
        BlockPos tePos = packetBuffer.readBlockPos();
        int moduleId = packetBuffer.readInt();
        return new ContainerCraftingBrewingstand(windowId, inv, tePos, moduleId);
    }

    public ContainerCraftingBrewingstand(int windowId, Inventory inv, BlockPos pos, int moduleId) {
        super((MenuType)ModContainers.craftingBrewingstand.get(), windowId);
        int i;
        this.moduleId = moduleId;
        this.brewingStandInventory = new IItemHandlerModifiable(){
            ItemStack ingredient = ItemStack.EMPTY;
            ItemStack potion = ItemStack.EMPTY;

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                if (!this.isItemValid(slot, stack) && !ItemStackUtils.isEmpty(stack)) {
                    return;
                }
                ItemStack copy = stack.copy();
                copy.setCount(1);
                if (slot == 3) {
                    this.ingredient = copy;
                } else {
                    this.potion = copy;
                }
            }

            public int getSlots() {
                return 4;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                if (slot == 3) {
                    return this.ingredient;
                }
                return this.potion;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack) && !ItemStackUtils.isEmpty(stack)) {
                    return stack;
                }
                ItemStack copy = stack.copy();
                copy.setCount(1);
                if (slot == 3) {
                    this.ingredient = copy;
                } else {
                    this.potion = copy;
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 3) {
                    return ContainerCraftingBrewingstand.this.getWorldObj().potionBrewing().isIngredient(stack);
                }
                if (slot >= 0 && slot < 3) {
                    return ContainerCraftingBrewingstand.this.getWorldObj().potionBrewing().isInput(stack);
                }
                return false;
            }
        };
        this.playerInventory = inv;
        this.buildingPos = pos;
        this.addSlot((Slot)new InputItemHandler(this.brewingStandInventory, 0, 56, 51));
        this.addSlot((Slot)new InputItemHandler(this.brewingStandInventory, 1, 79, 58));
        this.addSlot((Slot)new InputItemHandler(this.brewingStandInventory, 2, 102, 51));
        this.addSlot((Slot)new SlotItemHandler(this.brewingStandInventory, 3, 79, 17));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void clicked(int slotId, int clickedButton, ClickType mode, Player playerIn) {
        if (slotId >= 0 && slotId < this.brewingStandInventory.getSlots()) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP || mode == ClickType.QUICK_MOVE) {
                Slot slot = (Slot)this.slots.get(slotId);
                this.handleSlotClick(slot, this.getCarried());
            }
        } else {
            super.clicked(slotId, clickedButton, mode, this.playerInventory.player);
        }
    }

    public void setInput(ItemStack stack) {
        this.handleSlotClick(this.getSlot(3), stack);
    }

    public void setContainer(ItemStack stack) {
        this.handleSlotClick(this.getSlot(0), stack);
        this.handleSlotClick(this.getSlot(1), stack);
        this.handleSlotClick(this.getSlot(2), stack);
    }

    private ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.getCount() > 0) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            slot.set(copy);
        } else if (slot.getItem().getCount() > 0) {
            slot.set(ItemStack.EMPTY);
        }
        return slot.getItem().copy();
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            if (index < 3) {
                this.setContainer(ItemStack.EMPTY);
                return ItemStack.EMPTY;
            }
            if (index == 3) {
                this.setInput(ItemStack.EMPTY);
                return ItemStack.EMPTY;
            }
            if (this.getWorldObj().potionBrewing().isIngredient(stack)) {
                this.setInput(stack);
                return ItemStack.EMPTY;
            }
            if (this.getWorldObj().potionBrewing().isInput(stack) && stack.getCount() == 1) {
                this.setContainer(stack);
                return ItemStack.EMPTY;
            }
        }
        return ItemStack.EMPTY;
    }

    public Player getPlayer() {
        return this.playerInventory.player;
    }

    public Level getWorldObj() {
        return this.playerInventory.player.level();
    }

    public BlockPos getPos() {
        return this.buildingPos;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    private static class InputItemHandler
    extends SlotItemHandler {
        public InputItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int getMaxStackSize() {
            return 1;
        }

        @NotNull
        public ItemStack remove(int par1) {
            return ItemStack.EMPTY;
        }

        public boolean mayPlace(@NotNull ItemStack par1ItemStack) {
            return true;
        }

        public boolean mayPickup(Player par1PlayerEntity) {
            return false;
        }
    }
}

