/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.other;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesMinecart
extends Minecart {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> MATRIX = (Map)Util.make((Object)Maps.newEnumMap(RailShape.class), entry -> {
        Vec3i westVec = Direction.WEST.getNormal();
        Vec3i eastVec = Direction.EAST.getNormal();
        Vec3i northVec = Direction.NORTH.getNormal();
        Vec3i southVec = Direction.SOUTH.getNormal();
        entry.put(RailShape.NORTH_SOUTH, Pair.of((Object)northVec, (Object)southVec));
        entry.put(RailShape.EAST_WEST, Pair.of((Object)westVec, (Object)eastVec));
        entry.put(RailShape.ASCENDING_EAST, Pair.of((Object)westVec.below(), (Object)eastVec));
        entry.put(RailShape.ASCENDING_WEST, Pair.of((Object)westVec, (Object)eastVec.below()));
        entry.put(RailShape.ASCENDING_NORTH, Pair.of((Object)northVec, (Object)southVec.below()));
        entry.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)northVec.below(), (Object)southVec));
        entry.put(RailShape.SOUTH_EAST, Pair.of((Object)southVec, (Object)eastVec));
        entry.put(RailShape.SOUTH_WEST, Pair.of((Object)southVec, (Object)westVec));
        entry.put(RailShape.NORTH_WEST, Pair.of((Object)northVec, (Object)westVec));
        entry.put(RailShape.NORTH_EAST, Pair.of((Object)northVec, (Object)eastVec));
    });

    public MinecoloniesMinecart(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state) {
        double tempVeloc;
        Vec3 tempMot;
        double xzDif;
        this.fallDistance = 0.0f;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Vec3 posVec = this.getPos(x, y, z);
        y = pos.getY();
        boolean isPowered = false;
        boolean flag = false;
        BaseRailBlock abstractrailblock = (BaseRailBlock)state.getBlock();
        if (abstractrailblock instanceof PoweredRailBlock && !((PoweredRailBlock)abstractrailblock).isActivatorRail()) {
            isPowered = (Boolean)state.getValue((Property)PoweredRailBlock.POWERED);
            flag = !isPowered;
        }
        RailShape railshape = ((BaseRailBlock)state.getBlock()).getRailDirection(state, (BlockGetter)this.level(), pos, (AbstractMinecart)this);
        switch (railshape) {
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                y += 1.0;
                break;
            }
        }
        Vec3 motion = this.getDeltaMovement();
        Pair<Vec3i, Vec3i> pair = MinecoloniesMinecart.getShapeMatrix(railshape);
        Vec3i vecIn = (Vec3i)pair.getFirst();
        Vec3i vecOut = (Vec3i)pair.getSecond();
        double xDif = vecOut.getX() - vecIn.getX();
        double zDif = vecOut.getZ() - vecIn.getZ();
        double difSq = Math.sqrt(xDif * xDif + zDif * zDif);
        double difMotion = motion.x * xDif + motion.z * zDif;
        if (difMotion < 0.0) {
            xDif = -xDif;
            zDif = -zDif;
        }
        double veloc = Math.min(2.0, Math.sqrt(motion.horizontalDistanceSqr()));
        motion = new Vec3(veloc * xDif / difSq, motion.y, veloc * zDif / difSq);
        this.setDeltaMovement(motion);
        if (flag && this.shouldDoRailFunctions()) {
            double tempMot2 = Math.sqrt(this.getDeltaMovement().horizontalDistanceSqr());
            if (tempMot2 < 0.03) {
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double xInDif = (double)pos.getX() + 0.5 + (double)vecIn.getX() * 0.5;
        double zInDif = (double)pos.getZ() + 0.5 + (double)vecIn.getZ() * 0.5;
        double xOutDif = (double)pos.getX() + 0.5 + (double)vecOut.getX() * 0.5;
        double zOutDif = (double)pos.getZ() + 0.5 + (double)vecOut.getZ() * 0.5;
        xDif = xOutDif - xInDif;
        zDif = zOutDif - zInDif;
        if (xDif == 0.0) {
            xzDif = z - (double)pos.getZ();
        } else if (zDif == 0.0) {
            xzDif = x - (double)pos.getX();
        } else {
            double d15 = x - xInDif;
            double d16 = z - zInDif;
            xzDif = (d15 * xDif + d16 * zDif) * 2.0;
        }
        x = xInDif + xDif * xzDif;
        z = zInDif + zDif * xzDif;
        this.setPos(x, y, z);
        this.moveMinecartOnRail(pos);
        if (vecIn.getY() != 0 && Mth.floor((double)this.getX()) - pos.getX() == vecIn.getX() && Mth.floor((double)this.getZ()) - pos.getZ() == vecIn.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)vecIn.getY(), this.getZ());
        } else if (vecOut.getY() != 0 && Mth.floor((double)this.getX()) - pos.getX() == vecOut.getX() && Mth.floor((double)this.getZ()) - pos.getZ() == vecOut.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)vecOut.getY(), this.getZ());
        }
        this.applyNaturalSlowdown();
        Vec3 newPos = this.getPos(this.getX(), this.getY(), this.getZ());
        if (newPos != null && posVec != null) {
            double yMot = (posVec.y - newPos.y) * 0.05;
            tempMot = this.getDeltaMovement();
            tempVeloc = Math.sqrt(tempMot.horizontalDistanceSqr());
            if (tempVeloc > 0.0) {
                this.setDeltaMovement(tempMot.multiply((tempVeloc + yMot) / tempVeloc, 1.0, (tempVeloc + yMot) / tempVeloc));
            }
            this.setPos(this.getX(), newPos.y, this.getZ());
        }
        int xFloor = Mth.floor((double)this.getX());
        int zFloor = Mth.floor((double)this.getZ());
        if (xFloor != pos.getX() || zFloor != pos.getZ()) {
            tempMot = this.getDeltaMovement();
            double temoVeloc = Math.sqrt(tempMot.horizontalDistanceSqr());
            this.setDeltaMovement(temoVeloc * (double)(xFloor - pos.getX()), tempMot.y, temoVeloc * (double)(zFloor - pos.getZ()));
        }
        if (this.shouldDoRailFunctions()) {
            ((BaseRailBlock)state.getBlock()).onMinecartPass(state, this.level(), pos, (AbstractMinecart)this);
        }
        if (isPowered && this.shouldDoRailFunctions()) {
            tempMot = this.getDeltaMovement();
            tempVeloc = Math.sqrt(tempMot.horizontalDistanceSqr());
            if (tempVeloc > 0.01) {
                this.setDeltaMovement(tempMot.add(tempMot.x / tempVeloc * 0.06, 0.0, tempMot.z / tempVeloc * 0.06));
            } else {
                Vec3 mot = this.getDeltaMovement();
                double tempX = mot.x;
                double tempZ = mot.z;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isNormalCube(pos.west())) {
                        tempX = 0.02;
                    } else if (this.isNormalCube(pos.east())) {
                        tempX = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isNormalCube(pos.north())) {
                        tempZ = 0.02;
                    } else if (this.isNormalCube(pos.south())) {
                        tempZ = -0.02;
                    }
                }
                this.setDeltaMovement(tempX, mot.y, tempZ);
            }
        }
    }

    public void destroy(DamageSource source) {
        this.kill();
    }

    private boolean isNormalCube(BlockPos pos) {
        return this.level().getBlockState(pos).isRedstoneConductor((BlockGetter)this.level(), pos);
    }

    private static Pair<Vec3i, Vec3i> getShapeMatrix(RailShape p_226573_0_) {
        return MATRIX.get(p_226573_0_);
    }

    public InteractionResult interact(Player p_184230_1_, InteractionHand p_184230_2_) {
        return InteractionResult.FAIL;
    }

    public boolean isPickable() {
        return false;
    }

    @NotNull
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    public void push(@NotNull Entity entityIn) {
    }

    public void playerTouch(Player entityIn) {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canCollideWith(Entity p_38168_) {
        return false;
    }

    public void tick() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                --this.lerpSteps;
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
        } else {
            double d4;
            if (!this.isNoGravity()) {
                double d0 = this.isInWater() ? -0.005 : -0.04;
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, d0, 0.0));
            }
            int k = Mth.floor((double)this.getX());
            int i = Mth.floor((double)this.getY());
            int j = Mth.floor((double)this.getZ());
            if (this.level().getBlockState(new BlockPos(k, i - 1, j)).is(BlockTags.RAILS)) {
                --i;
            }
            BlockPos blockpos = new BlockPos(k, i, j);
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (this.canUseRail() && BaseRailBlock.isRail((BlockState)blockstate)) {
                this.moveAlongTrack(blockpos, blockstate);
                if (blockstate.getBlock() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.getBlock()).isActivatorRail()) {
                    this.activateMinecart(k, i, j, (Boolean)blockstate.getValue((Property)PoweredRailBlock.POWERED));
                }
            } else {
                this.comeOffTrack();
            }
            this.checkInsideBlocks();
            this.setXRot(0.0f);
            double d1 = this.xo - this.getX();
            double d3 = this.zo - this.getZ();
            if (d1 * d1 + d3 * d3 > 0.001) {
                this.setYRot((float)(Mth.atan2((double)d3, (double)d1) * 180.0 / Math.PI));
                if (this.flipped) {
                    this.setYRot(this.getYRot() + 180.0f);
                }
            }
            if ((d4 = (double)Mth.wrapDegrees((float)(this.getYRot() - this.yRotO))) < -170.0 || d4 >= 170.0) {
                this.setYRot(this.getYRot() + 180.0f);
                this.flipped = !this.flipped;
            }
            this.setRot(this.getYRot(), this.getXRot());
            this.updateInWaterStateAndDoFluidPushing();
            if (this.isInLava()) {
                this.lavaHurt();
                this.fallDistance *= 0.5f;
            }
            this.firstTick = false;
        }
        if (this.tickCount % 20 == 19 && this.getPassengers().isEmpty()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(@NotNull Entity p_294753_, @NotNull EntityDimensions p_295251_, float p_296054_) {
        return LOWERED_PASSENGER_ATTACHMENT;
    }
}

