/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.entity.other.MinecoloniesMinecart;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.entity.other.SittingEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCivilianEntity
extends AbstractFastMinecoloniesEntity
implements Npc {
    protected long nextPlayerCollisionTime = 0L;

    protected AbstractCivilianEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public abstract void setCivilianData(@Nullable ICivilianData var1);

    public abstract ICivilianData getCivilianData();

    public abstract void markDirty(int var1);

    public abstract int getCivilianID();

    public abstract void setCitizenId(int var1);

    @Override
    public boolean checkBedExists() {
        if (this.tickCount % 5 == this.randomVariance % 5) {
            return true;
        }
        if (this.getSleepingPos().isPresent()) {
            BlockPos pos = (BlockPos)this.getSleepingPos().get();
            BlockState state = this.level().getBlockState((BlockPos)this.getSleepingPos().get());
            return state.getBlock().isBed(state, (BlockGetter)this.level(), pos, (LivingEntity)this);
        }
        return false;
    }

    public void push(@NotNull Entity entityIn) {
        if (entityIn instanceof ServerPlayer) {
            this.onPlayerCollide((Player)entityIn);
        }
        super.push(entityIn);
    }

    public void onPlayerCollide(Player player) {
        if (player.level().getGameTime() > this.nextPlayerCollisionTime) {
            this.nextPlayerCollisionTime = player.level().getGameTime() + 300L;
            this.getNavigation().stop();
            this.getLookControl().setLookAt((Entity)player);
            SoundUtils.playSoundAtCitizenWith(this.level(), this.blockPosition(), EventType.GREETING, this.getCivilianData());
        }
    }

    public abstract void queueSound(@NotNull SoundEvent var1, BlockPos var2, int var3, int var4);

    public abstract void queueSound(@NotNull SoundEvent var1, BlockPos var2, int var3, int var4, float var5, float var6);

    public String toString() {
        ICivilianData data = this.getCivilianData();
        String id = data == null ? "none" : "" + data.getId();
        String colony = data == null ? "none" : data.getColony().getName();
        return "Enity: " + this.getDisplayName().getString() + " Type: [" + this.getClass().getSimpleName() + "] at pos: " + String.valueOf(this.blockPosition()) + " civilian id: " + id + " colony: " + colony;
    }

    public boolean startRiding(@NotNull Entity entity, boolean force) {
        if (entity instanceof SittingEntity || entity instanceof MinecoloniesMinecart) {
            return super.startRiding(entity, force);
        }
        return false;
    }
}

