/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.statemachine.basestatemachine;

import com.minecolonies.api.entity.ai.statemachine.basestatemachine.IStateMachine;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.states.IStateEventType;
import com.minecolonies.api.entity.ai.statemachine.transitions.IStateMachineEvent;
import com.minecolonies.api.entity.ai.statemachine.transitions.IStateMachineOneTimeEvent;
import com.minecolonies.api.entity.ai.statemachine.transitions.IStateMachineTransition;
import com.minecolonies.api.util.Log;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public class BasicStateMachine<T extends IStateMachineTransition<S>, S extends IState>
implements IStateMachine<T, S> {
    @NotNull
    protected final Map<S, List<T>> transitionMap;
    @NotNull
    protected final Map<IStateEventType, List<T>> eventTransitionMap;
    protected List<T> currentStateTransitions;
    @NotNull
    private S state;
    @NotNull
    private final S initState;
    @NotNull
    private final Consumer<RuntimeException> exceptionHandler;
    private boolean historyEnabled = !FMLEnvironment.production;
    private int historyIndex = -1;
    private Component[] stateHistory = new Component[20];
    DateTimeFormatter SIMPLE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    protected BasicStateMachine(@NotNull S initialState, @NotNull Consumer<RuntimeException> exceptionHandler) {
        this.state = initialState;
        this.initState = initialState;
        this.exceptionHandler = exceptionHandler;
        this.transitionMap = new HashMap<S, List<T>>();
        this.currentStateTransitions = new ArrayList<T>();
        this.transitionMap.put(initialState, this.currentStateTransitions);
        this.eventTransitionMap = new HashMap<IStateEventType, List<T>>();
    }

    @Override
    public void addTransition(T transition) {
        if (transition.getState() != null) {
            this.transitionMap.computeIfAbsent(transition.getState(), k -> new ArrayList()).add(transition);
        }
        if (transition instanceof IStateMachineEvent) {
            this.eventTransitionMap.computeIfAbsent(((IStateMachineEvent)transition).getEventType(), k -> new ArrayList()).add(transition);
        }
    }

    @Override
    public void addTransitionGroup(List<S> stateGroup, T transition) {
        if (transition.getState() != null) {
            throw new RuntimeException("Only transitions without a state may act as group transitions");
        }
        for (IState state : stateGroup) {
            if (state == null) continue;
            this.transitionMap.computeIfAbsent(state, k -> new ArrayList()).add(0, transition);
        }
        if (transition instanceof IStateMachineEvent) {
            this.eventTransitionMap.computeIfAbsent(((IStateMachineEvent)transition).getEventType(), k -> new ArrayList()).add(0, transition);
        }
    }

    @Override
    public void removeTransition(T transition) {
        if (transition instanceof IStateMachineEvent) {
            this.eventTransitionMap.get(((IStateMachineEvent)transition).getEventType()).removeIf(t -> t == transition);
        } else {
            this.transitionMap.get(transition.getState()).removeIf(t -> t == transition);
        }
    }

    @Override
    public void tick() {
        for (List<T> transitions : this.eventTransitionMap.values()) {
            for (IStateMachineTransition transition : transitions) {
                if (!this.checkTransition(transition)) continue;
                return;
            }
        }
        for (IStateMachineTransition transition : this.currentStateTransitions) {
            if (!this.checkTransition(transition)) continue;
            return;
        }
    }

    @Override
    public boolean checkTransition(@NotNull T transition) {
        try {
            if (!transition.checkCondition()) {
                return false;
            }
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Condition check for state " + String.valueOf(this.getState()) + " threw an exception:", (Throwable)e);
            this.onException(e);
            return false;
        }
        return this.transitionToNext(transition);
    }

    @Override
    public boolean transitionToNext(@NotNull T transition) {
        Object newState;
        try {
            newState = transition.getNextState();
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Statemachine for state " + String.valueOf(this.getState()) + " threw an exception:", (Throwable)e);
            this.onException(e);
            return false;
        }
        if (newState != null) {
            if (transition instanceof IStateMachineOneTimeEvent && ((IStateMachineOneTimeEvent)transition).shouldRemove()) {
                this.removeTransition(transition);
            }
            if (newState != this.state) {
                this.currentStateTransitions = this.transitionMap.get(newState);
                if (this.currentStateTransitions == null || this.currentStateTransitions.isEmpty()) {
                    this.onException(new RuntimeException("Missing AI transition for state: " + String.valueOf(newState)));
                    this.reset();
                    return true;
                }
                if (this.historyEnabled) {
                    this.historyIndex = (this.historyIndex + 1) % this.stateHistory.length;
                    this.stateHistory[this.historyIndex] = Component.literal((String)(LocalTime.now().format(this.SIMPLE_TIME) + " ")).withStyle(ChatFormatting.GRAY).append(transition.getName()).append((Component)Component.literal((String)"->").append((Component)Component.literal((String)newState.toString()).withStyle(ChatFormatting.LIGHT_PURPLE)));
                }
            }
            this.state = newState;
            return true;
        }
        return false;
    }

    protected void onException(RuntimeException e) {
        this.historyEnabled = true;
        this.exceptionHandler.accept(e);
    }

    @Override
    public final S getState() {
        return this.state;
    }

    @Override
    public void reset() {
        this.state = this.initState;
        this.currentStateTransitions = this.transitionMap.get(this.initState);
    }

    @Override
    public void setHistoryEnabled(boolean enabled, int memorySize) {
        if (enabled == this.historyEnabled && memorySize == this.stateHistory.length) {
            return;
        }
        this.historyEnabled = enabled;
        this.stateHistory = new Component[memorySize];
    }

    @Override
    public Component getHistory() {
        MutableComponent history = Component.literal((String)"Current state:").append((Component)Component.literal((String)(String.valueOf(this.state) + "\n")).withStyle(ChatFormatting.GOLD));
        int index = this.historyIndex;
        for (int i = 0; i < this.stateHistory.length; ++i) {
            Component entry = this.stateHistory[index = (index + 1 + this.stateHistory.length) % this.stateHistory.length];
            if (entry == null) continue;
            history.append(entry).append("\n");
        }
        return history;
    }
}

