/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.dynamictrees;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.item.Seed;
import com.dtteam.dynamictrees.tree.family.Family;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeProxy;
import com.minecolonies.api.util.Log;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public final class DynamicTreeCompat
extends DynamicTreeProxy {
    private static final Map<ResourceKey<Level>, FakePlayer> fakePlayers = new HashMap<ResourceKey<Level>, FakePlayer>();

    @Override
    public boolean isDynamicTreePresent() {
        return true;
    }

    @Override
    public boolean checkForDynamicTreeBlock(@NotNull Block block) {
        return block instanceof BranchBlock;
    }

    @Override
    public boolean checkForDynamicLeavesBlock(Block block) {
        return block instanceof DynamicLeavesBlock;
    }

    @Override
    public boolean checkForDynamicTrunkShellBlock(Block block) {
        return block instanceof TrunkShellBlock;
    }

    @Override
    public NonNullList<ItemStack> getDropsForLeaf(LevelAccessor world, BlockPos pos, BlockState blockstate, int fortune, Block leaf) {
        if (leaf instanceof DynamicLeavesBlock) {
            DynamicLeavesBlock leaves = (DynamicLeavesBlock)leaf;
            ItemStack stack = leaves.getFamily(blockstate, (BlockGetter)world, pos).getCommonSpecies().getSeedStack(1);
            NonNullList list = NonNullList.create();
            list.add((Object)stack);
            return list;
        }
        return NonNullList.create();
    }

    @Override
    public boolean checkForDynamicSapling(@NotNull Item item) {
        return item instanceof Seed;
    }

    @Override
    public Runnable getTreeBreakActionCompat(@NotNull Level world, @NotNull BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return () -> {
            BlockState curBlockState = world.getBlockState(blockToBreak);
            Block curBlock = curBlockState.getBlock();
            if (world.getServer() == null) {
                Log.getLogger().error("Minecolonies:DynamicTreeCompat unexpected null while trying to get World");
                return;
            }
            ResourceKey dim = world.dimension();
            FakePlayer fake = fakePlayers.get(dim);
            if (fake == null) {
                fakePlayers.put((ResourceKey<Level>)dim, new FakePlayer((ServerLevel)world, new GameProfile(UUID.randomUUID(), "minecolonies_LumberjackFake")));
                fake = fakePlayers.get(dim);
            }
            if (workerPos != null) {
                fake.setPos((double)workerPos.getX(), (double)workerPos.getY(), (double)workerPos.getZ());
            }
            if (toolToUse != null) {
                fake.setItemInHand(InteractionHand.MAIN_HAND, toolToUse);
            }
            curBlock.onDestroyedByPlayer(curBlockState, world, blockToBreak, (Player)fake, true, world.getFluidState(blockToBreak));
        };
    }

    @Override
    public boolean plantDynamicSaplingCompat(@NotNull Level world, @NotNull BlockPos location, @NotNull ItemStack saplingStack) {
        Item item = saplingStack.getItem();
        if (item instanceof Seed) {
            Seed seed = (Seed)item;
            return seed.getSpecies().plantSapling((LevelAccessor)world, location, false);
        }
        return false;
    }

    @Override
    public boolean hasFittingTreeFamilyCompat(@NotNull BlockPos block1, @NotNull BlockPos block2, @NotNull LevelAccessor world) {
        Family fam1 = DynamicTreeCompat.getFamilyForBlock(block1, world);
        Family fam2 = DynamicTreeCompat.getFamilyForBlock(block2, world);
        if (fam1 != null && fam2 != null) {
            return fam1 == fam2;
        }
        return false;
    }

    private static Family getFamilyForBlock(@NotNull BlockPos blockPos, @NotNull LevelAccessor world) {
        Block block = world.getBlockState(blockPos).getBlock();
        if (block instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)block;
            return branch.getFamily();
        }
        if (block instanceof DynamicLeavesBlock) {
            DynamicLeavesBlock leaves = (DynamicLeavesBlock)block;
            return leaves.getFamily(world.getBlockState(blockPos), (BlockGetter)world, blockPos);
        }
        return null;
    }
}

