/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.permissions;

import com.minecolonies.api.colony.permissions.Action;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class PermissionEvent {
    @Nullable
    private final UUID id;
    private final String name;
    private final Action action;
    private final BlockPos position;

    public PermissionEvent(UUID id, String name, Action action, BlockPos position) {
        this.id = id;
        this.name = name;
        this.action = action;
        this.position = position;
    }

    public PermissionEvent(RegistryFriendlyByteBuf buf) {
        UUID uuid = buf.readUUID();
        this.id = uuid.equals(UUID.fromString("1-2-3-4-5")) ? null : uuid;
        this.name = buf.readUtf(Short.MAX_VALUE);
        this.action = Action.valueOf(buf.readUtf(Short.MAX_VALUE));
        this.position = buf.readBlockPos();
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Action getAction() {
        return this.action;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void serialize(RegistryFriendlyByteBuf buf) {
        if (this.id == null) {
            buf.writeUUID(UUID.fromString("1-2-3-4-5"));
        } else {
            buf.writeUUID(this.id);
        }
        buf.writeUtf(this.name);
        buf.writeUtf(this.action.toString());
        buf.writeBlockPos(this.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionEvent that = (PermissionEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.action == that.action && Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.action, this.position});
    }
}

