/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.colonyEvents.registry;

import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.util.Log;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ColonyEventDescriptionTypeRegistryEntry {
    private final BiFunction<HolderLookup.Provider, CompoundTag, IColonyEventDescription> nbtEventDescriptionCreator;
    private final Function<RegistryFriendlyByteBuf, IColonyEventDescription> packetBufferEventDescriptionCreator;
    private final ResourceLocation registryName;

    public ColonyEventDescriptionTypeRegistryEntry(@NotNull BiFunction<HolderLookup.Provider, CompoundTag, IColonyEventDescription> nbtEventCreator, @NotNull Function<RegistryFriendlyByteBuf, IColonyEventDescription> packetBufferEventCreator, @NotNull ResourceLocation registryID) {
        if (registryID.getPath().isEmpty()) {
            Log.getLogger().warn("Created empty registry empty for event, supply a name for it!");
        }
        this.nbtEventDescriptionCreator = nbtEventCreator;
        this.packetBufferEventDescriptionCreator = packetBufferEventCreator;
        this.registryName = registryID;
    }

    public IColonyEventDescription deserializeEventDescriptionFromNBT(@NotNull HolderLookup.Provider provider, @Nonnull CompoundTag compound) {
        return this.nbtEventDescriptionCreator.apply(provider, compound);
    }

    public IColonyEventDescription deserializeEventDescriptionFromFriendlyByteBuf(@Nonnull RegistryFriendlyByteBuf buffer) {
        return this.packetBufferEventDescriptionCreator.apply(buffer);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

