/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.types;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public enum BarrelType implements StringRepresentable
{
    ZERO(0, "0perc", MapColor.WOOD),
    TWENTY(1, "20perc", MapColor.WOOD),
    FORTY(2, "40perc", MapColor.WOOD),
    SIXTY(3, "60perc", MapColor.WOOD),
    EIGHTY(4, "80perc", MapColor.WOOD),
    HUNDRED(5, "100perc", MapColor.WOOD),
    WORKING(6, "working", MapColor.WOOD),
    DONE(7, "done", MapColor.WOOD);

    private static final BarrelType[] META_LOOKUP;
    private final int meta;
    private final String name;
    private final String unlocalizedName;
    private final MapColor mapColor;

    private BarrelType(int metaIn, String nameIn, MapColor mapColorIn) {
        this(metaIn, nameIn, nameIn, mapColorIn);
    }

    private BarrelType(int metaIn, String nameIn, String unlocalizedNameIn, MapColor mapColorIn) {
        this.meta = metaIn;
        this.name = nameIn;
        this.unlocalizedName = unlocalizedNameIn;
        this.mapColor = mapColorIn;
    }

    public static BarrelType byMetadata(int meta) {
        int tempMeta = meta;
        if (tempMeta < 0 || tempMeta >= META_LOOKUP.length) {
            tempMeta = 0;
        }
        return META_LOOKUP[tempMeta];
    }

    public int getMetadata() {
        return this.meta;
    }

    public MapColor getMaterialColor() {
        return this.mapColor;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.unlocalizedName;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        META_LOOKUP = new BarrelType[BarrelType.values().length];
        BarrelType[] barrelTypeArray = BarrelType.values();
        int n = barrelTypeArray.length;
        for (int i = 0; i < n; ++i) {
            BarrelType enumtype;
            BarrelType.META_LOOKUP[enumtype.getMetadata()] = enumtype = barrelTypeArray[i];
        }
    }
}

