/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.mi_sound_addon.sound;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import dev.thestaticvoid.mi_sound_addon.MISoundAddon;
import dev.thestaticvoid.mi_sound_addon.MISoundAddonConfig;
import dev.thestaticvoid.mi_sound_addon.sound.ModSoundEventInfo;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModSounds {
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"mi_sound_addon");
    public static HashMap<String, ModSoundEventInfo> SOUND_EVENTS = new HashMap();
    private static final int DEFAULT_SOUND_DURATION = 60;

    public static void init(IEventBus bus) {
        MISoundAddon.LOGGER.debug("Registering sounds for mi_sound_addon");
        ModSounds.populateDefaultRecipeTypes(MIMachineRecipeTypes.getRecipeTypes());
        for (MachineRecipeType mrt : MIMachineRecipeTypes.getRecipeTypes()) {
            MISoundAddon.LOGGER.debug(mrt.getPath());
        }
        SOUND_EVENTS_REGISTRY.register(bus);
    }

    public static void populateDefaultRecipeTypes(List<MachineRecipeType> machineRecipeTypes) {
        for (MachineRecipeType mrt : machineRecipeTypes) {
            String type = mrt.getPath();
            if (type.equals("forge_hammer")) continue;
            ModSounds.addSoundEvent(type);
        }
        ModSounds.addSoundEvent("electric_blast_furnace");
        ModSounds.addSoundEvent("fission_reactor");
        ModSounds.addSoundEvent("wrench");
        ModSounds.addSoundEvent("replicator");
        ModSounds.updateDurations();
    }

    public static void addSoundEvent(String type) {
        ModSounds.addSoundEvent(type, 1.0f);
    }

    public static void addSoundEvent(String type, float volume) {
        ModSounds.addSoundEvent(type, volume, 60);
    }

    public static void addSoundEvent(String type, float volume, int duration) {
        ResourceLocation identifier = MISoundAddon.id(type);
        DeferredHolder soundEvent = SOUND_EVENTS_REGISTRY.register(type, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)identifier));
        SOUND_EVENTS.put(type, new ModSoundEventInfo((Supplier<SoundEvent>)soundEvent, duration, volume));
    }

    private static String getRecipeType(@NotNull MachineRecipe activeRecipe) {
        return ((MachineRecipeType)activeRecipe.getType()).getPath();
    }

    public static int getDuration(MachineRecipe activeRecipe) {
        if (SOUND_EVENTS.get(ModSounds.getRecipeType(activeRecipe)) != null) {
            return SOUND_EVENTS.get(ModSounds.getRecipeType(activeRecipe)).getSoundDuration();
        }
        return 60;
    }

    public static int getDurationFromString(String type) {
        return SOUND_EVENTS.get(type).getSoundDuration();
    }

    public static void setDuration(String type, int duration) {
        if (!SOUND_EVENTS.containsKey(type)) {
            throw new IllegalStateException("Tried to set duration of non-existent recipe type: " + type);
        }
        SOUND_EVENTS.get(type).setSoundDuration(duration);
    }

    public static void setVolume(String type, float volume) {
        if (!SOUND_EVENTS.containsKey(type)) {
            throw new IllegalStateException("Tried to set volume of non-existent recipe type: " + type);
        }
        SOUND_EVENTS.get(type).setVolume(volume);
    }

    public static void playSound(@NotNull MachineBlockEntity blockEntity, MachineRecipe activeRecipe) {
        Level world = blockEntity.getLevel();
        if (world == null) {
            return;
        }
        if (activeRecipe == null) {
            return;
        }
        ModSoundEventInfo soundEventInfo = !blockEntity.guiParams.blockId.getPath().equals("electric_blast_furnace") ? SOUND_EVENTS.get(ModSounds.getRecipeType(activeRecipe)) : SOUND_EVENTS.get("electric_blast_furnace");
        if (soundEventInfo != null && soundEventInfo.getSoundEvent() != null) {
            world.playSound(null, (double)blockEntity.getBlockPos().getX(), (double)blockEntity.getBlockPos().getY(), (double)blockEntity.getBlockPos().getZ(), soundEventInfo.getSoundEvent().get(), SoundSource.BLOCKS, soundEventInfo.getVolume(), 1.0f);
        }
    }

    public static void playSoundNoRecipe(@NotNull MachineBlockEntity blockEntity, String type) {
        Level world = blockEntity.getLevel();
        if (world == null) {
            return;
        }
        ModSoundEventInfo soundEventInfo = SOUND_EVENTS.get(type);
        if (soundEventInfo.getSoundEvent() != null) {
            world.playSound(null, (double)blockEntity.getBlockPos().getX(), (double)blockEntity.getBlockPos().getY(), (double)blockEntity.getBlockPos().getZ(), soundEventInfo.getSoundEvent().get(), SoundSource.BLOCKS, soundEventInfo.getVolume(), 1.0f);
        }
    }

    private static void updateDurations() {
        ModSounds.setDuration("assembler", 39);
        ModSounds.setDuration("blast_furnace", 31);
        ModSounds.setDuration("centrifuge", 39);
        ModSounds.setDuration("chemical_reactor", 80);
        ModSounds.setDuration("coke_oven", 34);
        ModSounds.setDuration("compressor", 30);
        ModSounds.setDuration("cutting_machine", 68);
        ModSounds.setDuration("distillation_tower", 109);
        ModSounds.setDuration("distillery", 71);
        ModSounds.setDuration("electric_blast_furnace", 61);
        ModSounds.setDuration("electrolyzer", 7);
        ModSounds.setDuration("fission_reactor", 60);
        ModSounds.setDuration("fusion_reactor", 67);
        ModSounds.setDuration("furnace", 38);
        ModSounds.setDuration("heat_exchanger", 71);
        ModSounds.setDuration("implosion_compressor", 70);
        ModSounds.setDuration("macerator", 16);
        ModSounds.setDuration("mixer", 27);
        ModSounds.setDuration("oil_drilling_rig", 29);
        ModSounds.setDuration("packer", 23);
        ModSounds.setDuration("polarizer", 29);
        ModSounds.setDuration("pressurizer", 89);
        ModSounds.setDuration("quarry", 61);
        ModSounds.setDuration("unpacker", 23);
        ModSounds.setDuration("vacuum_freezer", 62);
        ModSounds.setDuration("wiremill", 45);
        ModSounds.setDuration("replicator", 20);
    }

    public static void updateVolumes() {
        ModSounds.setVolume("assembler", (float)((Double)MISoundAddonConfig.CONFIG.assemblerVolume.get()).doubleValue());
        ModSounds.setVolume("blast_furnace", (float)((Double)MISoundAddonConfig.CONFIG.blastFurnaceVolume.get()).doubleValue());
        ModSounds.setVolume("centrifuge", (float)((Double)MISoundAddonConfig.CONFIG.centrifugeVolume.get()).doubleValue());
        ModSounds.setVolume("chemical_reactor", (float)((Double)MISoundAddonConfig.CONFIG.chemicalReactorVolume.get()).doubleValue());
        ModSounds.setVolume("coke_oven", (float)((Double)MISoundAddonConfig.CONFIG.cokeOvenVolume.get()).doubleValue());
        ModSounds.setVolume("compressor", (float)((Double)MISoundAddonConfig.CONFIG.compressorVolume.get()).doubleValue());
        ModSounds.setVolume("cutting_machine", (float)((Double)MISoundAddonConfig.CONFIG.cuttingMachineVolume.get()).doubleValue());
        ModSounds.setVolume("distillation_tower", (float)((Double)MISoundAddonConfig.CONFIG.distillationTowerVolume.get()).doubleValue());
        ModSounds.setVolume("distillery", (float)((Double)MISoundAddonConfig.CONFIG.distilleryVolume.get()).doubleValue());
        ModSounds.setVolume("electric_blast_furnace", (float)((Double)MISoundAddonConfig.CONFIG.electricBlastFurnaceVolume.get()).doubleValue());
        ModSounds.setVolume("electrolyzer", (float)((Double)MISoundAddonConfig.CONFIG.electrolyzerVolume.get()).doubleValue());
        ModSounds.setVolume("fission_reactor", (float)((Double)MISoundAddonConfig.CONFIG.fissionReactorVolume.get()).doubleValue());
        ModSounds.setVolume("fusion_reactor", (float)((Double)MISoundAddonConfig.CONFIG.fusionReactorVolume.get()).doubleValue());
        ModSounds.setVolume("furnace", (float)((Double)MISoundAddonConfig.CONFIG.furnaceVolume.get()).doubleValue());
        ModSounds.setVolume("heat_exchanger", (float)((Double)MISoundAddonConfig.CONFIG.heatExchangerVolume.get()).doubleValue());
        ModSounds.setVolume("implosion_compressor", (float)((Double)MISoundAddonConfig.CONFIG.implosionCompressorVolume.get()).doubleValue());
        ModSounds.setVolume("macerator", (float)((Double)MISoundAddonConfig.CONFIG.maceratorVolume.get()).doubleValue());
        ModSounds.setVolume("mixer", (float)((Double)MISoundAddonConfig.CONFIG.mixerVolume.get()).doubleValue());
        ModSounds.setVolume("oil_drilling_rig", (float)((Double)MISoundAddonConfig.CONFIG.oilDrillingRigVolume.get()).doubleValue());
        ModSounds.setVolume("packer", (float)((Double)MISoundAddonConfig.CONFIG.packerVolume.get()).doubleValue());
        ModSounds.setVolume("polarizer", (float)((Double)MISoundAddonConfig.CONFIG.polarizerVolume.get()).doubleValue());
        ModSounds.setVolume("pressurizer", (float)((Double)MISoundAddonConfig.CONFIG.pressurizerVolume.get()).doubleValue());
        ModSounds.setVolume("quarry", (float)((Double)MISoundAddonConfig.CONFIG.quarryVolume.get()).doubleValue());
        ModSounds.setVolume("unpacker", (float)((Double)MISoundAddonConfig.CONFIG.unpackerVolume.get()).doubleValue());
        ModSounds.setVolume("vacuum_freezer", (float)((Double)MISoundAddonConfig.CONFIG.vacuumFreezerVolume.get()).doubleValue());
        ModSounds.setVolume("wiremill", (float)((Double)MISoundAddonConfig.CONFIG.wiremillVolume.get()).doubleValue());
        ModSounds.setVolume("wrench", (float)((Double)MISoundAddonConfig.CONFIG.wrenchVolume.get()).doubleValue());
        ModSounds.setVolume("replicator", (float)((Double)MISoundAddonConfig.CONFIG.replicatorVolume.get()).doubleValue());
    }
}

