/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.mi_sound_addon.sound;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import dev.thestaticvoid.mi_sound_addon.MISoundAddon;
import dev.thestaticvoid.mi_sound_addon.MISoundAddonConfig;
import dev.thestaticvoid.mi_sound_addon.sound.ModSoundEventInfo;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModSounds {
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"mi_sound_addon");
    public static HashMap<String, ModSoundEventInfo> SOUND_EVENTS = new HashMap();
    private static final int DEFAULT_SOUND_DURATION = 60;

    public static void init(IEventBus bus) {
        MISoundAddon.LOGGER.debug("Registering sounds for mi_sound_addon");
        ModSounds.populateDefaultRecipeTypes(MIMachineRecipeTypes.getRecipeTypes());
        for (MachineRecipeType mrt : MIMachineRecipeTypes.getRecipeTypes()) {
            MISoundAddon.LOGGER.debug(mrt.getPath());
        }
        SOUND_EVENTS_REGISTRY.register(bus);
    }

    public static void populateDefaultRecipeTypes(List<MachineRecipeType> machineRecipeTypes) {
        for (MachineRecipeType mrt : machineRecipeTypes) {
            String type = mrt.getPath();
            if (type.equals("forge_hammer")) continue;
            ModSounds.addSoundEvent(type);
        }
        ModSounds.addSoundEvent("electric_blast_furnace");
        ModSounds.addSoundEvent("fission_reactor");
        ModSounds.addSoundEvent("wrench");
        ModSounds.addSoundEvent("replicator");
        ModSounds.updateDurations();
    }

    public static void addSoundEvent(String type) {
        ModSounds.addSoundEvent(type, 1.0f);
    }

    public static void addSoundEvent(String type, float volume) {
        ModSounds.addSoundEvent(type, volume, 60);
    }

    public static void addSoundEvent(String type, float volume, int duration) {
        ResourceLocation identifier = MISoundAddon.id(type);
        DeferredHolder soundEvent = SOUND_EVENTS_REGISTRY.register(type, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)identifier));
        SOUND_EVENTS.put(type, new ModSoundEventInfo((Supplier<SoundEvent>)soundEvent, duration, volume));
    }

    private static String getRecipeType(@NotNull MachineRecipe activeRecipe) {
        return ((MachineRecipeType)activeRecipe.getType()).getPath();
    }

    public static int getDuration(MachineRecipe activeRecipe) {
        if (SOUND_EVENTS.get(ModSounds.getRecipeType(activeRecipe)) != null) {
            return SOUND_EVENTS.get(ModSounds.getRecipeType(activeRecipe)).getSoundDuration();
        }
        return 60;
    }

    public static int getDurationFromString(String type) {
        return SOUND_EVENTS.get(type).getSoundDuration();
    }

    public static void setDuration(String type, int duration) {
        if (!SOUND_EVENTS.containsKey(type)) {
            throw new IllegalStateException("Tried to set duration of non-existent recipe type: " + type);
        }
        SOUND_EVENTS.get(type).setSoundDuration(duration);
    }

    public static void setVolume(String type, float volume) {
        if (!SOUND_EVENTS.containsKey(type)) {
            throw new IllegalStateException("Tried to set volume of non-existent recipe type: " + type);
        }
        SOUND_EVENTS.get(type).setVolume(volume);
    }

    public static void playSound(@NotNull MachineBlockEntity blockEntity, MachineRecipe activeRecipe) {
        Level world = blockEntity.getLevel();
        if (world == null) {
            return;
        }
        if (activeRecipe == null) {
            return;
        }
        ModSoundEventInfo soundEventInfo = !blockEntity.guiParams.blockId.getPath().equals("electric_blast_furnace") ? SOUND_EVENTS.get(ModSounds.getRecipeType(activeRecipe)) : SOUND_EVENTS.get("electric_blast_furnace");
        if (soundEventInfo != null && soundEventInfo.getSoundEvent() != null) {
            world.playSound(null, (double)blockEntity.getBlockPos().getX(), (double)blockEntity.getBlockPos().getY(), (double)blockEntity.getBlockPos().getZ(), soundEventInfo.getSoundEvent().get(), SoundSource.BLOCKS, soundEventInfo.getVolume(), 1.0f);
        }
    }

    public static void playSoundNoRecipe(@NotNull MachineBlockEntity blockEntity, String type) {
        Level world = blockEntity.getLevel();
        if (world == null) {
            return;
        }
        ModSoundEventInfo soundEventInfo = SOUND_EVENTS.get(type);
        if (soundEventInfo.getSoundEvent() != null) {
            world.playSound(null, (double)blockEntity.getBlockPos().getX(), (double)blockEntity.getBlockPos().getY(), (double)blockEntity.getBlockPos().getZ(), soundEventInfo.getSoundEvent().get(), SoundSource.BLOCKS, soundEventInfo.getVolume(), 1.0f);
        }
    }

    private static void updateDurations() {
        ModSounds.setDuration("assembler", 39);
        ModSounds.setDuration("blast_furnace", 31);
        ModSounds.setDuration("centrifuge", 39);
        ModSounds.setDuration("chemical_reactor", 80);
        ModSounds.setDuration("coke_oven", 34);
        ModSounds.setDuration("compressor", 30);
        ModSounds.setDuration("cutting_machine", 68);
        ModSounds.setDuration("distillation_tower", 109);
        ModSounds.setDuration("distillery", 71);
        ModSounds.setDuration("electric_blast_furnace", 61);
        ModSounds.setDuration("electrolyzer", 7);
        ModSounds.setDuration("fission_reactor", 60);
        ModSounds.setDuration("fusion_reactor", 67);
        ModSounds.setDuration("furnace", 38);
        ModSounds.setDuration("heat_exchanger", 71);
        ModSounds.setDuration("implosion_compressor", 70);
        ModSounds.setDuration("macerator", 16);
        ModSounds.setDuration("mixer", 27);
        ModSounds.setDuration("oil_drilling_rig", 29);
        ModSounds.setDuration("packer", 23);
        ModSounds.setDuration("polarizer", 29);
        ModSounds.setDuration("pressurizer", 89);
        ModSounds.setDuration("quarry", 61);
        ModSounds.setDuration("unpacker", 23);
        ModSounds.setDuration("vacuum_freezer", 62);
        ModSounds.setDuration("wiremill", 45);
        ModSounds.setDuration("replicator", 20);
    }

    public static void updateVolumes() {
        ModSounds.setVolume("assembler", (float)MISoundAddonConfig.assemblerVolume);
        ModSounds.setVolume("blast_furnace", (float)MISoundAddonConfig.blastFurnaceVolume);
        ModSounds.setVolume("centrifuge", (float)MISoundAddonConfig.centrifugeVolume);
        ModSounds.setVolume("chemical_reactor", (float)MISoundAddonConfig.chemicalReactorVolume);
        ModSounds.setVolume("coke_oven", (float)MISoundAddonConfig.cokeOvenVolume);
        ModSounds.setVolume("compressor", (float)MISoundAddonConfig.compressorVolume);
        ModSounds.setVolume("cutting_machine", (float)MISoundAddonConfig.cuttingMachineVolume);
        ModSounds.setVolume("distillation_tower", (float)MISoundAddonConfig.distillationTowerVolume);
        ModSounds.setVolume("distillery", (float)MISoundAddonConfig.distilleryVolume);
        ModSounds.setVolume("electric_blast_furnace", (float)MISoundAddonConfig.electricBlastFurnaceVolume);
        ModSounds.setVolume("electrolyzer", (float)MISoundAddonConfig.electrolyzerVolume);
        ModSounds.setVolume("fission_reactor", (float)MISoundAddonConfig.fissionReactorVolume);
        ModSounds.setVolume("fusion_reactor", (float)MISoundAddonConfig.fusionReactorVolume);
        ModSounds.setVolume("furnace", (float)MISoundAddonConfig.furnaceVolume);
        ModSounds.setVolume("heat_exchanger", (float)MISoundAddonConfig.heatExchangerVolume);
        ModSounds.setVolume("implosion_compressor", (float)MISoundAddonConfig.implosionCompressorVolume);
        ModSounds.setVolume("macerator", (float)MISoundAddonConfig.maceratorVolume);
        ModSounds.setVolume("mixer", (float)MISoundAddonConfig.mixerVolume);
        ModSounds.setVolume("oil_drilling_rig", (float)MISoundAddonConfig.oilDrillingRigVolume);
        ModSounds.setVolume("packer", (float)MISoundAddonConfig.packerVolume);
        ModSounds.setVolume("polarizer", (float)MISoundAddonConfig.polarizerVolume);
        ModSounds.setVolume("pressurizer", (float)MISoundAddonConfig.pressurizerVolume);
        ModSounds.setVolume("quarry", (float)MISoundAddonConfig.quarryVolume);
        ModSounds.setVolume("unpacker", (float)MISoundAddonConfig.unpackerVolume);
        ModSounds.setVolume("vacuum_freezer", (float)MISoundAddonConfig.vacuumFreezerVolume);
        ModSounds.setVolume("wiremill", (float)MISoundAddonConfig.wiremillVolume);
        ModSounds.setVolume("wrench", (float)MISoundAddonConfig.wrenchVolume);
        ModSounds.setVolume("replicator", (float)MISoundAddonConfig.replicatorVolume);
    }
}

