/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.mi_sound_addon.mixin;

import aztech.modern_industrialization.blocks.FastBlockEntity;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import dev.thestaticvoid.mi_sound_addon.item.MalletItem;
import dev.thestaticvoid.mi_sound_addon.util.SilencedComponent;
import dev.thestaticvoid.mi_sound_addon.util.SilencedComponentInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MachineBlockEntity.class})
public abstract class MachineBlockEntityMixin
extends FastBlockEntity
implements WrenchableBlockEntity,
SilencedComponentInterface,
MenuProvider {
    @Unique
    public SilencedComponent silencedComp;

    public MachineBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Shadow(remap=false)
    protected abstract void registerComponents(IComponent ... var1);

    @Inject(at={@At(value="TAIL")}, method={"<init>"}, remap=false)
    private void constructorMixin(BEP bep, MachineGuiParameters guiParams, OrientationComponent.Params orientationParams, CallbackInfo ci) {
        this.silencedComp = new SilencedComponent();
        this.registerComponents(this.silencedComp);
    }

    @Inject(method={"useItemOn"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void onUseMixin(Player player, InteractionHand hand, Direction face, CallbackInfoReturnable<ItemInteractionResult> cir) {
        ItemInteractionResult result = MalletItem.onUse((MachineBlockEntity)this, player, hand);
        if (result.consumesAction()) {
            this.mISoundAddon$toggleSilencedState();
            if (this.silencedComp.silenced) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mi_sound_addon.machine_silenced"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.mi_sound_addon.machine_unsilenced"), true);
            }
        }
        cir.setReturnValue((Object)result);
    }

    @Override
    public void mISoundAddon$toggleSilencedState() {
        this.silencedComp.onMalletUse();
    }

    @Override
    public SilencedComponent mISoundAddon$getSilencedState() {
        return this.silencedComp;
    }
}

