/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.machine.processcondition.SurroundingArea;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public record NearbyEntityProcessCondition(SurroundingArea relative, int range, EntityType<?> entity, int count) implements MachineProcessCondition
{
    public static final MapCodec<NearbyEntityProcessCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SurroundingArea.CODEC.fieldOf("relative").forGetter(NearbyEntityProcessCondition::relative), (App)Codec.intRange((int)1, (int)16).fieldOf("range").forGetter(NearbyEntityProcessCondition::range), (App)CodecHelper.forRegistry((Registry)BuiltInRegistries.ENTITY_TYPE).fieldOf("entity").forGetter(NearbyEntityProcessCondition::entity), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("count").forGetter(NearbyEntityProcessCondition::count)).apply((Applicative)instance, NearbyEntityProcessCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NearbyEntityProcessCondition> STREAM_CODEC = StreamCodec.composite(SurroundingArea.STREAM_CODEC, NearbyEntityProcessCondition::relative, (StreamCodec)ByteBufCodecs.INT, NearbyEntityProcessCondition::range, (StreamCodec)CodecHelper.forRegistryStream((Registry)BuiltInRegistries.ENTITY_TYPE), NearbyEntityProcessCondition::entity, (StreamCodec)ByteBufCodecs.INT, NearbyEntityProcessCondition::count, NearbyEntityProcessCondition::new);
    private static final Cache<WorldPos, Boolean> NEARBY_ENTITY_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        ServerLevel level = context.getLevel();
        WorldPos pos = new WorldPos((Level)level, context.getBlockEntity().getBlockPos());
        Boolean value = (Boolean)NEARBY_ENTITY_CACHE.getIfPresent((Object)pos);
        if (value == null) {
            AABB area = this.relative.bounds(pos.pos(), this.range);
            List entities = level.getEntities((Entity)null, area, entity -> entity.getType() == this.entity);
            value = entities.size() >= this.count;
            NEARBY_ENTITY_CACHE.put((Object)pos, (Object)value);
        }
        return value;
    }

    public void appendDescription(List<Component> lines) {
        lines.add((Component)MITweaks.text().recipeRequiresNearbyEntity(this.count, this.entity, this.relative, this.range));
    }

    public ItemStack icon() {
        return SpawnEggItem.byId(this.entity).getDefaultInstance();
    }

    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }
}

