/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.mixin.accessor.AbstractCraftingMultiblockBlockEntityAccessor;

public record EBFCoilProcessCondition(ElectricBlastFurnaceBlockEntity.Tier coilTier) implements MachineProcessCondition
{
    public static final MapCodec<EBFCoilProcessCondition> CODEC = RecordCodecBuilder.mapCodec(g -> g.group((App)StringRepresentable.fromValues(() -> ElectricBlastFurnaceBlockEntity.tiers.stream().map(WrappedEBFCoilTier::new).toList().toArray(new WrappedEBFCoilTier[0])).fieldOf("coil").forGetter(c -> new WrappedEBFCoilTier(c.coilTier()))).apply((Applicative)g, wrappedTier -> new EBFCoilProcessCondition(wrappedTier.coilTier())));
    public static final StreamCodec<RegistryFriendlyByteBuf, EBFCoilProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.map(coilBlockId -> (ElectricBlastFurnaceBlockEntity.Tier)ElectricBlastFurnaceBlockEntity.tiersByCoil.get(ResourceLocation.parse((String)coilBlockId)), coilTier -> coilTier.coilBlockId().toString()), EBFCoilProcessCondition::coilTier, EBFCoilProcessCondition::new);

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        MachineBlockEntity machineBlockEntity = context.getBlockEntity();
        if (machineBlockEntity instanceof ElectricBlastFurnaceBlockEntity) {
            ElectricBlastFurnaceBlockEntity ebf = (ElectricBlastFurnaceBlockEntity)machineBlockEntity;
            AbstractCraftingMultiblockBlockEntityAccessor multiblock = (AbstractCraftingMultiblockBlockEntityAccessor)ebf;
            int activeShapeIndex = multiblock.getActiveShape().getActiveShapeIndex();
            ElectricBlastFurnaceBlockEntity.Tier ebfTier = (ElectricBlastFurnaceBlockEntity.Tier)ElectricBlastFurnaceBlockEntity.tiers.get(activeShapeIndex);
            return this.coilTier.maxBaseEu() <= ebfTier.maxBaseEu();
        }
        return false;
    }

    public void appendDescription(List<Component> lines) {
        lines.add((Component)MITweaks.text().recipeRequiresCoil(this.coilTier));
    }

    public ItemStack icon() {
        return ((Block)BuiltInRegistries.BLOCK.get(this.coilTier.coilBlockId())).asItem().getDefaultInstance();
    }

    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }

    private record WrappedEBFCoilTier(ElectricBlastFurnaceBlockEntity.Tier coilTier) implements StringRepresentable
    {
        public String getSerializedName() {
            return this.coilTier.coilBlockId().toString();
        }
    }
}

