/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered.CustomMultiblockTier;
import net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered.TieredCraftingMultiblockBlockEntity;

public final class SteamTieredCraftingMultiblockBlockEntity
extends TieredCraftingMultiblockBlockEntity {
    private final OverclockComponent overclock;
    private boolean steelTier;

    public SteamTieredCraftingMultiblockBlockEntity(BEP bep, ResourceLocation name, CustomMultiblockTier[] tiers, long maxRecipeEu, List<OverclockComponent.Catalyst> overclockCatalysts) {
        super(bep, name, tiers, maxRecipeEu);
        this.overclock = new OverclockComponent(overclockCatalysts);
        this.registerComponents(new MachineComponent[]{this.overclock});
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new CraftingMultiblockGui(() -> this.shapeValid.shapeValid, () -> ((CrafterComponent)this.crafter).getProgress(), this.crafter, () -> ((OverclockComponent)this.overclock).getTicks());
        this.registerGuiComponent(guiComponentServerArray);
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        if (shapeMatcher.isMatchSuccessful()) {
            this.steelTier = false;
            for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
                if (!hatch.upgradesToSteel()) continue;
                this.steelTier = true;
                break;
            }
        }
    }

    public long getBaseRecipeEu() {
        return this.steelTier ? 4L : 2L;
    }

    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu((List)this.inventory.getFluidInputs(), (long)max, (Simulation)simulation);
    }

    @Override
    public void tick() {
        super.tick();
        this.overclock.tick((MachineBlockEntity)this);
    }

    public List<Component> getTooltips() {
        return this.overclock.getTooltips();
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.overclock.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }
}

