/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.blockentity;

import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.helper.transfer.MIEnergyTransferCache;

public final class EUTransformerBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent();
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, () -> MITweaks.config().euTransformer().capacity());
    private final ILongEnergyStorage insertable = new ILongEnergyStorage(){

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public long receive(long receiveFE, boolean simulate) {
            receiveFE = Math.min(receiveFE, MITweaks.config().euTransformer().maxInsert());
            long receiveEU = (long)((double)receiveFE * MITweaks.config().euTransformer().conversionRate());
            return EUTransformerBlockEntity.this.energy.insertEu(receiveEU, simulate ? Simulation.SIMULATE : Simulation.ACT);
        }

        public long extract(long extractEU, boolean simulate) {
            return 0L;
        }

        public long getAmount() {
            return EUTransformerBlockEntity.this.energy.getEu();
        }

        public long getCapacity() {
            return EUTransformerBlockEntity.this.energy.getCapacity();
        }
    };
    private final MIEnergyStorage extractable = this.energy.buildExtractable(arg_0 -> ((CasingComponent)this.casing).canInsertEu(arg_0));
    private final MIEnergyTransferCache transferEnergy = new MIEnergyTransferCache(() -> this.extractable);

    public EUTransformerBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(MITweaks.id("eu_transformer"), false).build(), new OrientationComponent.Params(true, false, false));
        this.registerComponents(new MachineComponent[]{this.redstoneControl, this.casing, this.energy});
        EnergyBar.Params energyBarParams = new EnergyBar.Params(76, 39);
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new EnergyBar(energyBarParams, () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(guiComponentServerArray);
        this.registerGuiComponent(new GuiComponentServer[]{new SlotPanel((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withCasing(this.casing)});
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this) && this.transferEnergy.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection, this.casing.getCableTier())) {
            this.setChanged();
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        CapabilitiesListeners.register((String)"mi_tweaks", event -> {
            event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
                EUTransformerBlockEntity machine = (EUTransformerBlockEntity)((Object)((Object)be));
                return machine.orientation.outputDirection == direction ? machine.extractable : null;
            });
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, bet, (be, direction) -> {
                EUTransformerBlockEntity machine = (EUTransformerBlockEntity)((Object)((Object)be));
                return machine.orientation.outputDirection == direction ? null : machine.insertable;
            });
        });
    }
}

