/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.AABB;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public enum SurroundingArea {
    ALL(() -> MITweaks.text().recipeRequiresSurroundingAreaAll(), (origin, range) -> origin.offset(-range.intValue(), -range.intValue(), -range.intValue()), (origin, range) -> origin.offset(range.intValue(), range.intValue(), range.intValue())),
    AT_AND_BELOW(() -> MITweaks.text().recipeRequiresSurroundingAreaAtAndBelow(), (origin, range) -> origin.offset(-range.intValue(), -range.intValue(), -range.intValue()), (origin, range) -> origin.offset(range.intValue(), 0, range.intValue())),
    BELOW(() -> MITweaks.text().recipeRequiresSurroundingAreaBelow(), (origin, range) -> origin.offset(-range.intValue(), -range.intValue(), -range.intValue()), (origin, range) -> origin.offset(range.intValue(), -1, range.intValue())),
    AT_AND_ABOVE(() -> MITweaks.text().recipeRequiresSurroundingAreaAtAndAbove(), (origin, range) -> origin.offset(-range.intValue(), 0, -range.intValue()), (origin, range) -> origin.offset(range.intValue(), range.intValue(), range.intValue())),
    ABOVE(() -> MITweaks.text().recipeRequiresSurroundingAreaAbove(), (origin, range) -> origin.offset(-range.intValue(), 1, -range.intValue()), (origin, range) -> origin.offset(range.intValue(), range.intValue(), range.intValue()));

    public static final Codec<SurroundingArea> CODEC;
    public static final StreamCodec<ByteBuf, SurroundingArea> STREAM_CODEC;
    private final Supplier<MutableComponent> text;
    private final BiFunction<BlockPos, Integer, BlockPos> firstPos;
    private final BiFunction<BlockPos, Integer, BlockPos> secondPos;

    private SurroundingArea(Supplier<MutableComponent> text, BiFunction<BlockPos, Integer, BlockPos> firstPos, BiFunction<BlockPos, Integer, BlockPos> secondPos) {
        this.text = text;
        this.firstPos = firstPos;
        this.secondPos = secondPos;
    }

    public MutableComponent text() {
        return this.text.get();
    }

    public Iterable<BlockPos> blocks(BlockPos origin, int range) {
        return BlockPos.betweenClosed((BlockPos)this.firstPos.apply(origin, range), (BlockPos)this.secondPos.apply(origin, range));
    }

    public AABB bounds(BlockPos origin, int range) {
        return AABB.encapsulatingFullBlocks((BlockPos)this.firstPos.apply(origin, range), (BlockPos)this.secondPos.apply(origin, range));
    }

    static {
        CODEC = CodecHelper.forLowercaseEnum(SurroundingArea.class);
        STREAM_CODEC = CodecHelper.forLowercaseEnumStream(SurroundingArea.class);
    }
}

