/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.datagen.client.provider;

import com.google.common.collect.Sets;
import java.util.Set;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.MITweaksTags;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class LanguageDatagenProvider
extends LanguageProvider {
    private static final Set<LangInstance<?>> INSTANCES = Sets.newHashSet();

    public static void include(LangInstance<?> instance) {
        INSTANCES.add(instance);
    }

    public LanguageDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "mi_tweaks", "en_us");
    }

    protected void addTranslations() {
        for (LangInstance<?> instance : INSTANCES) {
            instance.datagen((LanguageProvider)this);
        }
        for (ItemHolder item : MITweaksItems.values()) {
            this.add(item.asItem(), item.identifier().englishName());
        }
        this.add(MITweaksItems.MACHINE_BLUEPRINT.asItem().getDescriptionId() + ".blank", "Blank Machine Blueprint");
        this.add(MITweaksTags.FE_CABLES, "FE Cables");
        this.add("itemGroup.%s.%s".formatted("mi_tweaks", "mi_tweaks"), "MI Tweaks");
    }
}

