/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksBlocks;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.compat.mi.custom.MITweaksMIRegistries;
import net.swedz.mi_tweaks.item.MachineBlueprintItem;
import net.swedz.mi_tweaks.item.renderer.BlockOverlayingItemRenderer;

@Mod(value="mi_tweaks", dist={Dist.CLIENT})
@EventBusSubscriber(value={Dist.CLIENT}, modid="mi_tweaks", bus=EventBusSubscriber.Bus.MOD)
public final class MITweaksClient {
    private static final ModelResourceLocation RAW_ITEM_MODEL_LOCATION = ModelResourceLocation.standalone((ResourceLocation)MITweaks.id("item/machine_blueprint_raw"));

    public MITweaksClient(IEventBus bus) {
        bus.addListener(RegisterClientExtensionsEvent.class, event -> event.registerItem(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new BlockOverlayingItemRenderer(RAW_ITEM_MODEL_LOCATION, MachineBlueprintItem::getMachineBlock);
            }
        }, new Item[]{MITweaksItems.MACHINE_BLUEPRINT.asItem()}));
    }

    @SubscribeEvent
    private static void registerBlockEntityRenderers(FMLClientSetupEvent event) {
        for (DeferredHolder blockDef : Stream.concat(MITweaksBlocks.Registry.BLOCKS.getEntries().stream(), MITweaksMIRegistries.BLOCKS.getEntries().stream()).toList()) {
            MachineBlockEntity machineBlockEntity;
            Object object = blockDef.get();
            if (!(object instanceof MachineBlock)) continue;
            MachineBlock machine = (MachineBlock)object;
            MachineBlockEntity blockEntity = machine.getBlockEntityInstance();
            BlockEntityType type = blockEntity.getType();
            Objects.requireNonNull(blockEntity);
            int n = 0;
            BlockEntityRendererProvider provider = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MultiblockMachineBlockEntity.class}, (Object)machineBlockEntity, n)) {
                case 0 -> {
                    MultiblockMachineBlockEntity be = (MultiblockMachineBlockEntity)machineBlockEntity;
                    yield MultiblockMachineBER::new;
                }
                default -> MachineBlockEntityRenderer::new;
            };
            BlockEntityRenderers.register((BlockEntityType)type, (BlockEntityRendererProvider)provider);
        }
    }

    @SubscribeEvent
    private static void init(FMLConstructModEvent __) {
        NeoForge.EVENT_BUS.addListener(ClientPlayerNetworkEvent.LoggingIn.class, event -> {
            if (!MITweaks.config().machineBlueprints().learning() && (MITweaks.config().machineBlueprints().required().tooltip().isLearning() || MITweaks.config().machineBlueprints().required().placing().isLearning() || MITweaks.config().machineBlueprints().required().renderingHatches().isLearning())) {
                event.getPlayer().displayClientMessage((Component)MITweaks.text().learningDisabledButRequiringLearning(), false);
            }
        });
    }

    @SubscribeEvent
    private static void onModifyBakingResult(ModelEvent.RegisterAdditional event) {
        event.register(RAW_ITEM_MODEL_LOCATION);
    }
}

