/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile.transmitter;

import com.jerry.mekextras.api.IExtraAlloyInteraction;
import com.jerry.mekextras.api.tier.AdvancedTier;
import com.jerry.mekextras.api.tier.IAdvancedTier;
import com.jerry.mekextras.common.util.IExtraUpgradeableTransmitter;
import java.util.ArrayList;
import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.AlloyUpgradeTrigger;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityExtraTransmitter
extends TileEntityTransmitter
implements IExtraAlloyInteraction {
    public TileEntityExtraTransmitter(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    protected Transmitter<?, ?, ?> createTransmitter(Holder<Block> blockProvider) {
        return null;
    }

    public TransmitterType getTransmitterType() {
        return null;
    }

    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return current;
    }

    public static void tickServer(Level level, BlockPos blockPos, BlockState blockState, TileEntityExtraTransmitter entityTransmitter) {
        entityTransmitter.onUpdateServer();
    }

    public void onExtraAlloyInteraction(Player player, ItemStack stack, @NotNull IAdvancedTier tier) {
        if (this.getLevel() != null && this.getTransmitter().hasTransmitterNetwork()) {
            DynamicNetwork transmitterNetwork = this.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(transmitterNetwork.getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return Double.compare(o1.getBlockPos().distSqr((Vec3i)this.worldPosition), o2.getBlockPos().distSqr((Vec3i)this.worldPosition));
                }
                return 0;
            });
            boolean sharesSet = false;
            int upgraded = 0;
            for (Transmitter transmitter : list) {
                BlockState upgradeState;
                TileEntityExtraTransmitter transmitterTile;
                BlockState state;
                IExtraUpgradeableTransmitter upgradeableTransmitter;
                if (!(transmitter instanceof IExtraUpgradeableTransmitter) || !(upgradeableTransmitter = (IExtraUpgradeableTransmitter)transmitter).canUpgrade(tier) || (state = (transmitterTile = (TileEntityExtraTransmitter)transmitter.getTransmitterTile()).getBlockState()) == (upgradeState = transmitterTile.upgradeResult(state, tier.getAdvanceTier()))) continue;
                if (!sharesSet) {
                    if (transmitterNetwork instanceof DynamicBufferedNetwork) {
                        DynamicBufferedNetwork dynamicNetwork = (DynamicBufferedNetwork)transmitterNetwork;
                        dynamicNetwork.validateSaveShares((BufferedTransmitter)transmitter);
                    }
                    sharesSet = true;
                }
                transmitter.startUpgrading();
                Object upgradeData = upgradeableTransmitter.getUpgradeData();
                BlockPos transmitterPos = transmitter.getBlockPos();
                Level transmitterWorld = transmitter.getLevel();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                transmitterWorld.setBlockAndUpdate(transmitterPos, upgradeState);
                TileEntityExtraTransmitter upgradedTile = (TileEntityExtraTransmitter)WorldUtils.getTileEntity(TileEntityExtraTransmitter.class, (BlockGetter)transmitterWorld, (BlockPos)transmitterPos);
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                Transmitter upgradedTransmitter = upgradedTile.getTransmitter();
                if (upgradedTransmitter instanceof IExtraUpgradeableTransmitter) {
                    this.transferUpgradeData((IExtraUpgradeableTransmitter)upgradedTransmitter, (TransmitterUpgradeData)upgradeData);
                } else {
                    Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
                }
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                transmitterNetwork.invalidate(null);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((AlloyUpgradeTrigger)MekanismCriteriaTriggers.ALLOY_UPGRADE.value()).trigger(serverPlayer);
                }
            }
        }
    }

    private <DATA extends TransmitterUpgradeData> void transferUpgradeData(IExtraUpgradeableTransmitter<DATA> upgradeableTransmitter, TransmitterUpgradeData data) {
        if (upgradeableTransmitter.dataTypeMatches(data)) {
            upgradeableTransmitter.parseUpgradeData(data);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
        }
    }
}

