/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile.transmitter;

import com.jerry.mekextras.api.tier.AdvancedTier;
import com.jerry.mekextras.common.content.network.transmitter.ExtraPressurizedTube;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraTransmitter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.ISidedChemicalHandler;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.IRadiationManager;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.DynamicChemicalHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import mekanism.common.content.network.ChemicalNetwork;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.interfaces.ITileRadioactive;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraPressurizedTube
extends TileEntityExtraTransmitter
implements IComputerTile,
ITileRadioactive {
    private final ChemicalHandlerManager chemicalHandlerManager;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TileEntityExtraPressurizedTube(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        @Nullable Predicate canExtract = this.getExtractPredicate();
        @Nullable Predicate canInsert = this.getInsertPredicate();
        this.chemicalHandlerManager = new ChemicalHandlerManager(direction -> {
            ExtraPressurizedTube tube = this.getTransmitter();
            if (direction != null && tube.getConnectionTypeRaw(direction) == ConnectionType.NONE || tube.isRedstoneActivated()) {
                return Collections.emptyList();
            }
            return tube.getChemicalTanks(direction);
        }, (ISidedChemicalHandler)new DynamicChemicalHandler(this::getChemicalTanks, canExtract, canInsert, null));
        this.addCapabilityResolver((ICapabilityResolver)this.chemicalHandlerManager);
    }

    protected ExtraPressurizedTube createTransmitter(Holder<Block> blockProvider) {
        return new ExtraPressurizedTube(blockProvider, this);
    }

    public ExtraPressurizedTube getTransmitter() {
        return (ExtraPressurizedTube)super.getTransmitter();
    }

    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return BlockStateHelper.copyStateData((BlockState)current, switch (tier) {
            default -> throw new MatchException(null, null);
            case AdvancedTier.ABSOLUTE -> ExtraBlocks.ABSOLUTE_PRESSURIZED_TUBE;
            case AdvancedTier.SUPREME -> ExtraBlocks.SUPREME_PRESSURIZED_TUBE;
            case AdvancedTier.COSMIC -> ExtraBlocks.COSMIC_PRESSURIZED_TUBE;
            case AdvancedTier.INFINITE -> ExtraBlocks.INFINITE_PRESSURIZED_TUBE;
        });
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getUpdateTag(provider);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            ChemicalNetwork network = (ChemicalNetwork)this.getTransmitter().getTransmitterNetwork();
            if (!network.lastChemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                DataResult encoded = Chemical.HOLDER_CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)network.lastChemical);
                if (encoded.isSuccess()) {
                    updateTag.put("chemical", (Tag)encoded.getOrThrow());
                } else {
                    encoded.ifError(error -> Mekanism.logger.warn("Failed to encode last chemical: {}", (Object)error.message()));
                }
            }
            updateTag.putFloat("scale", network.currentScale);
        }
        return updateTag;
    }

    public float getRadiationScale() {
        if (IRadiationManager.INSTANCE.isRadiationEnabled()) {
            ExtraPressurizedTube tube = this.getTransmitter();
            if (this.isRemote()) {
                if (tube.hasTransmitterNetwork()) {
                    ChemicalNetwork network = (ChemicalNetwork)tube.getTransmitterNetwork();
                    if (!network.lastChemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY) && !network.getChemicalTank().isEmpty() && ((Chemical)network.lastChemical.value()).isRadioactive()) {
                        return network.currentScale;
                    }
                }
            } else {
                IChemicalTank gasTank = tube.getChemicalTank();
                if (!gasTank.isEmpty() && gasTank.getStack().isRadioactive()) {
                    return (float)gasTank.getStored() / (float)gasTank.getCapacity();
                }
            }
        }
        return 0.0f;
    }

    public int getRadiationParticleCount() {
        return MathUtils.clampToInt((double)(3.0f * this.getRadiationScale()));
    }

    private List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        return this.chemicalHandlerManager.getContainers(side);
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.CHEMICAL.block(), side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilityAll(Capabilities.CHEMICAL.block());
        } else {
            this.invalidateCapabilities();
        }
    }

    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "PressurizedTube";
    }

    @ComputerMethod
    ChemicalStack getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    long getCapacity() {
        ExtraPressurizedTube tube = this.getTransmitter();
        return tube.hasTransmitterNetwork() ? ((ChemicalNetwork)tube.getTransmitterNetwork()).getCapacity() : tube.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - this.getBuffer().getAmount();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

