/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile.transmitter;

import com.jerry.mekextras.api.tier.AdvancedTier;
import com.jerry.mekextras.common.content.network.transmitter.ExtraMechanicalPipe;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraTransmitter;
import java.util.Collections;
import java.util.List;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.ISidedFluidHandler;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.DynamicFluidHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraMechanicalPipe
extends TileEntityExtraTransmitter
implements IComputerTile {
    private final FluidHandlerManager fluidHandlerManager = new FluidHandlerManager(direction -> {
        ExtraMechanicalPipe pipe = this.getTransmitter();
        if (direction != null && pipe.getConnectionTypeRaw(direction) == ConnectionType.NONE || pipe.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return pipe.getFluidTanks(direction);
    }, (ISidedFluidHandler)new DynamicFluidHandler(this::getFluidTanks, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public TileEntityExtraMechanicalPipe(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)this.fluidHandlerManager);
    }

    protected ExtraMechanicalPipe createTransmitter(Holder<Block> blockProvider) {
        return new ExtraMechanicalPipe(blockProvider, this);
    }

    public ExtraMechanicalPipe getTransmitter() {
        return (ExtraMechanicalPipe)super.getTransmitter();
    }

    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return BlockStateHelper.copyStateData((BlockState)current, switch (tier) {
            default -> throw new MatchException(null, null);
            case AdvancedTier.ABSOLUTE -> ExtraBlocks.ABSOLUTE_MECHANICAL_PIPE;
            case AdvancedTier.SUPREME -> ExtraBlocks.SUPREME_MECHANICAL_PIPE;
            case AdvancedTier.COSMIC -> ExtraBlocks.COSMIC_MECHANICAL_PIPE;
            case AdvancedTier.INFINITE -> ExtraBlocks.INFINITE_MECHANICAL_PIPE;
        });
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getUpdateTag(provider);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.put("fluid", network.lastFluid.saveOptional(provider));
            updateTag.putFloat("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager.getContainers(side);
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.FLUID.block(), side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilityAll(Capabilities.FLUID.block());
        } else {
            this.invalidateCapabilities();
        }
    }

    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "MechanicalPipe";
    }

    @ComputerMethod
    FluidStack getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    long getCapacity() {
        ExtraMechanicalPipe pipe = this.getTransmitter();
        return pipe.hasTransmitterNetwork() ? ((FluidNetwork)pipe.getTransmitterNetwork()).getCapacity() : pipe.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - (long)this.getBuffer().getAmount();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

