/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile.factory;

import com.jerry.mekextras.api.recipes.cache.StackableItemStackConstantChemicalToObjectCachedRecipe;
import com.jerry.mekextras.common.inventory.slot.chemical.ExtraFactoryChemicalInventorySlot;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraItemToItemFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraItemStackChemicalToItemStackFactory
extends TileEntityExtraItemToItemFactory<ItemStackChemicalToItemStackRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<ItemStackChemicalToItemStackRecipe>,
IRecipeLookupHandler.ConstantUsageRecipeLookupHandler {
    protected static final DoubleInputRecipeCache.CheckRecipeType<ItemStack, ChemicalStack, ItemStackChemicalToItemStackRecipe, ItemStack> OUTPUT_CHECK = (recipe, input, extra, output) -> InventoryUtils.areItemsStackable((ItemStack)((ItemStack)recipe.getOutput(input, extra)), (ItemStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final ILongInputHandler<@NotNull ChemicalStack> chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.chemicalTank);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalItem"}, docPlaceholder="chemical item (extra) slot")
    ExtraFactoryChemicalInventorySlot extraSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getChemical", "getChemicalCapacity", "getChemicalNeeded", "getChemicalFilledPercentage"}, docPlaceholder="chemical tank")
    IChemicalTank chemicalTank;
    private final StackableItemStackConstantChemicalToObjectCachedRecipe.StackableChemicalUsageMultiplier chemicalUsageMultiplier;
    private final long[] usedSoFar;
    private double chemicalPerTickMeanMultiplier = 1.0;
    private long baseTotalUsage;

    public TileEntityExtraItemStackChemicalToItemStackFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        if (this.allowExtractingChemical()) {
            this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank, RelativeSide.RIGHT).setCanEject(false);
        } else {
            this.configComponent.setupInputConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank);
        }
        this.baseTotalUsage = 200L;
        this.usedSoFar = new long[this.tier.processes];
        this.chemicalUsageMultiplier = this.useStatisticalMechanics() ? (usedSoFar, operatingTicks, operationsSoFar) -> StatUtils.inversePoisson((double)this.chemicalPerTickMeanMultiplier) : StackableItemStackConstantChemicalToObjectCachedRecipe.StackableChemicalUsageMultiplier.constantUse(() -> this.baseTotalUsage, this::getChemicalTicksRequired);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        long capacity = ((AttributeFactoryType)Attribute.getOrThrow((Holder)this.getBlockHolder(), AttributeFactoryType.class)).getFactoryType() == FactoryType.INFUSING ? 1000L : 210L;
        this.chemicalTank = this.allowExtractingChemical() ? BasicChemicalTank.createModern((long)(capacity * (long)this.tier.processes * (long)this.tier.processes), arg_0 -> ((TileEntityExtraItemStackChemicalToItemStackFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener)) : BasicChemicalTank.inputModern((long)(capacity * (long)this.tier.processes * (long)this.tier.processes), arg_0 -> ((TileEntityExtraItemStackChemicalToItemStackFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.extraSlot = ExtraFactoryChemicalInventorySlot.fillOrConverts(this, this.chemicalTank, () -> ((TileEntityExtraItemStackChemicalToItemStackFactory)this).getLevel(), listener, 7, 57);
        builder.addSlot((IInventorySlot)this.extraSlot);
    }

    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    @Nullable
    protected ExtraFactoryChemicalInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeAB(stack, this.chemicalTank.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(ItemStackChemicalToItemStackRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackChemicalToItemStackRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            ItemStackChemicalToItemStackRecipe cachedRecipe = (ItemStackChemicalToItemStackRecipe)cached.getRecipe();
            return cachedRecipe.getItemInput().testType(stack) && (this.chemicalTank.isEmpty() || cachedRecipe.getChemicalInput().testType(this.chemicalTank.getTypeHolder()));
        }
        return false;
    }

    @Override
    protected ItemStackChemicalToItemStackRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        return (ItemStackChemicalToItemStackRecipe)((InputRecipeCache.ItemChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)this.chemicalTank.getStack(), (Object)outputSlot.getStack(), OUTPUT_CHECK);
    }

    @Override
    protected void handleSecondaryFuel() {
        this.extraSlot.fillTankOrConvert();
    }

    @NotNull
    public IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, InputRecipeCache.ItemChemical<ItemStackChemicalToItemStackRecipe>> getRecipeType() {
        return switch (this.type) {
            case FactoryType.COMPRESSING -> MekanismRecipeType.COMPRESSING;
            case FactoryType.INFUSING -> MekanismRecipeType.METALLURGIC_INFUSING;
            case FactoryType.INJECTING -> MekanismRecipeType.INJECTING;
            case FactoryType.PURIFYING -> MekanismRecipeType.PURIFYING;
            default -> throw new IllegalStateException("Unhandled factory type");
        };
    }

    public IRecipeViewerRecipeType<ItemStackChemicalToItemStackRecipe> recipeViewerType() {
        return switch (this.type) {
            case FactoryType.COMPRESSING -> RecipeViewerRecipeType.COMPRESSING;
            case FactoryType.INFUSING -> RecipeViewerRecipeType.METALLURGIC_INFUSING;
            case FactoryType.INJECTING -> RecipeViewerRecipeType.INJECTING;
            case FactoryType.PURIFYING -> RecipeViewerRecipeType.PURIFYING;
            default -> throw new IllegalStateException("Unhandled factory type");
        };
    }

    private boolean allowExtractingChemical() {
        FactoryType factoryType = ((AttributeFactoryType)Attribute.getOrThrow((Holder)this.getBlockHolder(), AttributeFactoryType.class)).getFactoryType();
        return factoryType == FactoryType.COMPRESSING || factoryType == FactoryType.INFUSING;
    }

    private boolean useStatisticalMechanics() {
        return MekanismConfig.usage.randomizedConsumption.get() && (this.type == FactoryType.INJECTING || this.type == FactoryType.PURIFYING);
    }

    @Nullable
    public ItemStackChemicalToItemStackRecipe getRecipe(int cacheIndex) {
        return (ItemStackChemicalToItemStackRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], (IInputHandler)this.chemicalInputHandler);
    }

    @NotNull
    public CachedRecipe<ItemStackChemicalToItemStackRecipe> createNewCachedRecipe(@NotNull ItemStackChemicalToItemStackRecipe recipe, int cacheIndex) {
        Object cachedRecipe = recipe.perTickUsage() ? StackableItemStackConstantChemicalToObjectCachedRecipe.toItem(recipe, this.recheckAllRecipeErrors[cacheIndex], (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.chemicalInputHandler, this.chemicalUsageMultiplier, used -> {
            this.usedSoFar[cacheIndex] = used;
        }, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]) : TwoInputCachedRecipe.itemChemicalToItem((ItemStackChemicalToItemStackRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.inputHandlers[cacheIndex], this.chemicalInputHandler, (IOutputHandler)this.outputHandlers[cacheIndex]);
        return cachedRecipe.setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityExtraItemStackChemicalToItemStackFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityExtraItemStackChemicalToItemStackFactory)this).markForSave()).setBaselineMaxOperations(this::getOperationsPerTick).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("used_so_far", 12)) {
            long[] savedUsed = nbt.getLongArray("used_so_far");
            if (this.tier.processes != savedUsed.length) {
                Arrays.fill(this.usedSoFar, 0L);
            }
            for (int i = 0; i < this.tier.processes && i < savedUsed.length; ++i) {
                this.usedSoFar[i] = savedUsed[i];
            }
        } else {
            Arrays.fill(this.usedSoFar, 0L);
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putLongArray("used_so_far", Arrays.copyOf(this.usedSoFar, this.usedSoFar.length));
    }

    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar[cacheIndex];
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.CHEMICAL && this.supportsUpgrade(Upgrade.CHEMICAL)) {
            if (this.useStatisticalMechanics()) {
                this.chemicalPerTickMeanMultiplier = MekanismUtils.getGasPerTickMeanMultiplier((IUpgradeTile)this);
            } else {
                this.baseTotalUsage = MekanismUtils.getBaseUsage((IUpgradeTile)this, (int)200);
            }
        }
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.chemicalTank.deserializeNBT(provider, data.stored.serializeNBT(provider));
            this.extraSlot.deserializeNBT(provider, data.chemicalSlot.serializeNBT(provider));
            System.arraycopy(data.usedSoFar, 0, this.usedSoFar, 0, data.usedSoFar.length);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public AdvancedMachineUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new AdvancedMachineUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.usedSoFar, this.chemicalTank, (ChemicalInventorySlot)this.extraSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.chemicalTank.setEmpty();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Empty the contents of the chemical tank into the environment")
    void dumpChemical() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dump();
    }
}

