/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile.factory;

import com.jerry.mekextras.common.inventory.slot.StackableInputInventorySlot;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraItemToItemFactory;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.upgrade.CombinerUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraCombiningFactory
extends TileEntityExtraItemToItemFactory<CombinerRecipe>
implements IDoubleRecipeLookupHandler.DoubleItemRecipeLookupHandler<CombinerRecipe> {
    private static final DoubleInputRecipeCache.CheckRecipeType<ItemStack, ItemStack, CombinerRecipe, ItemStack> OUTPUT_CHECK = (recipe, input, extra, output) -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput(input, extra), (ItemStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final IInputHandler<@NotNull ItemStack> extraInputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getSecondaryInput"}, docPlaceholder="secondary input slot")
    StackableInputInventorySlot extraSlot;

    public TileEntityExtraCombiningFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.extraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.extraSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.extraSlot = StackableInputInventorySlot.at(this.tier, arg_0 -> ((TileEntityExtraCombiningFactory)this).containsRecipeB(arg_0), this.markAllMonitorsChanged(listener), 7, 57);
        builder.addSlot((IInventorySlot)this.extraSlot);
        this.extraSlot.setSlotType(ContainerSlotType.EXTRA);
    }

    @Nullable
    protected StackableInputInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeAB(stack, this.extraSlot.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(CombinerRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getMainInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<CombinerRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            CombinerRecipe cachedRecipe = (CombinerRecipe)cached.getRecipe();
            return cachedRecipe.getMainInput().testType(stack) && (this.extraSlot.isEmpty() || cachedRecipe.getExtraInput().testType(this.extraSlot.getStack()));
        }
        return false;
    }

    @Override
    protected CombinerRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        return (CombinerRecipe)((InputRecipeCache.DoubleItem)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)this.extraSlot.getStack(), (Object)outputSlot.getStack(), OUTPUT_CHECK);
    }

    @NotNull
    public IMekanismRecipeTypeProvider<RecipeInput, CombinerRecipe, InputRecipeCache.DoubleItem<CombinerRecipe>> getRecipeType() {
        return MekanismRecipeType.COMBINING;
    }

    public IRecipeViewerRecipeType<CombinerRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.COMBINING;
    }

    @Nullable
    public CombinerRecipe getRecipe(int cacheIndex) {
        return (CombinerRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.extraInputHandler);
    }

    @NotNull
    public CachedRecipe<CombinerRecipe> createNewCachedRecipe(@NotNull CombinerRecipe recipe, int cacheIndex) {
        return TwoInputCachedRecipe.combiner((CombinerRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.inputHandlers[cacheIndex], this.extraInputHandler, (IOutputHandler)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityExtraCombiningFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityExtraCombiningFactory)this).markForSave()).setBaselineMaxOperations(this::getOperationsPerTick).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof CombinerUpgradeData) {
            CombinerUpgradeData data = (CombinerUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.extraSlot.deserializeNBT(provider, data.extraSlot.serializeNBT(provider));
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public CombinerUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new CombinerUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.energySlot, (InputInventorySlot)this.extraSlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

