/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile;

import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.capabilities.chemical.ExtraChemicalTankChemicalTank;
import com.jerry.mekextras.common.tier.CTTier;
import com.jerry.mekextras.common.upgrade.ExtraChemicalTankUpgradeData;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.upgrade.ChemicalTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraChemicalTank
extends TileEntityConfigurableMachine
implements IHasGasMode {
    @SyntheticComputerMethod(getter="getDumpingMode", getterDescription="Get the current Dumping configuration")
    public TileEntityChemicalTank.GasMode dumping = TileEntityChemicalTank.GasMode.IDLE;
    private IChemicalTank chemicalTank;
    private CTTier tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getDrainItem"}, docPlaceholder="drain slot")
    ChemicalInventorySlot drainSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFillItem"}, docPlaceholder="fill slot")
    ChemicalInventorySlot fillSlot;

    public TileEntityExtraChemicalTank(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.drainSlot, (Object)this.fillSlot, RelativeSide.FRONT, true).setCanEject(false);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.getChemicalTank(), RelativeSide.FRONT);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this, () -> this.tier.getOutput());
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.CHEMICAL}).setCanEject(type -> this.canFunction() && this.dumping != TileEntityChemicalTank.GasMode.DUMPING);
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getAdvancedTier((Holder<Block>)this.getBlockHolder(), CTTier.class);
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = ExtraChemicalTankChemicalTank.create(this.tier, listener);
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.drainSlot = ChemicalInventorySlot.drain((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)16);
        builder.addSlot((IInventorySlot)this.drainSlot);
        this.fillSlot = ChemicalInventorySlot.fill((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)48);
        builder.addSlot((IInventorySlot)this.fillSlot);
        this.drainSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.drainSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.fillSlot.setSlotType(ContainerSlotType.INPUT);
        this.fillSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.drainSlot.drainTank();
        this.fillSlot.fillTank();
        if (this.dumping != TileEntityChemicalTank.GasMode.IDLE) {
            if (this.dumping == TileEntityChemicalTank.GasMode.DUMPING) {
                this.chemicalTank.shrinkStack(this.tier.getStorage() / 400L, Action.EXECUTE);
            } else {
                long stored;
                long target = MathUtils.clampToLong((double)((double)this.chemicalTank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get()));
                if (target < (stored = this.chemicalTank.getStored())) {
                    this.chemicalTank.shrinkStack(Math.min(stored - target, this.tier.getOutput()), Action.EXECUTE);
                }
            }
        }
        return sendUpdatePacket;
    }

    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumping = (TileEntityChemicalTank.GasMode)this.dumping.getNext();
            this.markForSave();
        }
    }

    public boolean shouldDumpRadiation() {
        return true;
    }

    public int getRedstoneLevel() {
        IChemicalTank currentTank = this.getCurrentTank();
        return MekanismUtils.redstoneLevelFromContents((long)currentTank.getStored(), (long)currentTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="tank")
    IChemicalTank getCurrentTank() {
        return this.chemicalTank;
    }

    public CTTier getTier() {
        return this.tier;
    }

    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ExtraChemicalTankUpgradeData) {
            ExtraChemicalTankUpgradeData data = (ExtraChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = data.dumping;
            this.getChemicalTank().setStack(data.storedChemical);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else if (upgradeData instanceof ChemicalTankUpgradeData) {
            ChemicalTankUpgradeData data = (ChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = (TileEntityChemicalTank.GasMode)MathUtils.getByIndexMod((Object[])TileEntityChemicalTank.GasMode.values(), (int)data.dumping.ordinal());
            this.getChemicalTank().setStack(data.storedChemical);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @NotNull
    public ExtraChemicalTankUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new ExtraChemicalTankUpgradeData(provider, this.redstone, this.getControlType(), this.drainSlot, this.fillSlot, this.dumping, this.getChemicalTank().getStack(), this.getComponents());
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        NBTUtils.writeEnum((CompoundTag)dataMap, (String)"dumping", (Enum)this.dumping);
    }

    public void readSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        NBTUtils.setEnumIfPresent((CompoundTag)dataMap, (String)"dumping", (IntFunction)TileEntityChemicalTank.GasMode.BY_ID, mode -> {
            this.dumping = mode;
        });
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)MekanismDataComponents.DUMP_MODE, (Object)this.dumping);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.dumping = (TileEntityChemicalTank.GasMode)input.getOrDefault((Supplier)MekanismDataComponents.DUMP_MODE, (Object)this.dumping);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create((IntFunction)TileEntityChemicalTank.GasMode.BY_ID, (Enum)TileEntityChemicalTank.GasMode.IDLE, () -> this.dumping, value -> {
            this.dumping = value;
        }));
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set the Dumping mode of the tank")
    void setDumpingMode(TileEntityChemicalTank.GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumping != mode) {
            this.dumping = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Advance the Dumping mode to the next configuration in the list")
    void incrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(0);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Descend the Dumping mode to the previous configuration in the list")
    void decrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumping = (TileEntityChemicalTank.GasMode)this.dumping.getPrevious();
        this.markForSave();
    }
}

