/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile;

import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.inventory.slot.ExtraBinInventorySlot;
import com.jerry.mekextras.common.tier.BTier;
import com.jerry.mekextras.common.upgrade.ExtraBinUpgradeData;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.LockData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.lib.inventory.HandlerTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.upgrade.BinUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraBin
extends TileEntityMekanism
implements IConfigurable {
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> targetInventory;
    public int addTicks = 0;
    public int removeTicks = 0;
    private int delayTicks;
    private boolean needsSync;
    private BTier tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getStored"}, docPlaceholder="bin")
    ExtraBinInventorySlot binSlot;

    public TileEntityExtraBin(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getAdvancedTier((Holder<Block>)this.getBlockHolder(), BTier.class);
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityExtraBin)this).getDirection());
        this.binSlot = ExtraBinInventorySlot.create(listener, this.tier);
        builder.addSlot((IInventorySlot)this.binSlot);
        return builder.build();
    }

    public BTier getTier() {
        return this.tier;
    }

    public ExtraBinInventorySlot getBinSlot() {
        return this.binSlot;
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.addTicks = Math.max(0, this.addTicks - 1);
        this.removeTicks = Math.max(0, this.removeTicks - 1);
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 0) {
            if (this.getActive()) {
                TransitRequest.TransitResponse response;
                IItemHandler capability = (IItemHandler)CapabilityTileEntity.ITEM_HANDLER_PROVIDER.getCapability((Object)this, (Object)Direction.DOWN);
                HandlerTransitRequest request = new HandlerTransitRequest(capability);
                request.addItem(this.binSlot.getBottomStack(), 0);
                if (this.targetInventory == null) {
                    this.targetInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, this.getBlockPos().below(), Direction.UP);
                }
                if (!(response = request.eject((BlockEntity)this, (IItemHandler)this.targetInventory.getCapability(), 0, LogisticalTransporterBase::getColor)).isEmpty()) {
                    int sendingAmount = response.getSendingAmount();
                    MekanismUtils.logMismatchedStackSize((long)this.binSlot.shrinkStack(sendingAmount, Action.EXECUTE), (long)sendingAmount);
                }
                this.delayTicks = 10;
            }
        } else {
            --this.delayTicks;
        }
        if (this.needsSync) {
            sendUpdatePacket = true;
            this.needsSync = false;
        }
        return sendUpdatePacket;
    }

    public InteractionResult onSneakRightClick(Player player) {
        this.setActive(!this.getActive());
        Level world = this.getLevel();
        if (world != null) {
            world.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean toggleLock() {
        return this.setLocked(!this.binSlot.isLocked());
    }

    public boolean setLocked(boolean isLocked) {
        if (this.binSlot.setLocked(isLocked)) {
            if (this.getLevel() != null && !this.isRemote()) {
                this.needsSync = true;
                this.markForSave();
                this.getLevel().playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        BinInventorySlot slot;
        if (upgradeData instanceof ExtraBinUpgradeData) {
            ExtraBinInventorySlot slot2;
            ExtraBinUpgradeData extraBinUpgradeData = (ExtraBinUpgradeData)upgradeData;
            try {
                ExtraBinInventorySlot extraBinInventorySlot;
                boolean bl;
                boolean redstone1 = bl = extraBinUpgradeData.redstone();
                slot2 = extraBinInventorySlot = extraBinUpgradeData.binSlot();
                this.redstone = redstone1;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            this.binSlot.setStack(slot2.getStack());
            this.binSlot.setLockStack(slot2.getLockStack());
            return;
        }
        if (!(upgradeData instanceof BinUpgradeData)) {
            super.parseUpgradeData(provider, upgradeData);
            return;
        }
        BinUpgradeData binUpgradeData = (BinUpgradeData)upgradeData;
        {
            BinInventorySlot binInventorySlot;
            boolean bl;
            boolean redstone1 = bl = binUpgradeData.redstone();
            slot = binInventorySlot = binUpgradeData.binSlot();
            this.redstone = redstone1;
        }
        this.binSlot.setStack(slot.getStack());
        this.binSlot.setLockStack(slot.getLockStack());
        this.binSlot.deserializeNBT(provider, slot.serializeNBT(provider));
    }

    @NotNull
    public ExtraBinUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new ExtraBinUpgradeData(this.redstone, this.getBinSlot());
    }

    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.level != null && !this.isRemote()) {
            this.needsSync = true;
        }
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.put("item", (Tag)this.binSlot.serializeNBT(provider));
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setCompoundIfPresent((CompoundTag)tag, (String)"item", nbt -> this.binSlot.deserializeNBT(provider, (CompoundTag)nbt));
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        builder.set((Supplier)MekanismDataComponents.LOCK, (Object)LockData.create((ItemStack)this.binSlot.getLockStack()));
        super.collectImplicitComponents(builder);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        this.binSlot.setLockStack(((LockData)input.getOrDefault((Supplier)MekanismDataComponents.LOCK, (Object)LockData.EMPTY)).lock());
        super.applyImplicitComponents(input);
    }

    @ComputerMethod(methodDescription="Get the maximum number of items the bin can contain.")
    int getCapacity() {
        return this.binSlot.getLimit(this.binSlot.getStack());
    }

    @ComputerMethod(methodDescription="If true, the Bin is locked to a particular item type.")
    boolean isLocked() {
        return this.binSlot.isLocked();
    }

    @ComputerMethod(methodDescription="Get the type of item the Bin is locked to (or Air if not locked)")
    ItemStack getLock() {
        return this.binSlot.getLockStack();
    }

    @ComputerMethod(methodDescription="Lock the Bin to the currently stored item type. The Bin must not be creative, empty, or already locked")
    void lock() throws ComputerException {
        if (this.binSlot.isEmpty()) {
            throw new ComputerException("Empty bins cannot be locked!");
        }
        if (!this.setLocked(true)) {
            throw new ComputerException("This bin is already locked!");
        }
    }

    @ComputerMethod(methodDescription="Unlock the Bin's fixed item type. The Bin must not be creative, or already unlocked")
    void unlock() throws ComputerException {
        if (!this.setLocked(true)) {
            throw new ComputerException("This bin is not locked!");
        }
    }
}

