/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.resource;

import com.jerry.mekextras.common.resource.BlockExtraResourceInfo;
import com.jerry.mekextras.common.tags.ExtraTags;
import java.util.function.Supplier;
import mekanism.common.resource.IResource;
import mekanism.common.resource.ResourceType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public enum ExtraResource implements IResource
{
    NAQUADAH("naquadah", 333314, () -> ExtraTags.Items.NAQUADAH, BlockExtraResourceInfo.NAQUADAH, BlockExtraResourceInfo.RAW_NAQUADAH);

    private final String name;
    private final int tint;
    private final Supplier<TagKey<Item>> oreTag;
    private final boolean isVanilla;
    private final BlockExtraResourceInfo resourceBlockInfo;
    private final BlockExtraResourceInfo rawResourceBlockInfo;

    private ExtraResource(String name, int tint, TagKey<Item> oreTag) {
        this(name, tint, () -> oreTag, true, null, null);
    }

    private ExtraResource(String name, int tint, Supplier<TagKey<Item>> oreTag, BlockExtraResourceInfo resourceBlockInfo, BlockExtraResourceInfo rawResourceBlockInfo) {
        this(name, tint, oreTag, false, resourceBlockInfo, rawResourceBlockInfo);
    }

    private ExtraResource(String name, int tint, Supplier<TagKey<Item>> oreTag, boolean isVanilla, BlockExtraResourceInfo resourceBlockInfo, BlockExtraResourceInfo rawResourceBlockInfo) {
        this.name = name;
        this.tint = tint;
        this.oreTag = oreTag;
        this.isVanilla = isVanilla;
        this.resourceBlockInfo = resourceBlockInfo;
        this.rawResourceBlockInfo = rawResourceBlockInfo;
    }

    public String getRegistrySuffix() {
        return this.name;
    }

    public int getTint() {
        return this.tint;
    }

    public TagKey<Item> getOreTag() {
        return this.oreTag.get();
    }

    public boolean has(ResourceType type) {
        return type != ResourceType.ENRICHED && (!this.isVanilla || !type.isVanilla());
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    @Nullable
    public BlockExtraResourceInfo getResourceBlockInfo() {
        return this.resourceBlockInfo;
    }

    @Nullable
    public BlockExtraResourceInfo getRawResourceBlockInfo() {
        return this.rawResourceBlockInfo;
    }
}

