/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekextras.common.block.BlockExtraEnergyCube;
import com.jerry.mekextras.common.block.basic.BlockExtraBin;
import com.jerry.mekextras.common.block.basic.BlockExtraFluidTank;
import com.jerry.mekextras.common.block.prefab.BlockExtraFactoryMachine;
import com.jerry.mekextras.common.capabilities.ExtraCapabilities;
import com.jerry.mekextras.common.item.block.ItemBlockExtraBin;
import com.jerry.mekextras.common.item.block.ItemBlockExtraChemicalTank;
import com.jerry.mekextras.common.item.block.ItemBlockExtraEnergyCube;
import com.jerry.mekextras.common.item.block.ItemBlockLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.item.block.machine.ItemBlockExtraFactory;
import com.jerry.mekextras.common.item.block.machine.ItemBlockExtraFluidTank;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.tile.TileEntityExtraBin;
import com.jerry.mekextras.common.tile.TileEntityExtraChemicalTank;
import com.jerry.mekextras.common.tile.TileEntityExtraEnergyCube;
import com.jerry.mekextras.common.tile.TileEntityExtraFluidTank;
import com.jerry.mekextras.common.tile.TileEntityLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraCombiningFactory;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraItemStackChemicalToItemStackFactory;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraItemStackToItemStackFactory;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraSawingFactory;
import com.jerry.mekextras.common.tile.machine.TileEntityAdvancedElectricPump;
import com.jerry.mekextras.common.tile.multiblock.TileEntityExtraInductionCell;
import com.jerry.mekextras.common.tile.multiblock.TileEntityExtraInductionProvider;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraLogisticalTransporter;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraLogisticalTransporterBase;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraMechanicalPipe;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraPressurizedTube;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraThermodynamicConductor;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraTransmitter;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraUniversalCable;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.function.BooleanSupplier;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class ExtraTileEntityTypes {
    public static final TileEntityTypeDeferredRegister EXTRA_TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekanism_extras");
    private static final Table<ExtraFactoryTier, FactoryType, TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>>> FACTORIES = HashBasedTable.create();
    public static final TileEntityTypeRegistryObject<TileEntityAdvancedElectricPump> ADVANCED_ELECTRIC_PUMP;
    public static final TileEntityTypeRegistryObject<TileEntityExtraBin> ABSOLUTE_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityExtraBin> SUPREME_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityExtraBin> COSMIC_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityExtraBin> INFINITE_BIN;
    public static final TileEntityTypeRegistryObject<TileEntityExtraEnergyCube> ABSOLUTE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraEnergyCube> SUPREME_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraEnergyCube> COSMIC_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraEnergyCube> INFINITE_ENERGY_CUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraFluidTank> ABSOLUTE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityExtraFluidTank> SUPREME_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityExtraFluidTank> COSMIC_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityExtraFluidTank> INFINITE_FLUID_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityExtraChemicalTank> ABSOLUTE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityExtraChemicalTank> SUPREME_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityExtraChemicalTank> COSMIC_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityExtraChemicalTank> INFINITE_CHEMICAL_TANK;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> ABSOLUTE_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> SUPREME_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> COSMIC_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> INFINITE_RADIOACTIVE_WASTE_BARREL;
    public static final TileEntityTypeRegistryObject<TileEntityExtraUniversalCable> ABSOLUTE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraUniversalCable> SUPREME_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraUniversalCable> COSMIC_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraUniversalCable> INFINITE_UNIVERSAL_CABLE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraMechanicalPipe> ABSOLUTE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraMechanicalPipe> SUPREME_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraMechanicalPipe> COSMIC_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraMechanicalPipe> INFINITE_MECHANICAL_PIPE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraPressurizedTube> ABSOLUTE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraPressurizedTube> SUPREME_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraPressurizedTube> COSMIC_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraPressurizedTube> INFINITE_PRESSURIZED_TUBE;
    public static final TileEntityTypeRegistryObject<TileEntityExtraLogisticalTransporter> ABSOLUTE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityExtraLogisticalTransporter> SUPREME_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityExtraLogisticalTransporter> COSMIC_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityExtraLogisticalTransporter> INFINITE_LOGISTICAL_TRANSPORTER;
    public static final TileEntityTypeRegistryObject<TileEntityExtraThermodynamicConductor> ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityExtraThermodynamicConductor> SUPREME_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityExtraThermodynamicConductor> COSMIC_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityExtraThermodynamicConductor> INFINITE_THERMODYNAMIC_CONDUCTOR;
    public static final TileEntityTypeRegistryObject<TileEntityReinforcedInductionCasing> REINFORCED_INDUCTION_CASING;
    public static final TileEntityTypeRegistryObject<TileEntityReinforcedInductionPort> REINFORCED_INDUCTION_PORT;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionCell> ABSOLUTE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionCell> SUPREME_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionCell> COSMIC_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionCell> INFINITE_INDUCTION_CELL;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionProvider> ABSOLUTE_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionProvider> SUPREME_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionProvider> COSMIC_INDUCTION_PROVIDER;
    public static final TileEntityTypeRegistryObject<TileEntityExtraInductionProvider> INFINITE_INDUCTION_PROVIDER;

    private static void registerFactory(ExtraFactoryTier tier, FactoryType type, BlockEntityFactory<? extends TileEntityExtraFactory<?>> factoryConstructor) {
        BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory> block = ExtraBlocks.getExtraFactory(tier, type);
        TileEntityTypeRegistryObject tileRO = EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> (TileEntityExtraFactory)((Object)((Object)factoryConstructor.create((Holder<Block>)block, pos, state)))).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        FACTORIES.put((Object)tier, (Object)type, (Object)tileRO);
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraBin> registerBin(BlockRegistryObject<BlockExtraBin, ItemBlockExtraBin> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityExtraBin((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraEnergyCube> registerEnergyCube(BlockRegistryObject<BlockExtraEnergyCube, ItemBlockExtraEnergyCube> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityExtraEnergyCube((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraFluidTank> registerFluidTank(BlockRegistryObject<BlockExtraFluidTank, ItemBlockExtraFluidTank> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityExtraFluidTank((Holder<Block>)block, pos, state)).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraChemicalTank> registerChemicalTank(BlockRegistryObject<?, ItemBlockExtraChemicalTank> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityExtraChemicalTank((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityLargeCapRadioactiveWasteBarrel> registryWasteBarrel(BlockRegistryObject<?, ItemBlockLargeCapRadioactiveWasteBarrel> block) {
        return EXTRA_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> new TileEntityLargeCapRadioactiveWasteBarrel((Holder<Block>)block, pos, state)).serverTicker(TileEntityMekanism::tickServer).build();
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraUniversalCable> registerCable(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<TileEntityExtraUniversalCable> builder = ExtraTileEntityTypes.transmitterBuilder(block, TileEntityExtraUniversalCable::new);
        EnergyCompatUtils.addBlockCapabilities(builder);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(builder, (BooleanSupplier)ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraMechanicalPipe> registerPipe(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder builder = ExtraTileEntityTypes.transmitterBuilder(block, TileEntityExtraMechanicalPipe::new).with(Capabilities.FLUID.block(), CapabilityTileEntity.FLUID_HANDLER_PROVIDER);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities((TileEntityTypeDeferredRegister.BlockEntityTypeBuilder)builder, (BooleanSupplier)ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraPressurizedTube> registerTube(BlockRegistryObject<?, ?> block) {
        TileEntityTypeDeferredRegister.BlockEntityTypeBuilder builder = ExtraTileEntityTypes.transmitterBuilder(block, TileEntityExtraPressurizedTube::new).with(Capabilities.CHEMICAL.block(), CapabilityTileEntity.CHEMICAL_HANDLER_PROVIDER);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities((TileEntityTypeDeferredRegister.BlockEntityTypeBuilder)builder, (BooleanSupplier)ConstantPredicates.ALWAYS_TRUE);
        }
        return builder.build();
    }

    private static <BE extends TileEntityExtraLogisticalTransporterBase> TileEntityTypeRegistryObject<BE> registerTransporter(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return ExtraTileEntityTypes.transporterBuilder(block, factory).build();
    }

    private static <BE extends TileEntityExtraLogisticalTransporterBase> TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<BE> transporterBuilder(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return ExtraTileEntityTypes.transmitterBuilder(block, factory).clientTicker(TileEntityExtraLogisticalTransporterBase::tickClient).with(Capabilities.ITEM.block(), CapabilityTileEntity.ITEM_HANDLER_PROVIDER);
    }

    private static TileEntityTypeRegistryObject<TileEntityExtraThermodynamicConductor> registerConductor(BlockRegistryObject<?, ?> block) {
        return ExtraTileEntityTypes.transmitterBuilder(block, TileEntityExtraThermodynamicConductor::new).with(Capabilities.HEAT, CapabilityTileEntity.HEAT_HANDLER_PROVIDER).build();
    }

    private static <BE extends TileEntityExtraTransmitter> TileEntityTypeDeferredRegister.BlockEntityTypeBuilder<BE> transmitterBuilder(BlockRegistryObject<?, ?> block, BlockEntityFactory<BE> factory) {
        return EXTRA_TILE_ENTITY_TYPES.builder(block, (pos, state) -> (TileEntityExtraTransmitter)factory.create((Holder<Block>)block, pos, state)).serverTicker(TileEntityExtraTransmitter::tickServer).withSimple(ExtraCapabilities.EXTRA_ALLOY_INTERACTION).with(Capabilities.CONFIGURABLE, TileEntityExtraTransmitter.CONFIGURABLE_PROVIDER);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>> getAdvancedFactoryTile(ExtraFactoryTier tier, FactoryType type) {
        return (TileEntityTypeRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraFactory<?>>[] getAdvancedFactoryTiles() {
        return FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    public static void register(IEventBus eventBus) {
        EXTRA_TILE_ENTITY_TYPES.register(eventBus);
    }

    static {
        for (ExtraFactoryTier tier : ExtraEnumUtils.EXTRA_FACTORY_TIERS) {
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.COMBINING, TileEntityExtraCombiningFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.COMPRESSING, TileEntityExtraItemStackChemicalToItemStackFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.CRUSHING, TileEntityExtraItemStackToItemStackFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.ENRICHING, TileEntityExtraItemStackToItemStackFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.INFUSING, TileEntityExtraItemStackChemicalToItemStackFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.INJECTING, TileEntityExtraItemStackChemicalToItemStackFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.PURIFYING, TileEntityExtraItemStackChemicalToItemStackFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.SAWING, TileEntityExtraSawingFactory::new);
            ExtraTileEntityTypes.registerFactory(tier, FactoryType.SMELTING, TileEntityExtraItemStackToItemStackFactory::new);
        }
        ADVANCED_ELECTRIC_PUMP = EXTRA_TILE_ENTITY_TYPES.mekBuilder(ExtraBlocks.ADVANCED_ELECTRIC_PUMP, TileEntityAdvancedElectricPump::new).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
        ABSOLUTE_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.ABSOLUTE_BIN);
        SUPREME_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.SUPREME_BIN);
        COSMIC_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.COSMIC_BIN);
        INFINITE_BIN = ExtraTileEntityTypes.registerBin(ExtraBlocks.INFINITE_BIN);
        ABSOLUTE_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.ABSOLUTE_ENERGY_CUBE);
        SUPREME_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.SUPREME_ENERGY_CUBE);
        COSMIC_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.COSMIC_ENERGY_CUBE);
        INFINITE_ENERGY_CUBE = ExtraTileEntityTypes.registerEnergyCube(ExtraBlocks.INFINITE_ENERGY_CUBE);
        ABSOLUTE_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.ABSOLUTE_FLUID_TANK);
        SUPREME_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.SUPREME_FLUID_TANK);
        COSMIC_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.COSMIC_FLUID_TANK);
        INFINITE_FLUID_TANK = ExtraTileEntityTypes.registerFluidTank(ExtraBlocks.INFINITE_FLUID_TANK);
        ABSOLUTE_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.ABSOLUTE_CHEMICAL_TANK);
        SUPREME_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.SUPREME_CHEMICAL_TANK);
        COSMIC_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.COSMIC_CHEMICAL_TANK);
        INFINITE_CHEMICAL_TANK = ExtraTileEntityTypes.registerChemicalTank(ExtraBlocks.INFINITE_CHEMICAL_TANK);
        ABSOLUTE_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.ABSOLUTE_RADIOACTIVE_WASTE_BARREL);
        SUPREME_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.SUPREME_RADIOACTIVE_WASTE_BARREL);
        COSMIC_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.COSMIC_RADIOACTIVE_WASTE_BARREL);
        INFINITE_RADIOACTIVE_WASTE_BARREL = ExtraTileEntityTypes.registryWasteBarrel(ExtraBlocks.INFINITE_RADIOACTIVE_WASTE_BARREL);
        ABSOLUTE_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.ABSOLUTE_UNIVERSAL_CABLE);
        SUPREME_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.SUPREME_UNIVERSAL_CABLE);
        COSMIC_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.COSMIC_UNIVERSAL_CABLE);
        INFINITE_UNIVERSAL_CABLE = ExtraTileEntityTypes.registerCable(ExtraBlocks.INFINITE_UNIVERSAL_CABLE);
        ABSOLUTE_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.ABSOLUTE_MECHANICAL_PIPE);
        SUPREME_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.SUPREME_MECHANICAL_PIPE);
        COSMIC_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.COSMIC_MECHANICAL_PIPE);
        INFINITE_MECHANICAL_PIPE = ExtraTileEntityTypes.registerPipe(ExtraBlocks.INFINITE_MECHANICAL_PIPE);
        ABSOLUTE_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.ABSOLUTE_PRESSURIZED_TUBE);
        SUPREME_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.SUPREME_PRESSURIZED_TUBE);
        COSMIC_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.COSMIC_PRESSURIZED_TUBE);
        INFINITE_PRESSURIZED_TUBE = ExtraTileEntityTypes.registerTube(ExtraBlocks.INFINITE_PRESSURIZED_TUBE);
        ABSOLUTE_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.ABSOLUTE_LOGISTICAL_TRANSPORTER, TileEntityExtraLogisticalTransporter::new);
        SUPREME_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.SUPREME_LOGISTICAL_TRANSPORTER, TileEntityExtraLogisticalTransporter::new);
        COSMIC_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.COSMIC_LOGISTICAL_TRANSPORTER, TileEntityExtraLogisticalTransporter::new);
        INFINITE_LOGISTICAL_TRANSPORTER = ExtraTileEntityTypes.registerTransporter(ExtraBlocks.INFINITE_LOGISTICAL_TRANSPORTER, TileEntityExtraLogisticalTransporter::new);
        ABSOLUTE_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.ABSOLUTE_THERMODYNAMIC_CONDUCTOR);
        SUPREME_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.SUPREME_THERMODYNAMIC_CONDUCTOR);
        COSMIC_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.COSMIC_THERMODYNAMIC_CONDUCTOR);
        INFINITE_THERMODYNAMIC_CONDUCTOR = ExtraTileEntityTypes.registerConductor(ExtraBlocks.INFINITE_THERMODYNAMIC_CONDUCTOR);
        REINFORCED_INDUCTION_CASING = EXTRA_TILE_ENTITY_TYPES.mekBuilder(ExtraBlocks.REINFORCED_INDUCTION_CASING, TileEntityReinforcedInductionCasing::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).without(new BlockCapability[]{Capabilities.ITEM.block()}).build();
        REINFORCED_INDUCTION_PORT = EXTRA_TILE_ENTITY_TYPES.mekBuilder(ExtraBlocks.REINFORCED_INDUCTION_PORT, TileEntityReinforcedInductionPort::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIGURABLE).build();
        ABSOLUTE_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.ABSOLUTE_INDUCTION_CELL, (pos, state) -> new TileEntityExtraInductionCell((Holder<Block>)ExtraBlocks.ABSOLUTE_INDUCTION_CELL, pos, state)).build();
        SUPREME_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.SUPREME_INDUCTION_CELL, (pos, state) -> new TileEntityExtraInductionCell((Holder<Block>)ExtraBlocks.SUPREME_INDUCTION_CELL, pos, state)).build();
        COSMIC_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.COSMIC_INDUCTION_CELL, (pos, state) -> new TileEntityExtraInductionCell((Holder<Block>)ExtraBlocks.COSMIC_INDUCTION_CELL, pos, state)).build();
        INFINITE_INDUCTION_CELL = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.INFINITE_INDUCTION_CELL, (pos, state) -> new TileEntityExtraInductionCell((Holder<Block>)ExtraBlocks.INFINITE_INDUCTION_CELL, pos, state)).build();
        ABSOLUTE_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.ABSOLUTE_INDUCTION_PROVIDER, (pos, state) -> new TileEntityExtraInductionProvider((Holder<Block>)ExtraBlocks.ABSOLUTE_INDUCTION_PROVIDER, pos, state)).build();
        SUPREME_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.SUPREME_INDUCTION_PROVIDER, (pos, state) -> new TileEntityExtraInductionProvider((Holder<Block>)ExtraBlocks.SUPREME_INDUCTION_PROVIDER, pos, state)).build();
        COSMIC_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.COSMIC_INDUCTION_PROVIDER, (pos, state) -> new TileEntityExtraInductionProvider((Holder<Block>)ExtraBlocks.COSMIC_INDUCTION_PROVIDER, pos, state)).build();
        INFINITE_INDUCTION_PROVIDER = EXTRA_TILE_ENTITY_TYPES.builder(ExtraBlocks.INFINITE_INDUCTION_PROVIDER, (pos, state) -> new TileEntityExtraInductionProvider((Holder<Block>)ExtraBlocks.INFINITE_INDUCTION_PROVIDER, pos, state)).build();
    }

    @FunctionalInterface
    private static interface BlockEntityFactory<BE extends BlockEntity> {
        public BE create(Holder<Block> var1, BlockPos var2, BlockState var3);
    }
}

