/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekextras.MekanismExtras;
import com.jerry.mekextras.api.tier.IAdvancedTier;
import com.jerry.mekextras.common.attachments.containers.chemical.ExtraComponentBackedChemicalTankTank;
import com.jerry.mekextras.common.attachments.containers.fluid.ExtraComponentBackedFluidTankFluidTank;
import com.jerry.mekextras.common.attachments.containers.item.ExtraComponentBackedBinInventorySlot;
import com.jerry.mekextras.common.block.BlockExtraEnergyCube;
import com.jerry.mekextras.common.block.BlockLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekextras.common.block.basic.BlockExtraBin;
import com.jerry.mekextras.common.block.basic.BlockExtraFluidTank;
import com.jerry.mekextras.common.block.basic.BlockExtraResource;
import com.jerry.mekextras.common.block.prefab.BlockExtraFactoryMachine;
import com.jerry.mekextras.common.content.blocktype.ExtraFactory;
import com.jerry.mekextras.common.item.block.ItemBlockExtraBin;
import com.jerry.mekextras.common.item.block.ItemBlockExtraChemicalTank;
import com.jerry.mekextras.common.item.block.ItemBlockExtraEnergyCube;
import com.jerry.mekextras.common.item.block.ItemBlockExtraInductionCell;
import com.jerry.mekextras.common.item.block.ItemBlockExtraInductionProvider;
import com.jerry.mekextras.common.item.block.ItemBlockLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.item.block.machine.ItemBlockExtraFactory;
import com.jerry.mekextras.common.item.block.machine.ItemBlockExtraFluidTank;
import com.jerry.mekextras.common.item.block.transmitter.ItemBlockExtraLogisticalTransporter;
import com.jerry.mekextras.common.item.block.transmitter.ItemBlockExtraMechanicalPipe;
import com.jerry.mekextras.common.item.block.transmitter.ItemBlockExtraPressurizedTube;
import com.jerry.mekextras.common.item.block.transmitter.ItemBlockExtraThermodynamicConductor;
import com.jerry.mekextras.common.item.block.transmitter.ItemBlockExtraUniversalCable;
import com.jerry.mekextras.common.registries.ExtraBlockTypes;
import com.jerry.mekextras.common.resource.BlockExtraResourceInfo;
import com.jerry.mekextras.common.resource.ExtraResource;
import com.jerry.mekextras.common.resource.ore.ExtraOreType;
import com.jerry.mekextras.common.tier.BTier;
import com.jerry.mekextras.common.tier.CTTier;
import com.jerry.mekextras.common.tier.ECTier;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.tier.FTTier;
import com.jerry.mekextras.common.tier.ICTier;
import com.jerry.mekextras.common.tier.IPTier;
import com.jerry.mekextras.common.tier.RWBTier;
import com.jerry.mekextras.common.tile.TileEntityExtraBin;
import com.jerry.mekextras.common.tile.TileEntityExtraChemicalTank;
import com.jerry.mekextras.common.tile.TileEntityExtraEnergyCube;
import com.jerry.mekextras.common.tile.TileEntityExtraFluidTank;
import com.jerry.mekextras.common.tile.TileEntityLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekextras.common.tile.machine.TileEntityAdvancedElectricPump;
import com.jerry.mekextras.common.tile.multiblock.TileEntityExtraInductionCell;
import com.jerry.mekextras.common.tile.multiblock.TileEntityExtraInductionProvider;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraLogisticalTransporter;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraMechanicalPipe;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraPressurizedTube;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraThermodynamicConductor;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraUniversalCable;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import fr.iglee42.evolvedmekanism.registries.EMFactoryType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.ChemicalTanksBuilder;
import mekanism.common.attachments.containers.fluid.FluidTanksBuilder;
import mekanism.common.attachments.containers.item.ItemSlotsBuilder;
import mekanism.common.block.BlockOre;
import mekanism.common.block.prefab.BlockBasicMultiblock;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.resource.ore.OreType;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

public class ExtraBlocks {
    public static final BlockDeferredRegister EXTRA_BLOCKS = new BlockDeferredRegister("mekanism_extras");
    public static final Map<IResource, BlockRegistryObject<?, ?>> PROCESSED_RESOURCE_BLOCKS = new LinkedHashMap();
    public static final Map<OreType, OreBlockType> ORES = new LinkedHashMap<OreType, OreBlockType>();
    private static final Table<ExtraFactoryTier, FactoryType, BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory>> FACTORIES = HashBasedTable.create();
    public static final BlockRegistryObject<BlockExtraBin, ItemBlockExtraBin> ABSOLUTE_BIN;
    public static final BlockRegistryObject<BlockExtraBin, ItemBlockExtraBin> SUPREME_BIN;
    public static final BlockRegistryObject<BlockExtraBin, ItemBlockExtraBin> COSMIC_BIN;
    public static final BlockRegistryObject<BlockExtraBin, ItemBlockExtraBin> INFINITE_BIN;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityReinforcedInductionCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityReinforcedInductionCasing>>> REINFORCED_INDUCTION_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityReinforcedInductionPort>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityReinforcedInductionPort>>> REINFORCED_INDUCTION_PORT;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionCell, BlockTypeTile<TileEntityExtraInductionCell>>, ItemBlockExtraInductionCell> ABSOLUTE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionCell, BlockTypeTile<TileEntityExtraInductionCell>>, ItemBlockExtraInductionCell> SUPREME_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionCell, BlockTypeTile<TileEntityExtraInductionCell>>, ItemBlockExtraInductionCell> COSMIC_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionCell, BlockTypeTile<TileEntityExtraInductionCell>>, ItemBlockExtraInductionCell> INFINITE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionProvider, BlockTypeTile<TileEntityExtraInductionProvider>>, ItemBlockExtraInductionProvider> ABSOLUTE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionProvider, BlockTypeTile<TileEntityExtraInductionProvider>>, ItemBlockExtraInductionProvider> SUPREME_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionProvider, BlockTypeTile<TileEntityExtraInductionProvider>>, ItemBlockExtraInductionProvider> COSMIC_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityExtraInductionProvider, BlockTypeTile<TileEntityExtraInductionProvider>>, ItemBlockExtraInductionProvider> INFINITE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockExtraEnergyCube, ItemBlockExtraEnergyCube> ABSOLUTE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockExtraEnergyCube, ItemBlockExtraEnergyCube> SUPREME_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockExtraEnergyCube, ItemBlockExtraEnergyCube> COSMIC_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockExtraEnergyCube, ItemBlockExtraEnergyCube> INFINITE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockExtraFluidTank, ItemBlockExtraFluidTank> ABSOLUTE_FLUID_TANK;
    public static final BlockRegistryObject<BlockExtraFluidTank, ItemBlockExtraFluidTank> SUPREME_FLUID_TANK;
    public static final BlockRegistryObject<BlockExtraFluidTank, ItemBlockExtraFluidTank> COSMIC_FLUID_TANK;
    public static final BlockRegistryObject<BlockExtraFluidTank, ItemBlockExtraFluidTank> INFINITE_FLUID_TANK;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraUniversalCable>, ItemBlockExtraUniversalCable> ABSOLUTE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraUniversalCable>, ItemBlockExtraUniversalCable> SUPREME_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraUniversalCable>, ItemBlockExtraUniversalCable> COSMIC_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraUniversalCable>, ItemBlockExtraUniversalCable> INFINITE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraMechanicalPipe>, ItemBlockExtraMechanicalPipe> ABSOLUTE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraMechanicalPipe>, ItemBlockExtraMechanicalPipe> SUPREME_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraMechanicalPipe>, ItemBlockExtraMechanicalPipe> COSMIC_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraMechanicalPipe>, ItemBlockExtraMechanicalPipe> INFINITE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraPressurizedTube>, ItemBlockExtraPressurizedTube> ABSOLUTE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraPressurizedTube>, ItemBlockExtraPressurizedTube> SUPREME_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraPressurizedTube>, ItemBlockExtraPressurizedTube> COSMIC_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraPressurizedTube>, ItemBlockExtraPressurizedTube> INFINITE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraLogisticalTransporter>, ItemBlockExtraLogisticalTransporter> ABSOLUTE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraLogisticalTransporter>, ItemBlockExtraLogisticalTransporter> SUPREME_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraLogisticalTransporter>, ItemBlockExtraLogisticalTransporter> COSMIC_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraLogisticalTransporter>, ItemBlockExtraLogisticalTransporter> INFINITE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraThermodynamicConductor>, ItemBlockExtraThermodynamicConductor> ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraThermodynamicConductor>, ItemBlockExtraThermodynamicConductor> SUPREME_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraThermodynamicConductor>, ItemBlockExtraThermodynamicConductor> COSMIC_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraThermodynamicConductor>, ItemBlockExtraThermodynamicConductor> INFINITE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityExtraChemicalTank, Machine<TileEntityExtraChemicalTank>>, ItemBlockExtraChemicalTank> ABSOLUTE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityExtraChemicalTank, Machine<TileEntityExtraChemicalTank>>, ItemBlockExtraChemicalTank> SUPREME_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityExtraChemicalTank, Machine<TileEntityExtraChemicalTank>>, ItemBlockExtraChemicalTank> COSMIC_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityExtraChemicalTank, Machine<TileEntityExtraChemicalTank>>, ItemBlockExtraChemicalTank> INFINITE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> ABSOLUTE_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> SUPREME_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> COSMIC_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> INFINITE_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityAdvancedElectricPump, Machine<TileEntityAdvancedElectricPump>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityAdvancedElectricPump, Machine<TileEntityAdvancedElectricPump>>>> ADVANCED_ELECTRIC_PUMP;

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(IAdvancedTier tier, String suffix, Function<MapColor, ? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return ExtraBlocks.registerTieredBlock(tier, suffix, () -> (Block)blockSupplier.apply(tier.getAdvanceTier().getMapColor()), itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(IAdvancedTier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return EXTRA_BLOCKS.register(tier.getAdvanceTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(String registerName, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return EXTRA_BLOCKS.register(registerName, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockTooltip<BLOCK>> registerBlock(String name, Supplier<? extends BLOCK> blockSupplier) {
        return EXTRA_BLOCKS.register(name, blockSupplier, (x$0, x$1) -> new ItemBlockTooltip((Block)x$0, x$1));
    }

    private static BlockRegistryObject<BlockExtraResource, ItemBlockMekanism<BlockExtraResource>> registerResourceBlock(BlockExtraResourceInfo resource) {
        return EXTRA_BLOCKS.register("block_" + resource.getRegistrySuffix(), () -> new BlockExtraResource(resource), (block, properties) -> {
            if (!block.getResourceInfo().burnsInFire()) {
                properties = properties.fireResistant();
            }
            return new ItemBlockMekanism((Block)block, properties);
        });
    }

    public static OreBlockType registerOre(OreType ore) {
        String name = ore.getResource().getRegistrySuffix() + "_ore";
        BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> stoneOre = ExtraBlocks.registerBlock(name, () -> new BlockOre(ore));
        BlockRegistryObject endOre = EXTRA_BLOCKS.register("end_" + name, () -> new BlockOre(ore, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)stoneOre.value())).mapColor(MapColor.SAND).strength(3.0f, 9.0f).sound(SoundType.STONE)), ItemBlockTooltip::new);
        return new OreBlockType(stoneOre, endOre);
    }

    private static BlockRegistryObject<BlockExtraBin, ItemBlockExtraBin> registerBin(BlockTypeTile<TileEntityExtraBin> type) {
        BTier tier = (BTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_bin", (MapColor color) -> new BlockExtraBin(type, properties -> properties.mapColor(color)), ItemBlockExtraBin::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addSlot(ExtraComponentBackedBinInventorySlot::create).build()));
    }

    private static BlockRegistryObject<BlockTile<TileEntityExtraInductionCell, BlockTypeTile<TileEntityExtraInductionCell>>, ItemBlockExtraInductionCell> registerInductionCell(BlockTypeTile<TileEntityExtraInductionCell> type) {
        ICTier tier = (ICTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_induction_cell", (MapColor color) -> new BlockTile(type, properties -> properties.mapColor(color)), ItemBlockExtraInductionCell::new);
    }

    private static BlockRegistryObject<BlockTile<TileEntityExtraInductionProvider, BlockTypeTile<TileEntityExtraInductionProvider>>, ItemBlockExtraInductionProvider> registerInductionProvider(BlockTypeTile<TileEntityExtraInductionProvider> type) {
        IPTier tier = (IPTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_induction_provider", (MapColor color) -> new BlockTile(type, properties -> properties.mapColor(color)), ItemBlockExtraInductionProvider::new);
    }

    private static BlockRegistryObject<BlockExtraEnergyCube, ItemBlockExtraEnergyCube> registerEnergyCube(Machine<TileEntityExtraEnergyCube> type) {
        ECTier tier = (ECTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_energy_cube", () -> new BlockExtraEnergyCube(type), ItemBlockExtraEnergyCube::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().addDrainEnergy().build()));
    }

    private static BlockRegistryObject<BlockExtraFluidTank, ItemBlockExtraFluidTank> registerFluidTank(Machine<TileEntityExtraFluidTank> type) {
        FTTier tier = (FTTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_fluid_tank", () -> new BlockExtraFluidTank(type), ItemBlockExtraFluidTank::new).forItemHolder(holder -> holder.addAttachedContainerCapabilities(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addTank(ExtraComponentBackedFluidTankFluidTank::create).build(), new IMekanismConfig[0]).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidInputSlot(0).addOutput().build()));
    }

    private static BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraUniversalCable>, ItemBlockExtraUniversalCable> registerUniversalCable(String nameTier, BlockTypeTile<TileEntityExtraUniversalCable> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_universal_cable", () -> new BlockSmallTransmitter(type), ItemBlockExtraUniversalCable::new);
    }

    private static BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraMechanicalPipe>, ItemBlockExtraMechanicalPipe> registerMechanicalPipe(String nameTier, BlockTypeTile<TileEntityExtraMechanicalPipe> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_mechanical_pipe", () -> new BlockLargeTransmitter(type), ItemBlockExtraMechanicalPipe::new);
    }

    private static BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraPressurizedTube>, ItemBlockExtraPressurizedTube> registerPressurizedTube(String nameTier, BlockTypeTile<TileEntityExtraPressurizedTube> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_pressurized_tube", () -> new BlockSmallTransmitter(type), ItemBlockExtraPressurizedTube::new);
    }

    private static BlockRegistryObject<BlockLargeTransmitter<TileEntityExtraLogisticalTransporter>, ItemBlockExtraLogisticalTransporter> registerLogisticalTransporter(String nameTier, BlockTypeTile<TileEntityExtraLogisticalTransporter> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_logistical_transporter", () -> new BlockLargeTransmitter(type), ItemBlockExtraLogisticalTransporter::new);
    }

    private static BlockRegistryObject<BlockSmallTransmitter<TileEntityExtraThermodynamicConductor>, ItemBlockExtraThermodynamicConductor> registerThermodynamicConductor(String nameTier, BlockTypeTile<TileEntityExtraThermodynamicConductor> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_thermodynamic_conductor", () -> new BlockSmallTransmitter(type), ItemBlockExtraThermodynamicConductor::new);
    }

    private static BlockRegistryObject<BlockTile.BlockTileModel<TileEntityExtraChemicalTank, Machine<TileEntityExtraChemicalTank>>, ItemBlockExtraChemicalTank> registerChemicalTank(Machine<TileEntityExtraChemicalTank> type) {
        CTTier tier = (CTTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_chemical_tank", (MapColor color) -> new BlockTile.BlockTileModel((BlockTypeTile)type, properties -> properties.mapColor(color)), ItemBlockExtraChemicalTank::new).forItemHolder(holder -> holder.addAttachedContainerCapabilities(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addTank(ExtraComponentBackedChemicalTankTank::create).build(), new IMekanismConfig[0]).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalDrainSlot(0).addChemicalFillSlot(0).build()));
    }

    private static BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> registryWasteBarrel(BlockTypeTile<TileEntityLargeCapRadioactiveWasteBarrel> type) {
        RWBTier tier = (RWBTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_radioactive_waste_barrel", () -> new BlockLargeCapRadioactiveWasteBarrel(type), ItemBlockLargeCapRadioactiveWasteBarrel::new);
    }

    private static <TILE extends TileEntityExtraFactory<?>> BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory> registerFactory(ExtraFactory<TILE> type) {
        ExtraFactoryTier tier = (ExtraFactoryTier)((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory, ItemBlockExtraFactory> factory = ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_" + type.getFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockExtraFactoryMachine.BlockExtraFactory(type), ItemBlockExtraFactory::new);
        factory.forItemHolder(holder -> {
            int processes = tier.processes;
            Predicate<ItemStack> recipeInputPredicate = switch (type.getFactoryType()) {
                default -> throw new MatchException(null, null);
                case FactoryType.SMELTING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SMELTING.getInputCache()).containsInput(null, s);
                case FactoryType.ENRICHING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.ENRICHING.getInputCache()).containsInput(null, s);
                case FactoryType.CRUSHING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.CRUSHING.getInputCache()).containsInput(null, s);
                case FactoryType.COMPRESSING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.COMPRESSING.getInputCache()).containsInputA(null, s);
                case FactoryType.COMBINING -> s -> ((InputRecipeCache.DoubleItem)MekanismRecipeType.COMBINING.getInputCache()).containsInputA(null, s);
                case FactoryType.PURIFYING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.PURIFYING.getInputCache()).containsInputA(null, s);
                case FactoryType.INJECTING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.INJECTING.getInputCache()).containsInputA(null, s);
                case FactoryType.INFUSING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.METALLURGIC_INFUSING.getInputCache()).containsInputA(null, s);
                case FactoryType.SAWING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SAWING.getInputCache()).containsInput(null, s);
            };
            switch (type.getFactoryType()) {
                case SMELTING: 
                case ENRICHING: 
                case CRUSHING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addEnergy().build());
                    break;
                }
                case COMPRESSING: 
                case PURIFYING: 
                case INJECTING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> {
                        ChemicalTanksBuilder chemicalTanksBuilder = ChemicalTanksBuilder.builder();
                        long l = 210L * (long)processes * (long)processes;
                        return chemicalTanksBuilder.addBasic(l, (IMekanismRecipeTypeProvider)(switch (type.getFactoryType()) {
                            case FactoryType.COMPRESSING -> MekanismRecipeType.COMPRESSING;
                            case FactoryType.INJECTING -> MekanismRecipeType.INJECTING;
                            case FactoryType.PURIFYING -> MekanismRecipeType.PURIFYING;
                            default -> throw new IllegalStateException("Factory type doesn't have a known gas recipe");
                        }), DoubleInputRecipeCache::containsInputB).build();
                    }).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addChemicalFillOrConvertSlot(0).addEnergy().build());
                    break;
                }
                case COMBINING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInput((IMekanismRecipeTypeProvider)MekanismRecipeType.COMBINING, DoubleInputRecipeCache::containsInputB).addEnergy().build());
                    break;
                }
                case INFUSING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(1000L * (long)processes * (long)processes, (IMekanismRecipeTypeProvider)MekanismRecipeType.METALLURGIC_INFUSING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInfusionFillOrConvertSlot(0).addEnergy().build());
                    break;
                }
                case SAWING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate, true).addEnergy().build());
                }
            }
        });
        return factory;
    }

    public static BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory> getExtraFactory(@NotNull ExtraFactoryTier tier, @NotNull FactoryType type) {
        return (BlockRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory>[] getExtraFactoryBlocks() {
        return FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    public static void register(IEventBus eventBus) {
        EXTRA_BLOCKS.register(eventBus);
    }

    static {
        for (ExtraFactoryTier extraFactoryTier : ExtraEnumUtils.EXTRA_FACTORY_TIERS) {
            for (FactoryType type : EnumUtils.FACTORY_TYPES) {
                if (MekanismExtras.hooks.evolvedMekanism.isLoaded()) {
                    if (type == EMFactoryType.ALLOYING) continue;
                    FACTORIES.put((Object)extraFactoryTier, (Object)type, ExtraBlocks.registerFactory(ExtraBlockTypes.getAdvancedFactory(extraFactoryTier, type)));
                    continue;
                }
                FACTORIES.put((Object)extraFactoryTier, (Object)type, ExtraBlocks.registerFactory(ExtraBlockTypes.getAdvancedFactory(extraFactoryTier, type)));
            }
        }
        for (Enum enum_ : ExtraEnumUtils.EXTRA_RESOURCES) {
            BlockExtraResourceInfo rawResource;
            if (((ExtraResource)enum_).getResourceBlockInfo() != null) {
                PROCESSED_RESOURCE_BLOCKS.put((IResource)enum_, ExtraBlocks.registerResourceBlock(((ExtraResource)enum_).getResourceBlockInfo()));
            }
            if ((rawResource = ((ExtraResource)enum_).getRawResourceBlockInfo()) == null) continue;
            PROCESSED_RESOURCE_BLOCKS.put(rawResource, ExtraBlocks.registerResourceBlock(rawResource));
        }
        for (Enum enum_ : EnumUtils.ORE_TYPES) {
            if (enum_ != ExtraOreType.NAQUADAH) continue;
            ORES.put((OreType)enum_, ExtraBlocks.registerOre((OreType)enum_));
        }
        ABSOLUTE_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.ABSOLUTE_BIN);
        SUPREME_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.SUPREME_BIN);
        COSMIC_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.COSMIC_BIN);
        INFINITE_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.INFINITE_BIN);
        REINFORCED_INDUCTION_CASING = ExtraBlocks.registerBlock("reinforced_induction_casing", () -> new BlockBasicMultiblock(ExtraBlockTypes.REINFORCED_INDUCTION_CASING, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)));
        REINFORCED_INDUCTION_PORT = ExtraBlocks.registerBlock("reinforced_induction_port", () -> new BlockBasicMultiblock(ExtraBlockTypes.REINFORCED_INDUCTION_PORT, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)));
        ABSOLUTE_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.ABSOLUTE_INDUCTION_CELL);
        SUPREME_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.SUPREME_INDUCTION_CELL);
        COSMIC_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.COSMIC_INDUCTION_CELL);
        INFINITE_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.INFINITE_INDUCTION_CELL);
        ABSOLUTE_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.ABSOLUTE_INDUCTION_PROVIDER);
        SUPREME_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.SUPREME_INDUCTION_PROVIDER);
        COSMIC_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.COSMIC_INDUCTION_PROVIDER);
        INFINITE_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.INFINITE_INDUCTION_PROVIDER);
        ABSOLUTE_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.ABSOLUTE_ENERGY_CUBE);
        SUPREME_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.SUPREME_ENERGY_CUBE);
        COSMIC_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.COSMIC_ENERGY_CUBE);
        INFINITE_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.INFINITE_ENERGY_CUBE);
        ABSOLUTE_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.ABSOLUTE_FLUID_TANK);
        SUPREME_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.SUPREME_FLUID_TANK);
        COSMIC_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.COSMIC_FLUID_TANK);
        INFINITE_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.INFINITE_FLUID_TANK);
        ABSOLUTE_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("absolute", ExtraBlockTypes.ABSOLUTE_UNIVERSAL_CABLE);
        SUPREME_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("supreme", ExtraBlockTypes.SUPREME_UNIVERSAL_CABLE);
        COSMIC_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("cosmic", ExtraBlockTypes.COSMIC_UNIVERSAL_CABLE);
        INFINITE_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("infinite", ExtraBlockTypes.INFINITE_UNIVERSAL_CABLE);
        ABSOLUTE_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("absolute", ExtraBlockTypes.ABSOLUTE_MECHANICAL_PIPE);
        SUPREME_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("supreme", ExtraBlockTypes.SUPREME_MECHANICAL_PIPE);
        COSMIC_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("cosmic", ExtraBlockTypes.COSMIC_MECHANICAL_PIPE);
        INFINITE_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("infinite", ExtraBlockTypes.INFINITE_MECHANICAL_PIPE);
        ABSOLUTE_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("absolute", ExtraBlockTypes.ABSOLUTE_PRESSURIZED_TUBE);
        SUPREME_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("supreme", ExtraBlockTypes.SUPREME_PRESSURIZED_TUBE);
        COSMIC_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("cosmic", ExtraBlockTypes.COSMIC_PRESSURIZED_TUBE);
        INFINITE_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("infinite", ExtraBlockTypes.INFINITE_PRESSURIZED_TUBE);
        ABSOLUTE_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("absolute", ExtraBlockTypes.ABSOLUTE_LOGISTICAL_TRANSPORTER);
        SUPREME_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("supreme", ExtraBlockTypes.SUPREME_LOGISTICAL_TRANSPORTER);
        COSMIC_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("cosmic", ExtraBlockTypes.COSMIC_LOGISTICAL_TRANSPORTER);
        INFINITE_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("infinite", ExtraBlockTypes.INFINITE_LOGISTICAL_TRANSPORTER);
        ABSOLUTE_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("absolute", ExtraBlockTypes.ABSOLUTE_THERMODYNAMIC_CONDUCTOR);
        SUPREME_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("supreme", ExtraBlockTypes.SUPREME_THERMODYNAMIC_CONDUCTOR);
        COSMIC_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("cosmic", ExtraBlockTypes.COSMIC_THERMODYNAMIC_CONDUCTOR);
        INFINITE_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("infinite", ExtraBlockTypes.INFINITE_THERMODYNAMIC_CONDUCTOR);
        ABSOLUTE_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.ABSOLUTE_CHEMICAL_TANK);
        SUPREME_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.SUPREME_CHEMICAL_TANK);
        COSMIC_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.COSMIC_CHEMICAL_TANK);
        INFINITE_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.INFINITE_CHEMICAL_TANK);
        ABSOLUTE_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.ABSOLUTE_RADIOACTIVE_WASTE_BARREL);
        SUPREME_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.SUPREME_RADIOACTIVE_WASTE_BARREL);
        COSMIC_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.COSMIC_RADIOACTIVE_WASTE_BARREL);
        INFINITE_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.INFINITE_RADIOACTIVE_WASTE_BARREL);
        ADVANCED_ELECTRIC_PUMP = EXTRA_BLOCKS.register("advanced_electric_pump", () -> new BlockTile.BlockTileModel(ExtraBlockTypes.ADVANCED_ELECTRIC_PUMP, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), ItemBlockTooltip::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(1000).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidDrainSlot(0).addOutput().addEnergy().build()));
    }
}

