/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.network.to_server.button;

import com.jerry.genextras.common.GenExtraLang;
import com.jerry.genextras.common.registries.GenExtraContainerTypes;
import com.jerry.genextras.common.tile.naquadah.TileEntityNaquadahReactorController;
import com.jerry.mekextras.MekanismExtras;
import com.jerry.mekextras.common.registries.ExtraContainerTypes;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ExtraPacketTileButtonPress(ClickedTileButton buttonClicked, BlockPos pos) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<ExtraPacketTileButtonPress> TYPE = new CustomPacketPayload.Type(MekanismExtras.rl("tile_button"));
    public static final StreamCodec<ByteBuf, ExtraPacketTileButtonPress> STREAM_CODEC = StreamCodec.composite(ClickedTileButton.STREAM_CODEC, ExtraPacketTileButtonPress::buttonClicked, (StreamCodec)BlockPos.STREAM_CODEC, ExtraPacketTileButtonPress::pos, ExtraPacketTileButtonPress::new);

    public ExtraPacketTileButtonPress(ClickedTileButton buttonClicked, BlockEntity tile) {
        this(buttonClicked, tile.getBlockPos());
    }

    @NotNull
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull @NotNull CustomPacketPayload.Type<ExtraPacketTileButtonPress> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.pos);
        MenuProvider provider = this.buttonClicked.getProvider(tile);
        if (provider != null) {
            player.openMenu(provider, buf -> {
                buf.writeBlockPos(this.pos);
                this.buttonClicked.encodeExtraData((RegistryFriendlyByteBuf)buf, tile);
            });
        }
    }

    public static enum ClickedTileButton {
        BACK_BUTTON(tile -> {
            AttributeGui attributeGui = (AttributeGui)Attribute.get((Holder)tile.getBlockHolder(), AttributeGui.class);
            return attributeGui != null ? attributeGui.getProvider(tile, false) : null;
        }),
        TAB_MAIN(tile -> {
            if (tile instanceof TileEntityReinforcedInductionCasing) {
                return ExtraContainerTypes.REINFORCED_INDUCTION_MATRIX.getProvider((ILangEntry)MekanismLang.MATRIX, tile);
            }
            return null;
        }),
        TAB_HEAT(tile -> GenExtraContainerTypes.NAQUADAH_REACTOR_HEAT.getProvider((ILangEntry)GenExtraLang.NAQUADAH_REACTOR, tile)),
        TAB_FUEL(tile -> GenExtraContainerTypes.NAQUADAH_REACTOR_FUEL.getProvider((ILangEntry)GenExtraLang.NAQUADAH_REACTOR, tile)),
        TAB_STATS(tile -> {
            if (tile instanceof TileEntityReinforcedInductionCasing) {
                return ExtraContainerTypes.REINFORCED_MATRIX_STATS.getProvider((ILangEntry)MekanismLang.MATRIX_STATS, tile);
            }
            if (tile instanceof TileEntityNaquadahReactorController) {
                return GenExtraContainerTypes.NAQUADAH_REACTOR_STATS.getProvider((ILangEntry)GenExtraLang.NAQUADAH_REACTOR, tile);
            }
            return null;
        });

        public static final IntFunction<ClickedTileButton> BY_ID;
        public static final StreamCodec<ByteBuf, ClickedTileButton> STREAM_CODEC;
        private final Function<TileEntityMekanism, MenuProvider> providerFromTile;
        @Nullable
        private final BiConsumer<RegistryFriendlyByteBuf, TileEntityMekanism> extraEncodingData;

        private ClickedTileButton(Function<TileEntityMekanism, MenuProvider> providerFromTile) {
            this(providerFromTile, null);
        }

        private ClickedTileButton(Function<TileEntityMekanism, MenuProvider> providerFromTile, BiConsumer<RegistryFriendlyByteBuf, TileEntityMekanism> extraEncodingData) {
            this.providerFromTile = providerFromTile;
            this.extraEncodingData = extraEncodingData;
        }

        public MenuProvider getProvider(TileEntityMekanism tile) {
            return tile == null ? null : this.providerFromTile.apply(tile);
        }

        private void encodeExtraData(RegistryFriendlyByteBuf buffer, TileEntityMekanism tile) {
            if (this.extraEncodingData != null) {
                this.extraEncodingData.accept(buffer, tile);
            }
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ClickedTileButton.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

