/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block;

import com.jerry.mekextras.common.item.block.ItemBlockExtra;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.AutomationType;
import mekanism.api.Upgrade;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.IAttachmentAware;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.energy.ComponentBackedNoClampEnergyContainer;
import mekanism.common.attachments.containers.energy.EnergyContainersBuilder;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasDescription;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.security.SecurityObject;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.common.util.text.UpgradeDisplay;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ItemBlockExtraTooltip<BLOCK extends Block>
extends ItemBlockExtra<BLOCK>
implements ICapabilityAware,
IAttachmentAware {
    private final boolean hasDetails;

    public ItemBlockExtraTooltip(BLOCK block, Item.Properties properties) {
        this(block, false, properties);
    }

    protected ItemBlockExtraTooltip(BLOCK block, boolean hasDetails, Item.Properties properties) {
        super((Block)block, properties);
        this.hasDetails = hasDetails;
    }

    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        InventoryUtils.dropItemContents((ItemEntity)item, (DamageSource)damageSource);
    }

    public boolean placeBlock(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        AttributeHasBounding hasBounding = (AttributeHasBounding)Attribute.get((BlockState)state, AttributeHasBounding.class);
        if (hasBounding == null) {
            return super.placeBlock(context, state);
        }
        return hasBounding.handle(context.getLevel(), context.getClickedPos(), state, (Object)context, (level, pos, ctx) -> WorldUtils.isValidReplaceableBlock((BlockGetter)level, (BlockPlaceContext)ctx, (BlockPos)pos)) && super.placeBlock(context, state);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.descriptionKey)) {
            tooltip.add((Component)((IHasDescription)this.getBlock()).getDescription().translate());
        } else if (this.hasDetails && MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addDetails(stack, context, tooltip, flag);
        } else {
            this.addStats(stack, context, tooltip, flag);
            if (this.hasDetails) {
                tooltip.add((Component)MekanismLang.HOLD_FOR_DETAILS.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()}));
            }
            tooltip.add((Component)MekanismLang.HOLD_FOR_DESCRIPTION.translateColored(EnumColor.GRAY, new Object[]{EnumColor.AQUA, MekanismKeyHandler.descriptionKey.getTranslatedKeyMessage()}));
        }
    }

    protected void addStats(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
    }

    protected void addDetails(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        UpgradeAware upgradeAware;
        IItemSecurityUtils.INSTANCE.addSecurityTooltip(stack, tooltip);
        this.addTypeDetails(stack, context, tooltip, flag);
        FluidStack fluidStack = StorageUtils.getStoredFluidFromAttachment((ItemStack)stack);
        if (!fluidStack.isEmpty()) {
            tooltip.add((Component)MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, new Object[]{fluidStack, EnumColor.GRAY, TextUtils.format((long)fluidStack.getAmount())}));
        }
        if (Attribute.has(this.getBlock(), Attributes.AttributeInventory.class) && ContainerType.ITEM.supports(stack)) {
            tooltip.add((Component)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, new Object[]{EnumColor.GRAY, BooleanStateDisplay.YesNo.hasInventory((ItemStack)stack)}));
        }
        if (Attribute.has(this.getBlock(), AttributeUpgradeSupport.class) && (upgradeAware = (UpgradeAware)stack.get((Supplier)MekanismDataComponents.UPGRADES)) != null) {
            for (Map.Entry entry : upgradeAware.upgrades().entrySet()) {
                tooltip.add(UpgradeDisplay.of((Upgrade)((Upgrade)entry.getKey()), (int)((Integer)entry.getValue())).getTextComponent());
            }
        }
    }

    protected void addTypeDetails(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.exposesEnergyCapOrTooltips()) {
            StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)false);
        }
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        if (this.exposesEnergyCapOrTooltips()) {
            return slotChanged || oldStack.getItem() != newStack.getItem();
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean shouldCauseBlockBreakReset(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        if (this.exposesEnergyCapOrTooltips()) {
            return oldStack.getItem() != newStack.getItem();
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    protected Predicate<@NotNull AutomationType> getEnergyCapInsertPredicate() {
        return ConstantPredicates.alwaysTrue();
    }

    protected boolean exposesEnergyCap() {
        return this.exposesEnergyCapOrTooltips();
    }

    protected boolean exposesEnergyCapOrTooltips() {
        return Attribute.has(this.getBlock(), AttributeEnergy.class);
    }

    protected EnergyContainersBuilder addDefaultEnergyContainers(EnergyContainersBuilder builder) {
        Object block = this.getBlock();
        AttributeEnergy attributeEnergy = (AttributeEnergy)Attribute.get(block, AttributeEnergy.class);
        if (attributeEnergy == null) {
            throw new IllegalStateException("Expected block " + String.valueOf(block) + " to have the energy attribute");
        }
        LongSupplier maxEnergy = () -> ((AttributeEnergy)attributeEnergy).getStorage();
        if (Attribute.matches(block, AttributeUpgradeSupport.class, attribute -> attribute.supportedUpgrades().contains(Upgrade.ENERGY))) {
            return builder.addContainer((type, attachedTo, containerIndex) -> {
                UpgradeBasedLongCache capacity = new UpgradeBasedLongCache(attachedTo, maxEnergy);
                return new ComponentBackedNoClampEnergyContainer(attachedTo, containerIndex, BasicEnergyContainer.manualOnly, this.getEnergyCapInsertPredicate(), () -> MekanismUtils.calculateUsage((long)capacity.getAsLong()), (LongSupplier)capacity);
            });
        }
        return builder.addBasic(BasicEnergyContainer.manualOnly, this.getEnergyCapInsertPredicate(), () -> MekanismUtils.calculateUsage((long)maxEnergy.getAsLong()), maxEnergy);
    }

    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        if (Attribute.has(this.getBlock(), Attributes.AttributeSecurity.class)) {
            event.registerItem(IItemSecurityUtils.INSTANCE.ownerCapability(), (stack, ctx) -> new SecurityObject(stack), new ItemLike[]{this});
            event.registerItem(IItemSecurityUtils.INSTANCE.securityCapability(), (stack, ctx) -> new SecurityObject(stack), new ItemLike[]{this});
        }
    }

    public void attachAttachments(IEventBus eventBus) {
        if (Attribute.has(this.getBlock(), AttributeEnergy.class)) {
            IEventBus energyEventBus = this.exposesEnergyCap() ? eventBus : null;
            ContainerType.ENERGY.addDefaultCreators(energyEventBus, (Item)this, () -> this.addDefaultEnergyContainers(EnergyContainersBuilder.builder()).build(), new IMekanismConfig[]{MekanismConfig.storage, MekanismConfig.usage});
        }
    }

    private static class UpgradeBasedLongCache
    implements LongSupplier {
        private final LongSupplier baseStorage;
        private final ItemStack stack;
        private int lastInstalled;
        private long value;

        private UpgradeBasedLongCache(ItemStack stack, LongSupplier baseStorage) {
            this.stack = stack;
            UpgradeAware upgradeAware = (UpgradeAware)this.stack.getOrDefault((Supplier)MekanismDataComponents.UPGRADES, (Object)UpgradeAware.EMPTY);
            this.lastInstalled = upgradeAware.getUpgradeCount(Upgrade.ENERGY);
            this.baseStorage = baseStorage;
            this.value = MekanismUtils.getMaxEnergy((int)this.lastInstalled, (long)this.baseStorage.getAsLong());
        }

        @Override
        public long getAsLong() {
            UpgradeAware upgradeAware = (UpgradeAware)this.stack.getOrDefault((Supplier)MekanismDataComponents.UPGRADES, (Object)UpgradeAware.EMPTY);
            int installed = upgradeAware.getUpgradeCount(Upgrade.ENERGY);
            if (installed != this.lastInstalled) {
                this.lastInstalled = installed;
                this.value = MekanismUtils.getMaxEnergy((int)this.lastInstalled, (long)this.baseStorage.getAsLong());
            }
            return this.value;
        }
    }
}

