/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block;

import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.item.block.ItemBlockExtraTooltip;
import com.jerry.mekextras.common.tier.CTTier;
import com.jerry.mekextras.common.tile.TileEntityExtraChemicalTank;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockExtraChemicalTank
extends ItemBlockExtraTooltip<BlockTile.BlockTileModel<TileEntityExtraChemicalTank, Machine<TileEntityExtraChemicalTank>>> {
    private static final AttachedSideConfig SIDE_CONFIG = (AttachedSideConfig)Util.make(() -> {
        EnumMap<TransmissionType, AttachedSideConfig.LightConfigInfo> configInfo = new EnumMap<TransmissionType, AttachedSideConfig.LightConfigInfo>(TransmissionType.class);
        configInfo.put(TransmissionType.ITEM, AttachedSideConfig.LightConfigInfo.FRONT_OUT_NO_EJECT);
        configInfo.put(TransmissionType.CHEMICAL, AttachedSideConfig.LightConfigInfo.FRONT_OUT_EJECT);
        return new AttachedSideConfig(configInfo);
    });

    public ItemBlockExtraChemicalTank(BlockTile.BlockTileModel<TileEntityExtraChemicalTank, Machine<TileEntityExtraChemicalTank>> block, Item.Properties properties) {
        super(block, true, properties.component((Supplier)MekanismDataComponents.DUMP_MODE, (Object)TileEntityChemicalTank.GasMode.IDLE).component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)SIDE_CONFIG));
    }

    @Override
    public CTTier getAdvancedTier() {
        return ExtraAttribute.getAdvancedTier(this.getBlock(), CTTier.class);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        CTTier tier = this.getAdvancedTier();
        StorageUtils.addStoredSubstance((ItemStack)stack, tooltip, (boolean)false);
        tooltip.add((Component)MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)tier.getStorage())}));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        if (stack.getCount() > 1) {
            return false;
        }
        return ChemicalUtil.hasAnyChemical((ItemStack)stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getBarWidth((ItemStack)stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay((ItemStack)stack);
    }
}

