/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item.block;

import com.jerry.mekextras.common.attachments.containers.item.ExtraComponentBackedBinInventorySlot;
import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.block.basic.BlockExtraBin;
import com.jerry.mekextras.common.inventory.slot.ExtraBinInventorySlot;
import com.jerry.mekextras.common.item.block.ItemBlockExtraTooltip;
import com.jerry.mekextras.common.tier.BTier;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.LockData;
import mekanism.common.item.interfaces.IDroppableContents;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockExtraBin
extends ItemBlockExtraTooltip<BlockExtraBin>
implements IDroppableContents.IDroppableAttachmentContents {
    public ItemBlockExtraBin(BlockExtraBin block, Item.Properties properties) {
        super(block, properties.component((Supplier)MekanismDataComponents.LOCK, (Object)LockData.EMPTY));
    }

    @Override
    public BTier getAdvancedTier() {
        return ExtraAttribute.getAdvancedTier(this.getBlock(), BTier.class);
    }

    @Override
    protected void addStats(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        ExtraComponentBackedBinInventorySlot slot = ExtraBinInventorySlot.getForStack(stack);
        BTier tier = this.getAdvancedTier();
        if (slot != null && tier != null) {
            if (slot.isEmpty()) {
                tooltip.add((Component)MekanismLang.EMPTY.translateColored(EnumColor.DARK_RED));
            } else {
                tooltip.add((Component)MekanismLang.STORING.translateColored(EnumColor.BRIGHT_GREEN, new Object[]{EnumColor.GRAY, slot.getStack()}));
                tooltip.add((Component)MekanismLang.ITEM_AMOUNT.translateColored(EnumColor.PURPLE, new Object[]{EnumColor.GRAY, TextUtils.format((long)slot.getCount())}));
            }
            ItemStack lockStack = slot.getLockStack();
            if (!lockStack.isEmpty()) {
                tooltip.add((Component)MekanismLang.LOCKED.translateColored(EnumColor.AQUA, new Object[]{EnumColor.GRAY, slot.getLockStack()}));
            }
            tooltip.add((Component)MekanismLang.CAPACITY_ITEMS.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, TextUtils.format((long)tier.getStorage())}));
        }
    }

    public boolean canContentsDrop(ItemStack stack) {
        return true;
    }
}

