/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.item;

import com.jerry.mekextras.MekanismExtras;
import com.jerry.mekextras.api.tier.AdvancedTier;
import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeUpgradeable;
import java.util.Optional;
import mekanism.api.MekanismAPITags;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.UseTierInstallerTrigger;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITierUpgradable;
import mekanism.common.tile.interfaces.ITileDirectional;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemExtraTierInstaller
extends Item {
    @Nullable
    private final AdvancedTier fromTier;
    @NotNull
    private final AdvancedTier toTier;

    public ItemExtraTierInstaller(@Nullable AdvancedTier fromTier, @NotNull AdvancedTier toTier, Item.Properties properties) {
        super(properties);
        this.fromTier = fromTier;
        this.toTier = toTier;
    }

    @Nullable
    public AdvancedTier getFromTier() {
        return this.fromTier;
    }

    @NotNull
    public AdvancedTier getToTier() {
        return this.toTier;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return TextComponentUtil.build((Object[])new Object[]{this.toTier.getColor(), super.getName(stack)});
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        AdvancedTier advancedTier;
        BlockPos mainPos2;
        Player player = context.getPlayer();
        Level world = context.getLevel();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        if (state.is((Holder)MekanismBlocks.BOUNDING_BLOCK) && (mainPos2 = BlockBounding.getMainBlockPos((BlockGetter)world, (BlockPos)pos)) != null) {
            pos = mainPos2;
            state = world.getBlockState(mainPos2);
        }
        if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos) || state.is(MekanismAPITags.Blocks.BLACKLIST_INSTALLER_UPGRADEABLE)) {
            return InteractionResult.FAIL;
        }
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        Holder block = state.getBlockHolder();
        ExtraAttributeUpgradeable upgradeableBlock = (ExtraAttributeUpgradeable)Attribute.get((Holder)block, ExtraAttributeUpgradeable.class);
        if (upgradeableBlock != null && (advancedTier = ExtraAttribute.getAdvancedTier((Holder<Block>)block)) == this.fromTier && advancedTier != this.toTier) {
            BlockState upgradeState = upgradeableBlock.upgradeResult(state, this.toTier);
            if (state == upgradeState) {
                return InteractionResult.PASS;
            }
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)pos);
            if (tile instanceof ITierUpgradable) {
                IUpgradeData upgradeData;
                ITierUpgradable tierUpgradable = (ITierUpgradable)tile;
                if (tile instanceof TileEntityMekanism) {
                    TileEntityMekanism tileMek = (TileEntityMekanism)tile;
                    if (!tileMek.playersUsing.isEmpty()) {
                        return InteractionResult.FAIL;
                    }
                }
                if ((upgradeData = tierUpgradable.getUpgradeData((HolderLookup.Provider)world.registryAccess())) == null) {
                    if (tierUpgradable.canBeUpgraded()) {
                        MekanismExtras.LOGGER.warn("Got no upgrade data for block {} at position: {} in {} but it said it would be able to provide some.", new Object[]{block, pos, world.dimension().location()});
                        return InteractionResult.FAIL;
                    }
                } else {
                    ITileDirectional directional;
                    TileEntityMekanism upgradedTile;
                    AttributeHasBounding upgradeBounding = (AttributeHasBounding)Attribute.get((BlockState)upgradeState, AttributeHasBounding.class);
                    if (upgradeBounding != null && !upgradeBounding.handle(world, pos, upgradeState, (Object)pos, (level, boundingPos, mainPos) -> {
                        Optional blockState = WorldUtils.getBlockState((BlockGetter)level, (BlockPos)boundingPos);
                        if (blockState.isPresent()) {
                            BlockState boundingCurrentState = (BlockState)blockState.get();
                            if (boundingCurrentState.canBeReplaced()) {
                                return true;
                            }
                            if (boundingCurrentState.is((Holder)MekanismBlocks.BOUNDING_BLOCK)) {
                                return mainPos.equals((Object)BlockBounding.getMainBlockPos((BlockGetter)level, (BlockPos)boundingPos));
                            }
                        }
                        return false;
                    })) {
                        return InteractionResult.FAIL;
                    }
                    if (!world.setBlockAndUpdate(pos, upgradeState)) {
                        MekanismExtras.LOGGER.warn("Error upgrading block at position: {} in {}.", (Object)pos, (Object)world.dimension().location());
                        return InteractionResult.FAIL;
                    }
                    if (upgradeBounding != null) {
                        upgradeBounding.placeBoundingBlocks(world, pos, upgradeState);
                    }
                    if ((upgradedTile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, (BlockPos)pos)) == null) {
                        MekanismExtras.LOGGER.warn("Error upgrading block at position: {} in {}. Expected a mekanism block as the result.", (Object)pos, (Object)world.dimension().location());
                        return InteractionResult.FAIL;
                    }
                    if (tile instanceof ITileDirectional && (directional = (ITileDirectional)tile).isDirectional()) {
                        upgradedTile.setFacing(directional.getDirection(), false);
                    }
                    upgradedTile.parseUpgradeData((HolderLookup.Provider)world.registryAccess(), upgradeData);
                    upgradedTile.resyncMasterToBounding();
                    upgradedTile.sendUpdatePacket();
                    upgradedTile.setChanged();
                    upgradedTile.invalidateCapabilitiesFull();
                    if (!player.isCreative()) {
                        context.getItemInHand().shrink(1);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ((UseTierInstallerTrigger)MekanismCriteriaTriggers.USE_TIER_INSTALLER.value()).trigger(serverPlayer, null);
                    }
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

