/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekmm.tile.factory;

import com.jerry.mekextras.api.recipes.cache.StackableItemStackConstantChemicalToObjectCachedRecipe;
import com.jerry.mekextras.api.recipes.cache.StackablePlantingCachedRecipe;
import com.jerry.mekextras.common.integration.mekmm.inventory.slot.ExtraMoreMachineFactoryInputInventorySlot;
import com.jerry.mekextras.common.integration.mekmm.inventory.slot.ExtraMoreMachineFactoryOutputInventorySlot;
import com.jerry.mekextras.common.integration.mekmm.tile.factory.TileEntityExtraMoreMachineFactory;
import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.api.recipes.cache.PlantingNoPerTickUsageCacheRecipe;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.tile.machine.TileEntityPlantingStation;
import com.jerry.mekmm.common.upgrade.PlantingUpgradeData;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraPlantingFactory
extends TileEntityExtraMoreMachineFactory<PlantingRecipe>
implements IBoundingBlock,
IHasDumpButton,
IRecipeLookupHandler.ConstantUsageRecipeLookupHandler,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<PlantingRecipe> {
    protected static final DoubleInputRecipeCache.CheckRecipeType<ItemStack, ChemicalStack, PlantingRecipe, PackedStack> OUTPUT_CHECK = (recipe, itemStack, chemicalStack, output) -> {
        SawmillRecipe.ChanceOutput chanceOutput = recipe.getOutput(itemStack, chemicalStack);
        ItemStack firstStack = output.firstStack;
        ItemStack secondaryStack = output.secondaryStack;
        if (InventoryUtils.areItemsStackable((ItemStack)chanceOutput.getMainOutput(), (ItemStack)firstStack)) {
            if (secondaryStack.isEmpty()) {
                return true;
            }
            ItemStack secondaryOutput = chanceOutput.getMaxSecondaryOutput();
            return secondaryOutput.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)secondaryOutput, (ItemStack)secondaryStack);
        }
        return false;
    };
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, TileEntityPlantingStation.NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private IInputHandler<@NotNull ItemStack>[] inputHandlers;
    private final ILongInputHandler<@NotNull ChemicalStack> chemicalInputHandler;
    private IOutputHandler<SawmillRecipe.ChanceOutput>[] outputHandlers;
    ChemicalInventorySlot chemicalSlot;
    IChemicalTank chemicalTank;
    private final StackableItemStackConstantChemicalToObjectCachedRecipe.StackableChemicalUsageMultiplier chemicalUsageMultiplier;
    private double chemicalPerTickMeanMultiplier = 1.0;
    private long baseTotalUsage;
    private final long[] usedSoFar;

    public TileEntityExtraPlantingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.configComponent.setupInputConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank);
        this.configComponent.addDisabledSides(new RelativeSide[]{RelativeSide.TOP});
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.chemicalTank);
        this.baseTotalUsage = 200L;
        this.usedSoFar = new long[this.tier.processes];
        this.chemicalUsageMultiplier = this.useStatisticalMechanics() ? (usedSoFar, operatingTicks, operationsSoFar) -> StatUtils.inversePoisson((double)this.chemicalPerTickMeanMultiplier) : StackableItemStackConstantChemicalToObjectCachedRecipe.StackableChemicalUsageMultiplier.constantUse(() -> this.baseTotalUsage, this::getChemicalTicksRequired);
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = BasicChemicalTank.inputModern((long)(210L * (long)this.tier.processes * (long)this.tier.processes), arg_0 -> ((TileEntityExtraPlantingFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputHandlers = new IInputHandler[this.tier.processes];
        this.outputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new TileEntityExtraMoreMachineFactory.ProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            FactoryRecipeCacheLookupMonitor lookupMonitor = this.recipeCacheLookupMonitors[i];
            IContentsListener updateSortingAndUnpause = () -> {
                updateSortingListener.onContentsChanged();
                lookupMonitor.unpause();
            };
            ExtraMoreMachineFactoryOutputInventorySlot outputSlot = ExtraMoreMachineFactoryOutputInventorySlot.at(this, updateSortingAndUnpause, this.getXPos(i), 57);
            ExtraMoreMachineFactoryOutputInventorySlot secondaryOutputSlot = ExtraMoreMachineFactoryOutputInventorySlot.at(this, updateSortingAndUnpause, this.getXPos(i), 77);
            ExtraMoreMachineFactoryInputInventorySlot inputSlot = ExtraMoreMachineFactoryInputInventorySlot.create(this, i, (IInventorySlot)outputSlot, (IInventorySlot)secondaryOutputSlot, (IContentsListener)lookupMonitor, this.getXPos(i), 13);
            int index = i;
            ((ExtraMoreMachineFactoryInputInventorySlot)builder.addSlot((IInventorySlot)inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, index)));
            ((ExtraMoreMachineFactoryOutputInventorySlot)builder.addSlot((IInventorySlot)outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, index)));
            ((ExtraMoreMachineFactoryOutputInventorySlot)builder.addSlot((IInventorySlot)secondaryOutputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(TileEntityPlantingStation.NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR, index)));
            this.inputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
            this.outputHandlers[i] = OutputHelper.getOutputHandler((IInventorySlot)outputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, (IInventorySlot)secondaryOutputSlot, (CachedRecipe.OperationTracker.RecipeError)TileEntityPlantingStation.NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR);
            this.processInfoSlots[i] = new TileEntityExtraMoreMachineFactory.ProcessInfo(i, inputSlot, (IInventorySlot)outputSlot, (IInventorySlot)secondaryOutputSlot);
        }
        this.chemicalSlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.chemicalTank, () -> ((TileEntityExtraPlantingFactory)this).getLevel(), (IContentsListener)listener, (int)7, (int)77);
        builder.addSlot((IInventorySlot)this.chemicalSlot);
    }

    protected boolean useStatisticalMechanics() {
        return MekanismConfig.usage.randomizedConsumption.get();
    }

    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    @Nullable
    public ChemicalInventorySlot getExtraSlot() {
        return this.chemicalSlot;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, PlantingRecipe, InputRecipeCache.ItemChemical<PlantingRecipe>> getRecipeType() {
        return MoreMachineRecipeType.PLANTING_STATION;
    }

    @Nullable
    public IRecipeViewerRecipeType<PlantingRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.PLANTING_STATION;
    }

    @Nullable
    public PlantingRecipe getRecipe(int cacheIndex) {
        return (PlantingRecipe)this.findFirstRecipe((IInputHandler)this.inputHandlers[cacheIndex], (IInputHandler)this.chemicalInputHandler);
    }

    @NotNull
    public CachedRecipe<PlantingRecipe> createNewCachedRecipe(@NotNull PlantingRecipe recipe, int cacheIndex) {
        Object cachedRecipe = recipe.perTickUsage() ? StackablePlantingCachedRecipe.planting(recipe, this.recheckAllRecipeErrors[cacheIndex], this.inputHandlers[cacheIndex], this.chemicalInputHandler, this.chemicalUsageMultiplier, used -> {
            this.usedSoFar[cacheIndex] = used;
        }, this.outputHandlers[cacheIndex]) : PlantingNoPerTickUsageCacheRecipe.planting((PlantingRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], this.inputHandlers[cacheIndex], this.chemicalInputHandler, this.outputHandlers[cacheIndex]);
        return cachedRecipe.setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityExtraPlantingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityExtraPlantingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<PlantingRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            PlantingRecipe cachedRecipe = (PlantingRecipe)cached.getRecipe();
            return cachedRecipe.getItemInput().testType(stack) && (this.chemicalTank.isEmpty() || cachedRecipe.getChemicalInput().testType(this.chemicalTank.getTypeHolder()));
        }
        return false;
    }

    @Override
    @Nullable
    protected PlantingRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        ItemStack extra = secondaryOutputSlot == null ? ItemStack.EMPTY : secondaryOutputSlot.getStack();
        return (PlantingRecipe)((InputRecipeCache.ItemChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)this.chemicalTank.getStack(), (Object)new PackedStack(outputSlot.getStack(), extra), OUTPUT_CHECK);
    }

    @Override
    protected void handleSecondaryFuel() {
        this.chemicalSlot.fillTankOrConvert();
    }

    @Override
    protected int getNeededInput(PlantingRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount(inputStack));
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeAB(stack, this.chemicalTank.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("used_so_far", 12)) {
            long[] savedUsed = nbt.getLongArray("used_so_far");
            if (this.tier.processes != savedUsed.length) {
                Arrays.fill(this.usedSoFar, 0L);
            }
            for (int i = 0; i < this.tier.processes && i < savedUsed.length; ++i) {
                this.usedSoFar[i] = savedUsed[i];
            }
        } else {
            Arrays.fill(this.usedSoFar, 0L);
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putLongArray("used_so_far", Arrays.copyOf(this.usedSoFar, this.usedSoFar.length));
    }

    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar[cacheIndex];
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.CHEMICAL) {
            if (this.useStatisticalMechanics()) {
                this.chemicalPerTickMeanMultiplier = MekanismUtils.getGasPerTickMeanMultiplier((IUpgradeTile)this);
            } else {
                this.baseTotalUsage = MekanismUtils.getBaseUsage((IUpgradeTile)this, (int)200);
            }
        }
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof PlantingUpgradeData) {
            PlantingUpgradeData data = (PlantingUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.chemicalTank.deserializeNBT(provider, data.stored.serializeNBT(provider));
            this.chemicalSlot.deserializeNBT(provider, data.chemicalSlot.serializeNBT(provider));
            System.arraycopy(data.usedSoFar, 0, this.usedSoFar, 0, data.usedSoFar.length);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public PlantingUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new PlantingUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.usedSoFar, this.chemicalTank, this.energySlot, this.chemicalSlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.chemicalTank.setEmpty();
    }

    protected record PackedStack(ItemStack firstStack, ItemStack secondaryStack) {
    }
}

