/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekmm.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekextras.api.tier.IAdvancedTier;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekextras.common.integration.mekmm.block.prefab.ExtraMoreMachineBlockFactoryMachine;
import com.jerry.mekextras.common.integration.mekmm.content.blocktype.ExtraMoreMachineFactory;
import com.jerry.mekextras.common.integration.mekmm.item.block.machine.ItemBlockExtraMoreMachineFactory;
import com.jerry.mekextras.common.integration.mekmm.registries.ExtraMoreMachineBlockTypes;
import com.jerry.mekextras.common.integration.mekmm.tile.factory.TileEntityExtraMoreMachineFactory;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactoryType;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.tile.factory.TileEntityReplicatingFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityReplicator;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.ChemicalTanksBuilder;
import mekanism.common.attachments.containers.item.ItemSlotsBuilder;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ExtraMoreMachineBlocks {
    public static final BlockDeferredRegister MM_BLOCKS = new BlockDeferredRegister("mekanism_extras");
    private static final Table<ExtraFactoryTier, MoreMachineFactoryType, BlockRegistryObject<ExtraMoreMachineBlockFactoryMachine.BlockExtraMoreMachineFactory<?>, ItemBlockExtraMoreMachineFactory>> MM_FACTORIES = HashBasedTable.create();

    private ExtraMoreMachineBlocks() {
    }

    private static <TILE extends TileEntityExtraMoreMachineFactory<?>> BlockRegistryObject<ExtraMoreMachineBlockFactoryMachine.BlockExtraMoreMachineFactory<?>, ItemBlockExtraMoreMachineFactory> registerMoreMachineFactory(ExtraMoreMachineFactory<TILE> type) {
        ExtraFactoryTier tier = (ExtraFactoryTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        BlockRegistryObject<ExtraMoreMachineBlockFactoryMachine.BlockExtraMoreMachineFactory, ItemBlockExtraMoreMachineFactory> factory = ExtraMoreMachineBlocks.registerTieredBlock(tier, "_" + type.getMoreMachineFactoryType().getRegistryNameComponent() + "_factory", () -> new ExtraMoreMachineBlockFactoryMachine.BlockExtraMoreMachineFactory(type), ItemBlockExtraMoreMachineFactory::new);
        factory.forItemHolder(holder -> {
            int processes = tier.processes;
            Predicate<ItemStack> recipeInputPredicate = switch (type.getMoreMachineFactoryType()) {
                default -> throw new MatchException(null, null);
                case MoreMachineFactoryType.RECYCLING -> s -> ((InputRecipeCache.SingleItem)MoreMachineRecipeType.RECYCLING.getInputCache()).containsInput(null, s);
                case MoreMachineFactoryType.PLANTING_STATION -> s -> ((InputRecipeCache.ItemChemical)MoreMachineRecipeType.PLANTING_STATION.getInputCache()).containsInputA(null, s);
                case MoreMachineFactoryType.CNC_STAMPING -> s -> ((InputRecipeCache.DoubleItem)MoreMachineRecipeType.STAMPING.getInputCache()).containsInputA(null, s);
                case MoreMachineFactoryType.CNC_LATHING -> s -> ((InputRecipeCache.SingleItem)MoreMachineRecipeType.LATHING.getInputCache()).containsInput(null, s);
                case MoreMachineFactoryType.CNC_ROLLING_MILL -> s -> ((InputRecipeCache.SingleItem)MoreMachineRecipeType.ROLLING_MILL.getInputCache()).containsInput(null, s);
                case MoreMachineFactoryType.REPLICATING -> TileEntityReplicator::isValidItemInput;
            };
            switch (type.getMoreMachineFactoryType()) {
                case CNC_STAMPING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInput((IMekanismRecipeTypeProvider)MekanismRecipeType.COMBINING, DoubleInputRecipeCache::containsInputB).addEnergy().build());
                    break;
                }
                case RECYCLING: 
                case CNC_LATHING: 
                case CNC_ROLLING_MILL: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addEnergy().build());
                    break;
                }
                case PLANTING_STATION: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> {
                        switch (type.getMoreMachineFactoryType()) {
                            case PLANTING_STATION: {
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Factory type doesn't have a known gas recipe.");
                            }
                        }
                        return ChemicalTanksBuilder.builder().addBasic(210L * (long)processes * (long)processes, (IMekanismRecipeTypeProvider)MoreMachineRecipeType.PLANTING_STATION, DoubleInputRecipeCache::containsInputB).build();
                    }).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate, true).addChemicalFillOrConvertSlot(1).addEnergy().build());
                    break;
                }
                case REPLICATING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L * (long)processes * (long)processes, TileEntityReplicatingFactory::isValidChemicalInput).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addChemicalFillOrConvertSlot(0).addEnergy().build());
                }
            }
        });
        return factory;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(IAdvancedTier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return MM_BLOCKS.register(tier.getAdvanceTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    public static BlockRegistryObject<ExtraMoreMachineBlockFactoryMachine.BlockExtraMoreMachineFactory<?>, ItemBlockExtraMoreMachineFactory> getMoreMachineFactory(@NotNull ExtraFactoryTier tier, @NotNull MoreMachineFactoryType type) {
        return (BlockRegistryObject)MM_FACTORIES.get((Object)tier, (Object)type);
    }

    static {
        for (ExtraFactoryTier tier : ExtraEnumUtils.EXTRA_FACTORY_TIERS) {
            for (MoreMachineFactoryType type : MoreMachineEnumUtils.MM_FACTORY_TYPES) {
                MM_FACTORIES.put((Object)tier, (Object)type, ExtraMoreMachineBlocks.registerMoreMachineFactory(ExtraMoreMachineBlockTypes.getMoreMachineFactory(tier, type)));
            }
        }
    }
}

