/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekmm.content.blocktype;

import com.jerry.mekextras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeUpgradeable;
import com.jerry.mekextras.common.content.blocktype.ExtraMachine;
import com.jerry.mekextras.common.integration.mekmm.registries.ExtraMoreMachineBlockTypes;
import com.jerry.mekextras.common.integration.mekmm.registries.ExtraMoreMachineBlocks;
import com.jerry.mekextras.common.integration.mekmm.registries.ExtraMoreMachineContainerTypes;
import com.jerry.mekextras.common.integration.mekmm.tile.factory.TileEntityExtraMoreMachineFactory;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import com.jerry.mekmm.common.block.attribute.MoreMachineAttributeFactoryType;
import com.jerry.mekmm.common.content.blocktype.MoreMachineBlockShapes;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactoryType;
import java.util.function.Supplier;
import mekanism.api.math.MathUtils;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import org.jetbrains.annotations.NotNull;

public class ExtraMoreMachineFactory<TILE extends TileEntityExtraMoreMachineFactory<?>>
extends ExtraMachine.ExtraFactoryMachine<TILE> {
    private final ExtraMachine.ExtraFactoryMachine<?> origMachine;

    public ExtraMoreMachineFactory(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar, ExtraMachine.ExtraFactoryMachine<?> origMachine, ExtraFactoryTier tier) {
        super(tileEntityRegistrar, (ILangEntry)MekanismLang.DESCRIPTION_FACTORY, origMachine.getMoreMachineFactoryType());
        this.origMachine = origMachine;
        this.setMachineData(tier);
        this.add(new Attribute[]{new AttributeGui(containerRegistrar, null), new ExtraAttributeTier<ExtraFactoryTier>(tier)});
        if (tier.ordinal() < ExtraEnumUtils.EXTRA_FACTORY_TIERS.length - 1) {
            this.add(new Attribute[]{new ExtraAttributeUpgradeable(() -> ExtraMoreMachineBlocks.getMoreMachineFactory(ExtraEnumUtils.EXTRA_FACTORY_TIERS[tier.ordinal() + 1], origMachine.getMoreMachineFactoryType()))});
        }
    }

    private void setMachineData(ExtraFactoryTier tier) {
        this.setFrom((BlockTypeTile)this.origMachine, new Class[]{AttributeSound.class, MoreMachineAttributeFactoryType.class, AttributeUpgradeSupport.class});
        AttributeEnergy origEnergy = (AttributeEnergy)this.origMachine.get(AttributeEnergy.class);
        if (origEnergy != null) {
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = new AttributeEnergy(() -> ((AttributeEnergy)origEnergy).getUsage(), () -> MathUtils.clampToLong((double)(Math.max(origEnergy.getConfigStorage(), origEnergy.getUsage()) * (long)tier.processes)));
            this.add(attributeArray);
        }
    }

    public static class ExtraMoreMachineFactoryBuilder<FACTORY extends ExtraMoreMachineFactory<TILE>, TILE extends TileEntityExtraMoreMachineFactory<?>, T extends ExtraMachine.ExtraMachineBuilder<FACTORY, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<FACTORY, TILE, T> {
        protected ExtraMoreMachineFactoryBuilder(FACTORY holder) {
            super(holder);
        }

        public static <TILE extends TileEntityExtraMoreMachineFactory<?>> ExtraMoreMachineFactoryBuilder<ExtraMoreMachineFactory<TILE>, TILE, ?> createMoreMachineFactory(Supplier<?> tileEntityRegistrar, MoreMachineFactoryType type, ExtraFactoryTier tier) {
            ExtraMoreMachineFactoryBuilder<ExtraMoreMachineFactory<TILE>, TILE, ?> builder = ExtraMoreMachineFactoryBuilder.getExtraMoreMachineFactoryTILEMoreMachineFactoryBuilder(tileEntityRegistrar, type, tier);
            builder.withCustomShape(MoreMachineBlockShapes.getShape((MoreMachineFactoryType)type));
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = switch (type) {
                default -> throw new MatchException(null, null);
                case MoreMachineFactoryType.RECYCLING, MoreMachineFactoryType.CNC_STAMPING, MoreMachineFactoryType.CNC_LATHING, MoreMachineFactoryType.CNC_ROLLING_MILL -> AttributeSideConfig.ELECTRIC_MACHINE;
                case MoreMachineFactoryType.PLANTING_STATION, MoreMachineFactoryType.REPLICATING -> AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE;
            };
            builder.with(attributeArray);
            if (type.getBaseMachine().has(AttributeHasBounding.class)) {
                builder.with(new Attribute[]{AttributeHasBounding.ABOVE_ONLY});
            }
            builder.replace(new Attribute[]{new AttributeParticleFX().addDense((ParticleOptions)ParticleTypes.SMOKE, 5, rand -> new Pos3D((double)(rand.nextFloat() * 0.7f - 0.3f), (double)(rand.nextFloat() * 0.1f + 0.7f), (double)(rand.nextFloat() * 0.7f - 0.3f)))});
            return builder;
        }

        @NotNull
        private static <TILE extends TileEntityExtraMoreMachineFactory<?>> ExtraMoreMachineFactoryBuilder<ExtraMoreMachineFactory<TILE>, TILE, ?> getExtraMoreMachineFactoryTILEMoreMachineFactoryBuilder(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, MoreMachineFactoryType type, ExtraFactoryTier tier) {
            Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> supplier = () -> ExtraMoreMachineContainerTypes.MORE_MACHINE_FACTORY;
            ExtraMoreMachineFactoryBuilder builder = new ExtraMoreMachineFactoryBuilder(new ExtraMoreMachineFactory<TILE>(tileEntityRegistrar, supplier, switch (type) {
                default -> throw new MatchException(null, null);
                case MoreMachineFactoryType.RECYCLING -> ExtraMoreMachineBlockTypes.RECYCLER;
                case MoreMachineFactoryType.PLANTING_STATION -> ExtraMoreMachineBlockTypes.PLANTING_STATION;
                case MoreMachineFactoryType.CNC_STAMPING -> ExtraMoreMachineBlockTypes.CNC_STAMPER;
                case MoreMachineFactoryType.CNC_LATHING -> ExtraMoreMachineBlockTypes.CNC_LATHE;
                case MoreMachineFactoryType.CNC_ROLLING_MILL -> ExtraMoreMachineBlockTypes.CNC_ROLLING_MILL;
                case MoreMachineFactoryType.REPLICATING -> ExtraMoreMachineBlockTypes.REPLICATOR;
            }, tier));
            builder.withComputerSupport(tier.getAdvanceTier().getLowerName() + type.getRegistryNameComponentCapitalized() + "Factory");
            return builder;
        }
    }
}

