/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekaf.tile.factory;

import com.jerry.mekaf.common.upgrade.FluidChemicalToChemicalUpgradeData;
import com.jerry.mekextras.common.integration.mekaf.capabilities.energy.ExtraAdvancedFactoryEnergyContainer;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraChemicalToChemicalFactory;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraWashingFactory
extends TileEntityExtraChemicalToChemicalFactory<FluidChemicalToChemicalRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.FluidChemicalRecipeLookupHandler<FluidChemicalToChemicalRecipe> {
    protected static final DoubleInputRecipeCache.CheckRecipeType<FluidStack, ChemicalStack, FluidChemicalToChemicalRecipe, ChemicalStack> OUTPUT_CHECK = (recipe, fluidInput, chemicalInput, output) -> ChemicalStack.isSameChemical((ChemicalStack)recipe.getOutput(fluidInput, chemicalInput), (ChemicalStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    public BasicFluidTank fluidTank;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    FluidInventorySlot fluidSlot;
    OutputInventorySlot fluidOutputSlot;

    public TileEntityExtraWashingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo config;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new InventorySlotInfo(true, false, new IInventorySlot[]{this.fluidSlot}));
            itemConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new InventorySlotInfo(false, true, new IInventorySlot[]{this.fluidOutputSlot}));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.fluidSlot, this.fluidOutputSlot}));
        }
        if ((config = this.configComponent.getConfig(TransmissionType.CHEMICAL)) != null) {
            config.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo(true, false, this.inputChemicalTanks));
            List ioTank = this.outputChemicalTanks;
            ioTank.addAll(this.inputChemicalTanks);
            config.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo(true, true, ioTank));
        }
        this.configComponent.setupInputConfig(TransmissionType.FLUID, (Object)this.fluidTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> !this.inputChemicalTanks.contains(tank));
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.fluidTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.fluidTank = BasicFluidTank.input((int)(10000 * this.tier.processes), arg_0 -> ((TileEntityExtraWashingFactory)this).containsRecipeA(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank((IExtendedFluidTank)this.fluidTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.fluidSlot = FluidInventorySlot.fill((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)(214 + 38 * (this.tier.ordinal() + 1)), (int)71);
        builder.addSlot((IInventorySlot)this.fluidSlot);
        this.fluidOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)(214 + 38 * (this.tier.ordinal() + 1)), (int)102);
        builder.addSlot((IInventorySlot)this.fluidOutputSlot);
        this.fluidSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    public BasicFluidTank getFluidTankBar() {
        return this.fluidTank;
    }

    @Override
    public boolean hasExtraResourceBar() {
        return true;
    }

    @Override
    protected void handleSecondaryFuel() {
        this.fluidSlot.fillTank((IInventorySlot)this.fluidOutputSlot);
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<FluidChemicalToChemicalRecipe> cached, @NotNull ChemicalStack stack) {
        if (cached != null) {
            FluidChemicalToChemicalRecipe cachedRecipe = (FluidChemicalToChemicalRecipe)cached.getRecipe();
            return cachedRecipe.getChemicalInput().testType(stack) && (this.fluidTank.isEmpty() || cachedRecipe.getFluidInput().testType(this.fluidTank.getFluid()));
        }
        return false;
    }

    @Override
    @Nullable
    protected FluidChemicalToChemicalRecipe findRecipe(int process, @NotNull ChemicalStack fallbackInput, @NotNull IChemicalTank outputSlot) {
        return (FluidChemicalToChemicalRecipe)((InputRecipeCache.FluidChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)this.fluidTank.getFluid(), (Object)fallbackInput, (Object)outputSlot.getStack(), OUTPUT_CHECK);
    }

    @Override
    public boolean isChemicalValidForTank(@NotNull ChemicalStack stack) {
        return this.containsRecipeAB(this.fluidTank.getFluid(), stack);
    }

    @Override
    public boolean isValidInputChemical(@NotNull ChemicalStack stack) {
        return this.containsRecipeB(stack);
    }

    @Override
    protected int getNeededInput(FluidChemicalToChemicalRecipe recipe, ChemicalStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getChemicalInput().getNeededAmount(inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, FluidChemicalToChemicalRecipe, InputRecipeCache.FluidChemical<FluidChemicalToChemicalRecipe>> getRecipeType() {
        return MekanismRecipeType.WASHING;
    }

    @Nullable
    public IRecipeViewerRecipeType<FluidChemicalToChemicalRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.WASHING;
    }

    @Nullable
    public FluidChemicalToChemicalRecipe getRecipe(int cacheIndex) {
        return (FluidChemicalToChemicalRecipe)this.findFirstRecipe(this.fluidInputHandler, this.chemicalInputHandlers[cacheIndex]);
    }

    @NotNull
    public CachedRecipe<FluidChemicalToChemicalRecipe> createNewCachedRecipe(@NotNull FluidChemicalToChemicalRecipe recipe, int cacheIndex) {
        return TwoInputCachedRecipe.fluidChemicalToChemical((FluidChemicalToChemicalRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], this.fluidInputHandler, (IInputHandler)this.chemicalInputHandlers[cacheIndex], (IOutputHandler)this.chemicalOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityExtraWashingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((ExtraAdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setBaselineMaxOperations(() -> this.baselineMaxOperations).setOnFinish(() -> ((TileEntityExtraWashingFactory)this).markForSave());
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.baselineMaxOperations = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        }
    }

    @Override
    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? UpgradeUtils.getExpScaledInfo((IUpgradeTile)this, (Upgrade)upgrade) : super.getInfo(upgrade);
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof FluidChemicalToChemicalUpgradeData) {
            FluidChemicalToChemicalUpgradeData data = (FluidChemicalToChemicalUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.fluidTank.deserializeNBT(provider, data.inputTank.serializeNBT(provider));
            this.fluidSlot.deserializeNBT(provider, data.fluidInputSlot.serializeNBT(provider));
            this.fluidOutputSlot.deserializeNBT(provider, data.fluidOutputSlot.serializeNBT(provider));
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new FluidChemicalToChemicalUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, null, this.energySlot, this.fluidSlot, this.fluidOutputSlot, this.inputChemicalTanks, this.fluidTank, this.outputChemicalTanks, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.fluidTank.setStack(FluidStack.EMPTY);
    }
}

