/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekaf.tile.factory;

import com.jerry.mekaf.common.upgrade.PRCUpgradeData;
import com.jerry.mekextras.common.integration.mekaf.capabilities.energy.ExtraAdvancedFactoryEnergyContainer;
import com.jerry.mekextras.common.integration.mekaf.inventory.slot.ExtraAdvancedFactoryInputInventorySlot;
import com.jerry.mekextras.common.integration.mekaf.inventory.slot.ExtraAdvancedFactoryOutputInventorySlot;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraAdvancedBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.PressurizedReactionCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ITripleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.ItemStackMap;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraPRCFactory
extends TileEntityExtraAdvancedBase<PressurizedReactionRecipe>
implements IHasDumpButton,
ITripleRecipeLookupHandler.ItemFluidChemicalRecipeLookupHandler<PressurizedReactionRecipe> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_ITEM_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_FLUID_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_CHEMICAL_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, NOT_ENOUGH_ITEM_INPUT_ERROR, NOT_ENOUGH_FLUID_INPUT_ERROR, NOT_ENOUGH_CHEMICAL_INPUT_ERROR, NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, NOT_ENOUGH_FLUID_INPUT_ERROR, NOT_ENOUGH_CHEMICAL_INPUT_ERROR, NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR);
    private static final int BASE_DURATION = 100;
    private PRCProcessInfo[] processInfoSlots;
    public BasicFluidTank inputFluidTank;
    public IChemicalTank inputChemicalTank;
    public IChemicalTank outputChemicalTank;
    private long recipeEnergyRequired = 0L;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NotNull ChemicalStack> chemicalInputHandler;
    protected IOutputHandler<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PressurizedReactionRecipe.PressurizedReactionRecipeOutput>[] reactionOutputHandlers;
    protected final List<IInventorySlot> inputItemSlots = new ArrayList<IInventorySlot>();
    protected final List<IInventorySlot> outputItemSlots = new ArrayList<IInventorySlot>();

    public TileEntityExtraPRCFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        for (PRCProcessInfo info : this.processInfoSlots) {
            this.inputItemSlots.add((IInventorySlot)info.inputSlot());
            this.outputItemSlots.add(info.outputSlot());
        }
        this.configComponent.setupItemIOConfig(this.inputItemSlots, this.outputItemSlots, (IInventorySlot)this.energySlot, false);
        this.configComponent.setupInputConfig(TransmissionType.FLUID, (Object)this.inputFluidTank);
        ConfigInfo config = this.configComponent.getConfig(TransmissionType.CHEMICAL);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo(true, true, new IChemicalTank[]{this.inputChemicalTank}));
            config.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo(false, true, new IChemicalTank[]{this.outputChemicalTank}));
            config.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo(true, true, List.of(this.inputChemicalTank, this.outputChemicalTank)));
        }
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> tank != this.inputChemicalTank);
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.inputFluidTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_FLUID_INPUT_ERROR);
        this.chemicalInputHandler = InputHelper.getInputHandler((IChemicalTank)this.inputChemicalTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_CHEMICAL_INPUT_ERROR);
    }

    @Override
    protected void addTanks(ChemicalTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputChemicalTank = BasicChemicalTank.createModern((long)(10000L * (long)this.tier.processes * (long)this.tier.processes), (BiPredicate)ChemicalTankHelper.radioactiveInputTankPredicate(() -> this.outputChemicalTank), (BiPredicate)ConstantPredicates.alwaysTrueBi(), arg_0 -> ((TileEntityExtraPRCFactory)this).containsRecipeC(arg_0), (ChemicalAttributeValidator)ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.inputChemicalTank);
        this.outputChemicalTank = BasicChemicalTank.output((long)(10000L * (long)this.tier.processes * (long)this.tier.processes), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.outputChemicalTank);
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.inputFluidTank = BasicFluidTank.input((int)(10000 * this.tier.processes * this.tier.processes), (Predicate)ConstantPredicates.alwaysTrue(), arg_0 -> ((TileEntityExtraPRCFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank((IExtendedFluidTank)this.inputFluidTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.itemInputHandlers = new IInputHandler[this.tier.processes];
        this.reactionOutputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new PRCProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            FactoryRecipeCacheLookupMonitor lookupMonitor = this.recipeCacheLookupMonitors[i];
            IContentsListener updateSortingAndUnpause = () -> {
                updateSortingListener.onContentsChanged();
                lookupMonitor.unpause();
            };
            ExtraAdvancedFactoryOutputInventorySlot outputSlot = ExtraAdvancedFactoryOutputInventorySlot.at(this, updateSortingAndUnpause, this.getXPos(i), 57);
            ExtraAdvancedFactoryInputInventorySlot inputSlot = ExtraAdvancedFactoryInputInventorySlot.create(this, i, (IInventorySlot)outputSlot, this.outputChemicalTank, (IContentsListener)this.recipeCacheLookupMonitors[i], this.getXPos(i), 13);
            int index = i;
            ((ExtraAdvancedFactoryInputInventorySlot)builder.addSlot((IInventorySlot)inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(NOT_ENOUGH_ITEM_INPUT_ERROR, index)));
            ((ExtraAdvancedFactoryOutputInventorySlot)builder.addSlot((IInventorySlot)outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, index)));
            this.itemInputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)inputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_ITEM_INPUT_ERROR);
            this.reactionOutputHandlers[i] = OutputHelper.getOutputHandler((IInventorySlot)outputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, (IChemicalTank)this.outputChemicalTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR);
            this.processInfoSlots[i] = new PRCProcessInfo(i, inputSlot, (IInventorySlot)outputSlot);
        }
    }

    public void onCachedRecipeChanged(@Nullable CachedRecipe<PressurizedReactionRecipe> cachedRecipe, int cacheIndex) {
        int recipeDuration;
        super.onCachedRecipeChanged(cachedRecipe, cacheIndex);
        if (cachedRecipe == null) {
            recipeDuration = 100;
            this.recipeEnergyRequired = 0L;
        } else {
            PressurizedReactionRecipe recipe = (PressurizedReactionRecipe)cachedRecipe.getRecipe();
            recipeDuration = recipe.getDuration();
            this.recipeEnergyRequired = recipe.getEnergyRequired();
        }
        boolean update = this.getTicksRequired() != recipeDuration;
        this.setTicksRequired(recipeDuration);
        if (update) {
            this.recalculateUpgrades(Upgrade.SPEED);
        }
        this.energyContainer.updateEnergyPerTick();
    }

    @Override
    public long getRecipeEnergyRequired() {
        return this.recipeEnergyRequired;
    }

    @Override
    public IChemicalTank getChemicalTankBar() {
        return this.inputChemicalTank;
    }

    public BasicFluidTank getFluidTankBar() {
        return this.inputFluidTank;
    }

    @Override
    public boolean hasExtraResourceBar() {
        return true;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, PressurizedReactionRecipe, InputRecipeCache.ItemFluidChemical<PressurizedReactionRecipe>> getRecipeType() {
        return MekanismRecipeType.REACTION;
    }

    @Nullable
    public IRecipeViewerRecipeType<PressurizedReactionRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.REACTION;
    }

    @Nullable
    public PressurizedReactionRecipe getRecipe(int cacheIndex) {
        return (PressurizedReactionRecipe)this.findFirstRecipe(this.itemInputHandlers[cacheIndex], this.fluidInputHandler, this.chemicalInputHandler);
    }

    @NotNull
    public CachedRecipe<PressurizedReactionRecipe> createNewCachedRecipe(@NotNull PressurizedReactionRecipe recipe, int cacheIndex) {
        return new PressurizedReactionCachedRecipe(recipe, this.recheckAllRecipeErrors[cacheIndex], this.itemInputHandlers[cacheIndex], this.fluidInputHandler, this.chemicalInputHandler, this.reactionOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityExtraPRCFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((ExtraAdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityExtraPRCFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    public boolean inputProducesOutput(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @NotNull IChemicalTank outputTank, boolean updateCache) {
        return outputTank.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputSlot, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<PressurizedReactionRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            PressurizedReactionRecipe cachedRecipe = (PressurizedReactionRecipe)cached.getRecipe();
            return !(!cachedRecipe.getInputSolid().testType(stack) || !this.inputFluidTank.isEmpty() && !cachedRecipe.getInputFluid().testType(this.inputFluidTank.getFluid()) || !this.inputChemicalTank.isEmpty() && !cachedRecipe.getInputChemical().testType(this.inputChemicalTank.getStack()));
        }
        return false;
    }

    @Nullable
    protected PressurizedReactionRecipe getRecipeForInput(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @NotNull IChemicalTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (PressurizedReactionRecipe)cached.getRecipe();
        }
        PressurizedReactionRecipe foundRecipe = this.findRecipe(process, fallbackInput, outputSlot, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe((MekanismRecipe)foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected PressurizedReactionRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, IInventorySlot outputSlot, @NotNull IChemicalTank inputTank) {
        return (PressurizedReactionRecipe)((InputRecipeCache.ItemFluidChemical)this.getRecipeType().getInputCache()).findFirstRecipe(this.level, (Object)fallbackInput, (Object)this.inputFluidTank.getFluid(), (Object)this.inputChemicalTank.getStack());
    }

    protected int getNeededInput(PressurizedReactionRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInputSolid().getNeededAmount(inputStack));
    }

    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeBAC(stack, this.inputFluidTank.getFluid(), this.inputChemicalTank.getStack()) || this.containsRecipeCAB(stack, this.inputFluidTank.getFluid(), this.inputChemicalTank.getStack());
    }

    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof PRCUpgradeData) {
            int i;
            PRCUpgradeData data = (PRCUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(provider, data.energySlot.serializeNBT(provider));
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputItemSlots.get(i).deserializeNBT(provider, (Tag)((IInventorySlot)data.inputSlots.get(i)).serializeNBT(provider));
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                this.outputItemSlots.get(i).setStack(((IInventorySlot)data.outputSlots.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
            this.inputChemicalTank.deserializeNBT(provider, data.inputChemicalTank.serializeNBT(provider));
            this.inputFluidTank.deserializeNBT(provider, data.inputFluidTank.serializeNBT(provider));
            this.outputChemicalTank.deserializeNBT(provider, data.outputTank.serializeNBT(provider));
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new PRCUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputChemicalTank, this.inputFluidTank, this.inputItemSlots, this.outputItemSlots, this.outputChemicalTank, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.inputFluidTank.setStack(FluidStack.EMPTY);
        if (!this.isRemote() && IRadiationManager.INSTANCE.isRadiationEnabled() && this.shouldDumpRadiation()) {
            IRadiationManager.INSTANCE.dumpRadiation(this.getWorldNN(), this.worldPosition, List.of(this.inputChemicalTank), false);
        }
        this.inputChemicalTank.setEmpty();
    }

    @Override
    protected void sortInventoryOrTank() {
        Map processes = ItemStackMap.createTypeAndTagMap();
        ArrayList<PRCProcessInfo> emptyProcesses = new ArrayList<PRCProcessInfo>();
        for (PRCProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            ExtraAdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            PRCRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(inputStack, i -> new PRCRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.getCount();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.item = inputStack;
            recipeProcessInfo.recipe = (PressurizedReactionRecipe)cachedRecipe.getRecipe();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> factory.getNeededInput(info.recipe, (ItemStack)info.item);
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            PRCRecipeProcessInfo recipeProcessInfo = (PRCRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.item = entry.getKey();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> {
                ItemStack item = (ItemStack)info.item;
                ItemStack largerInput = item.copyWithCount(Math.min(item.getMaxStackSize(), info.totalCount));
                PRCProcessInfo processInfo = info.processes.getFirst();
                info.recipe = factory.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputSlot(), this.outputChemicalTank, true);
                if (info.recipe != null) {
                    return factory.getNeededInput(info.recipe, largerInput);
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    protected void addEmptySlotsAsTargets(Map<ItemStack, PRCRecipeProcessInfo> processes, List<PRCProcessInfo> emptyProcesses) {
        for (Map.Entry<ItemStack, PRCRecipeProcessInfo> entry : processes.entrySet()) {
            int processCount;
            PRCRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<PRCProcessInfo> toRemove = new ArrayList<PRCProcessInfo>();
            for (PRCProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputSlot(), this.outputChemicalTank, true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    protected void distributeItems(Map<ItemStack, PRCRecipeProcessInfo> processes) {
        for (Map.Entry<ItemStack, PRCRecipeProcessInfo> entry : processes.entrySet()) {
            ItemStack item;
            int maxStackSize;
            int numberPerSlot;
            PRCRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1 || (numberPerSlot = recipeProcessInfo.totalCount / processCount) == (maxStackSize = (item = entry.getKey()).getMaxStackSize())) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                PRCProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                ExtraAdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.copyWithCount(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize((long)sizeForSlot, (long)inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    public record PRCProcessInfo(int process, @NotNull ExtraAdvancedFactoryInputInventorySlot inputSlot, @NotNull IInventorySlot outputSlot) {
    }

    protected static class PRCRecipeProcessInfo {
        private final List<PRCProcessInfo> processes = new ArrayList<PRCProcessInfo>();
        @Nullable
        private ToIntBiFunction<PRCRecipeProcessInfo, TileEntityExtraPRCFactory> lazyMinPerSlot;
        private Object item;
        private PressurizedReactionRecipe recipe;
        private int minPerSlot = 1;
        private int totalCount;

        protected PRCRecipeProcessInfo() {
        }

        public int getMinPerSlot(TileEntityExtraPRCFactory factory) {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = Math.max(1, this.lazyMinPerSlot.applyAsInt(this, factory));
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

