/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekaf.tile.factory;

import com.jerry.mekaf.common.upgrade.NutritionLiquifyingUpgradeData;
import com.jerry.mekextras.common.integration.mekaf.capabilities.energy.ExtraAdvancedFactoryEnergyContainer;
import com.jerry.mekextras.common.integration.mekaf.inventory.slot.ExtraAdvancedFactoryInputInventorySlot;
import com.jerry.mekextras.common.integration.mekaf.inventory.slot.ExtraAdvancedFactoryOutputInventorySlot;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraAdvancedBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.ToIntBiFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ItemStackToFluidOptionalItemRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.basic.BasicItemStackToFluidOptionalItemRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.impl.NutritionalLiquifierIRecipe;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.ItemStackMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityExtraLiquifyingFactory
extends TileEntityExtraAdvancedBase<BasicItemStackToFluidOptionalItemRecipe>
implements ISingleRecipeLookupHandler.ItemRecipeLookupHandler<BasicItemStackToFluidOptionalItemRecipe> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    private NLProcessInfo[] processInfoSlots;
    public IExtendedFluidTank fluidTank;
    protected IOutputHandler<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput>[] liquifiesOutputHandler;
    protected final List<IInventorySlot> inputItemSlots = new ArrayList<IInventorySlot>();
    protected final List<IInventorySlot> outputItemSlots = new ArrayList<IInventorySlot>();

    public TileEntityExtraLiquifyingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        for (NLProcessInfo info : this.processInfoSlots) {
            this.inputItemSlots.add((IInventorySlot)info.inputSlot());
            this.outputItemSlots.add(info.outputSlot());
        }
        this.configComponent.setupItemIOConfig(this.inputItemSlots, this.outputItemSlots, (IInventorySlot)this.energySlot, false);
        this.configComponent.setupOutputConfig(TransmissionType.FLUID, (Object)this.fluidTank, new RelativeSide[]{RelativeSide.RIGHT});
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.FLUID}).setCanTankEject(tank -> tank == this.fluidTank);
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.fluidTank = BasicFluidTank.output((int)(10000 * this.tier.processes * this.tier.processes), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    @Override
    protected void addTanks(ChemicalTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.itemInputHandlers = new IInputHandler[this.tier.processes];
        this.liquifiesOutputHandler = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new NLProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            FactoryRecipeCacheLookupMonitor lookupMonitor = this.recipeCacheLookupMonitors[i];
            IContentsListener updateSortingAndUnpause = () -> {
                updateSortingListener.onContentsChanged();
                lookupMonitor.unpause();
            };
            ExtraAdvancedFactoryOutputInventorySlot outputSlot = ExtraAdvancedFactoryOutputInventorySlot.at(this, updateSortingAndUnpause, this.getXPos(i), 57);
            ExtraAdvancedFactoryInputInventorySlot inputSlot = ExtraAdvancedFactoryInputInventorySlot.create(this, i, (IInventorySlot)outputSlot, this.fluidTank, (IContentsListener)this.recipeCacheLookupMonitors[i], this.getXPos(i), 13);
            int index = i;
            ((ExtraAdvancedFactoryInputInventorySlot)builder.addSlot((IInventorySlot)inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, index)));
            ((ExtraAdvancedFactoryOutputInventorySlot)builder.addSlot((IInventorySlot)outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, index)));
            this.itemInputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
            this.liquifiesOutputHandler[i] = OutputHelper.getOutputHandler((IExtendedFluidTank)this.fluidTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, (IInventorySlot)outputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR);
            this.processInfoSlots[i] = new NLProcessInfo(i, inputSlot, (IInventorySlot)outputSlot);
        }
    }

    public static boolean isValidInputStatic(ItemStack stack) {
        FoodProperties food = stack.getFoodProperties(null);
        return food != null && food.nutrition() > 0;
    }

    public boolean isValidInputItem(ItemStack stack) {
        FoodProperties food = stack.getFoodProperties(null);
        return food != null && food.nutrition() > 0;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, BasicItemStackToFluidOptionalItemRecipe, InputRecipeCache.SingleItem<BasicItemStackToFluidOptionalItemRecipe>> getRecipeType() {
        return null;
    }

    @Nullable
    public BasicItemStackToFluidOptionalItemRecipe getRecipe(int cacheIndex) {
        return TileEntityExtraLiquifyingFactory.getRecipe((ItemStack)this.itemInputHandlers[cacheIndex].getInput());
    }

    @Nullable
    public static BasicItemStackToFluidOptionalItemRecipe getRecipe(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        FoodProperties food = stack.getFoodProperties(null);
        if (food == null || food.nutrition() <= 0) {
            return null;
        }
        return new NutritionalLiquifierIRecipe(IngredientCreatorAccess.item().from(stack, 1), MekanismFluids.NUTRITIONAL_PASTE.asStack(food.nutrition() * 50), food.usingConvertsTo().orElse(ItemStack.EMPTY));
    }

    @NotNull
    public CachedRecipe<BasicItemStackToFluidOptionalItemRecipe> createNewCachedRecipe(@NotNull BasicItemStackToFluidOptionalItemRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.itemToFluidOptionalItem((ItemStackToFluidOptionalItemRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.itemInputHandlers[cacheIndex], this.liquifiesOutputHandler[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityExtraLiquifyingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((ExtraAdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityExtraLiquifyingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    public boolean inputProducesOutput(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @NotNull IExtendedFluidTank outputTank, boolean updateCache) {
        return outputTank.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputSlot, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<BasicItemStackToFluidOptionalItemRecipe> cached, @NotNull ItemStack stack) {
        return cached != null && TileEntityExtraLiquifyingFactory.isValidInputStatic(stack);
    }

    @Nullable
    protected BasicItemStackToFluidOptionalItemRecipe getRecipeForInput(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @NotNull IExtendedFluidTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (BasicItemStackToFluidOptionalItemRecipe)cached.getRecipe();
        }
        BasicItemStackToFluidOptionalItemRecipe foundRecipe = this.findRecipe(process, fallbackInput, outputSlot, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe((MekanismRecipe)foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected BasicItemStackToFluidOptionalItemRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, IInventorySlot outputSlot, @NotNull IExtendedFluidTank inputTank) {
        return null;
    }

    protected int getNeededInput(BasicItemStackToFluidOptionalItemRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount(inputStack));
    }

    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return true;
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof NutritionLiquifyingUpgradeData) {
            int i;
            NutritionLiquifyingUpgradeData data = (NutritionLiquifyingUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(provider, data.energySlot.serializeNBT(provider));
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputItemSlots.get(i).deserializeNBT(provider, (Tag)((IInventorySlot)data.inputSlots.get(i)).serializeNBT(provider));
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                this.outputItemSlots.get(i).setStack(((IInventorySlot)data.outputSlots.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
            this.fluidTank.deserializeNBT(provider, data.fluidTank.serializeNBT(provider));
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @Nullable
    public NutritionLiquifyingUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new NutritionLiquifyingUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputItemSlots, this.outputItemSlots, this.fluidTank, this.isSorting(), this.getComponents());
    }

    @Override
    protected void sortInventoryOrTank() {
        Map processes = ItemStackMap.createTypeAndTagMap();
        ArrayList<NLProcessInfo> emptyProcesses = new ArrayList<NLProcessInfo>();
        for (NLProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            ExtraAdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            NLRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(inputStack, i -> new NLRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.getCount();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.item = inputStack;
            recipeProcessInfo.recipe = (BasicItemStackToFluidOptionalItemRecipe)cachedRecipe.getRecipe();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> factory.getNeededInput(info.recipe, (ItemStack)info.item);
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            NLRecipeProcessInfo recipeProcessInfo = (NLRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.item = entry.getKey();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> {
                ItemStack item = (ItemStack)info.item;
                ItemStack largerInput = item.copyWithCount(Math.min(item.getMaxStackSize(), info.totalCount));
                NLProcessInfo processInfo = info.processes.getFirst();
                info.recipe = factory.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputSlot(), this.fluidTank, true);
                if (info.recipe != null) {
                    return factory.getNeededInput(info.recipe, largerInput);
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    private void addEmptySlotsAsTargets(Map<ItemStack, NLRecipeProcessInfo> processes, List<NLProcessInfo> emptyProcesses) {
        for (Map.Entry<ItemStack, NLRecipeProcessInfo> entry : processes.entrySet()) {
            int processCount;
            NLRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<NLProcessInfo> toRemove = new ArrayList<NLProcessInfo>();
            for (NLProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputSlot(), this.fluidTank, true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    private void distributeItems(Map<ItemStack, NLRecipeProcessInfo> processes) {
        for (Map.Entry<ItemStack, NLRecipeProcessInfo> entry : processes.entrySet()) {
            ItemStack item;
            int maxStackSize;
            int numberPerSlot;
            NLRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1 || (numberPerSlot = recipeProcessInfo.totalCount / processCount) == (maxStackSize = (item = entry.getKey()).getMaxStackSize())) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                NLProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                ExtraAdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.copyWithCount(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize((long)sizeForSlot, (long)inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    public record NLProcessInfo(int process, @NotNull ExtraAdvancedFactoryInputInventorySlot inputSlot, @NotNull IInventorySlot outputSlot) {
    }

    protected static class NLRecipeProcessInfo {
        private final List<NLProcessInfo> processes = new ArrayList<NLProcessInfo>();
        @Nullable
        private ToIntBiFunction<NLRecipeProcessInfo, TileEntityExtraLiquifyingFactory> lazyMinPerSlot;
        private Object item;
        private BasicItemStackToFluidOptionalItemRecipe recipe;
        private int minPerSlot = 1;
        private int totalCount;

        protected NLRecipeProcessInfo() {
        }

        public int getMinPerSlot(TileEntityExtraLiquifyingFactory factory) {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = Math.max(1, this.lazyMinPerSlot.applyAsInt(this, factory));
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

