/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekaf.tile.factory;

import com.jerry.mekaf.common.upgrade.ChemicalToChemicalUpgradeData;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraAdvancedBase;
import com.jerry.mekmm.common.util.ChemicalStackMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ToIntBiFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityExtraChemicalToChemicalFactory<RECIPE extends MekanismRecipe<?>>
extends TileEntityExtraAdvancedBase<RECIPE> {
    protected CCProcessInfo[] processInfoSlots;
    protected IChemicalTank[] outputTank;
    protected IChemicalTank[] inputTank;
    protected int baselineMaxOperations = 1;
    public List<IChemicalTank> inputChemicalTanks = new ArrayList<IChemicalTank>();
    public List<IChemicalTank> outputChemicalTanks = new ArrayList<IChemicalTank>();

    protected TileEntityExtraChemicalToChemicalFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        ConfigInfo itemConfig;
        for (CCProcessInfo info : this.processInfoSlots) {
            this.inputChemicalTanks.add(info.inputTank());
            this.outputChemicalTanks.add(info.outputTank());
        }
        ConfigInfo config = this.configComponent.getConfig(TransmissionType.CHEMICAL);
        if (config != null) {
            config.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo(false, true, this.outputChemicalTanks));
        }
        if ((itemConfig = this.configComponent.getConfig(TransmissionType.ITEM)) != null) {
            itemConfig.addSlotInfo(DataType.ENERGY, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.energySlot}));
        }
    }

    @Override
    protected void addTanks(ChemicalTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputTank = new IChemicalTank[this.tier.processes];
        this.outputTank = new IChemicalTank[this.tier.processes];
        this.chemicalInputHandlers = new IInputHandler[this.tier.processes];
        this.chemicalOutputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new CCProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            FactoryRecipeCacheLookupMonitor lookupMonitor = this.recipeCacheLookupMonitors[i];
            IContentsListener updateSortingAndUnpause = () -> {
                updateSortingListener.onContentsChanged();
                lookupMonitor.unpause();
            };
            int index = i;
            this.outputTank[i] = BasicChemicalTank.output((long)(10000L * (long)this.tier.processes), (IContentsListener)updateSortingAndUnpause);
            this.inputTank[i] = BasicChemicalTank.createModern((long)(10000L * (long)this.tier.processes), (BiPredicate)ChemicalTankHelper.radioactiveInputTankPredicate(() -> this.outputTank[index]), (stack, type) -> this.isValidInputChemical((ChemicalStack)stack), stack -> this.isChemicalValidForTank((ChemicalStack)stack) && this.inputProducesOutput(index, (ChemicalStack)stack, this.outputTank[index], false), (ChemicalAttributeValidator)ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this.recipeCacheLookupMonitors[index]);
            builder.addTank(this.inputTank[i]);
            builder.addTank(this.outputTank[i]);
            this.chemicalInputHandlers[i] = InputHelper.getInputHandler((IChemicalTank)this.inputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
            this.chemicalOutputHandlers[i] = OutputHelper.getOutputHandler((IChemicalTank)this.outputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
            this.processInfoSlots[i] = new CCProcessInfo(i, this.inputTank[i], this.outputTank[i]);
        }
    }

    public boolean inputProducesOutput(int process, @NotNull ChemicalStack fallbackInput, @NotNull IChemicalTank outputTank, boolean updateCache) {
        return outputTank.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull ChemicalStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull ChemicalStack fallbackInput, @NotNull IChemicalTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull ChemicalStack var2, @NotNull IChemicalTank var3);

    public abstract boolean isChemicalValidForTank(@NotNull ChemicalStack var1);

    public abstract boolean isValidInputChemical(@NotNull ChemicalStack var1);

    protected abstract int getNeededInput(RECIPE var1, ChemicalStack var2);

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ChemicalToChemicalUpgradeData) {
            int i;
            ChemicalToChemicalUpgradeData data = (ChemicalToChemicalUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(provider, data.energySlot.serializeNBT(provider));
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputTanks.size(); ++i) {
                this.inputChemicalTanks.get(i).deserializeNBT(provider, ((IChemicalTank)data.inputTanks.get(i)).serializeNBT(provider));
            }
            for (i = 0; i < data.outputTanks.size(); ++i) {
                this.outputChemicalTanks.get(i).setStack(((IChemicalTank)data.outputTanks.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @Override
    protected void sortInventoryOrTank() {
        Map processes = ChemicalStackMap.createTypeAndComponentsMap();
        ArrayList<CCProcessInfo> emptyProcesses = new ArrayList<CCProcessInfo>();
        for (CCProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            IChemicalTank inputTank = processInfo.inputTank();
            if (inputTank.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ChemicalStack inputStack = inputTank.getStack();
            CCRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(inputStack, i -> new CCRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalAmount += inputStack.getAmount();
            if (recipeProcessInfo.lazyMinPerTank != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.item = inputStack;
            recipeProcessInfo.recipe = cachedRecipe.getRecipe();
            recipeProcessInfo.lazyMinPerTank = (info, factory) -> factory.getNeededInput(info.recipe, (ChemicalStack)info.item);
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            CCRecipeProcessInfo recipeProcessInfo = (CCRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerTank != null) continue;
            recipeProcessInfo.item = entry.getKey();
            recipeProcessInfo.lazyMinPerTank = (info, factory) -> {
                ChemicalStack item = (ChemicalStack)info.item;
                ChemicalStack largerInput = item.copyWithAmount(Math.min(10000L * (long)this.tier.processes, info.totalAmount));
                CCProcessInfo processInfo = info.processes.getFirst();
                info.recipe = factory.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputTank(), true);
                if (info.recipe != null) {
                    return factory.getNeededInput(info.recipe, largerInput);
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptyTanksAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    protected void addEmptyTanksAsTargets(Map<ChemicalStack, CCRecipeProcessInfo<RECIPE>> processes, List<CCProcessInfo> emptyProcesses) {
        for (Map.Entry<ChemicalStack, CCRecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            int processAmount;
            CCRecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            long minPerTank = recipeProcessInfo.getMinPerTank(this);
            long maxTanks = recipeProcessInfo.totalAmount / minPerTank;
            if (maxTanks <= 1L || maxTanks <= (long)(processAmount = recipeProcessInfo.processes.size())) continue;
            ChemicalStack sourceStack = entry.getKey();
            long emptyToAdd = maxTanks - (long)processAmount;
            int added = 0;
            ArrayList<CCProcessInfo> toRemove = new ArrayList<CCProcessInfo>();
            for (CCProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputTank(), true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if ((long)(++added) < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    protected void distributeItems(Map<ChemicalStack, CCRecipeProcessInfo<RECIPE>> processes) {
        for (Map.Entry<ChemicalStack, CCRecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            CCRecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            long processAmount = recipeProcessInfo.processes.size();
            if (processAmount == 1L) continue;
            ChemicalStack item = entry.getKey();
            long numberPerTank = recipeProcessInfo.totalAmount / processAmount;
            long maxAmount = 10000L * (long)this.tier.processes;
            if (numberPerTank == maxAmount) continue;
            long remainder = recipeProcessInfo.totalAmount % processAmount;
            long minPerTank = recipeProcessInfo.getMinPerTank(this);
            if (minPerTank > 1L) {
                long perSlotRemainder = numberPerTank % minPerTank;
                if (perSlotRemainder > 0L) {
                    numberPerTank -= perSlotRemainder;
                    remainder += perSlotRemainder * processAmount;
                }
                if (numberPerTank + minPerTank > maxAmount) {
                    minPerTank = maxAmount - numberPerTank;
                }
            }
            int i = 0;
            while ((long)i < processAmount) {
                CCProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                IChemicalTank inputTank = processInfo.inputTank();
                long sizeForTank = numberPerTank;
                if (remainder > 0L) {
                    if (remainder > minPerTank) {
                        sizeForTank += minPerTank;
                        remainder -= minPerTank;
                    } else {
                        sizeForTank += remainder;
                        remainder = 0L;
                    }
                }
                if (inputTank.isEmpty()) {
                    if (sizeForTank > 0L) {
                        inputTank.setStackUnchecked(item.copyWithAmount(sizeForTank));
                    }
                } else if (sizeForTank == 0L) {
                    inputTank.setEmpty();
                } else if (inputTank.getCapacity() != sizeForTank) {
                    MekanismUtils.logMismatchedStackSize((long)sizeForTank, (long)inputTank.setStackSize(sizeForTank, Action.EXECUTE));
                }
                ++i;
            }
        }
    }

    public record CCProcessInfo(int process, @NotNull IChemicalTank inputTank, @NotNull IChemicalTank outputTank) {
    }

    protected static class CCRecipeProcessInfo<RECIPE extends MekanismRecipe<?>> {
        private final List<CCProcessInfo> processes = new ArrayList<CCProcessInfo>();
        @Nullable
        private ToIntBiFunction<CCRecipeProcessInfo<RECIPE>, TileEntityExtraChemicalToChemicalFactory<RECIPE>> lazyMinPerTank;
        private Object item;
        private RECIPE recipe;
        private long minPerTank = 1L;
        private long totalAmount;

        protected CCRecipeProcessInfo() {
        }

        public long getMinPerTank(TileEntityExtraChemicalToChemicalFactory<RECIPE> factory) {
            if (this.lazyMinPerTank != null) {
                this.minPerTank = Math.max(1, this.lazyMinPerTank.applyAsInt(this, factory));
                this.lazyMinPerTank = null;
            }
            return this.minPerTank;
        }
    }
}

