/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekaf.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekextras.common.block.prefab.BlockExtraAdvancedFactoryMachine;
import com.jerry.mekextras.common.integration.mekaf.item.block.machine.ItemBlockExtraAdvancedFactory;
import com.jerry.mekextras.common.integration.mekaf.registries.ExtraAdvancedFactoryBlocks;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraAdvancedBase;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraCentrifugingFactory;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraChemicalInfusingFactory;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraCrystallizingFactory;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraDissolvingFactory;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraLiquifyingFactory;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraOxidizingFactory;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraPRCFactory;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraWashingFactory;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ExtraAdvancedFactoryTileEntityTypes {
    public static final TileEntityTypeDeferredRegister AF_TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekanism_extras");
    private static final Table<ExtraFactoryTier, AdvancedFactoryType, TileEntityTypeRegistryObject<? extends TileEntityExtraAdvancedBase<?>>> AF_FACTORIES = HashBasedTable.create();

    private ExtraAdvancedFactoryTileEntityTypes() {
    }

    private static void registerFactory(ExtraFactoryTier tier, AdvancedFactoryType type, ExtraAdvancedBlockEntityFactory<? extends TileEntityExtraAdvancedBase<?>> factoryConstructor) {
        BlockRegistryObject<BlockExtraAdvancedFactoryMachine.BlockExtraAdvancedFactory<?>, ItemBlockExtraAdvancedFactory> block = ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, type);
        TileEntityTypeRegistryObject tileRO = AF_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> (TileEntityExtraAdvancedBase)((Object)((Object)factoryConstructor.create((Holder<Block>)block, pos, state)))).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        AF_FACTORIES.put((Object)tier, (Object)type, (Object)tileRO);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraAdvancedBase<?>> getAdvancedFactoryTile(ExtraFactoryTier tier, AdvancedFactoryType type) {
        return (TileEntityTypeRegistryObject)AF_FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityExtraAdvancedBase<?>>[] getFactoryTiles() {
        return AF_FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    static {
        for (ExtraFactoryTier tier : ExtraEnumUtils.EXTRA_FACTORY_TIERS) {
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.OXIDIZING, TileEntityExtraOxidizingFactory::new);
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.DISSOLVING, TileEntityExtraDissolvingFactory::new);
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.CHEMICAL_INFUSING, TileEntityExtraChemicalInfusingFactory::new);
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.WASHING, TileEntityExtraWashingFactory::new);
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.PRESSURISED_REACTING, TileEntityExtraPRCFactory::new);
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.CRYSTALLIZING, TileEntityExtraCrystallizingFactory::new);
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.CENTRIFUGING, TileEntityExtraCentrifugingFactory::new);
            ExtraAdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.LIQUIFYING, TileEntityExtraLiquifyingFactory::new);
        }
    }

    @FunctionalInterface
    private static interface ExtraAdvancedBlockEntityFactory<BE extends BlockEntity> {
        public BE create(Holder<Block> var1, BlockPos var2, BlockState var3);
    }
}

