/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.integration.mekaf.content.blocktype;

import com.jerry.mekaf.common.block.attribute.AttributeAdvancedFactoryType;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryBlockShapes;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeUpgradeable;
import com.jerry.mekextras.common.content.blocktype.ExtraMachine;
import com.jerry.mekextras.common.integration.mekaf.registries.ExtraAdvancedFactoryBlockTypes;
import com.jerry.mekextras.common.integration.mekaf.registries.ExtraAdvancedFactoryBlocks;
import com.jerry.mekextras.common.integration.mekaf.registries.ExtraAdvancedFactoryContainerTypes;
import com.jerry.mekextras.common.integration.mekaf.tile.factory.TileEntityExtraAdvancedBase;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.function.Supplier;
import mekanism.api.math.MathUtils;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import org.jetbrains.annotations.NotNull;

public class ExtraAdvancedFactory<TILE extends TileEntityExtraAdvancedBase<?>>
extends ExtraMachine.ExtraFactoryMachine<TILE> {
    private final ExtraMachine.ExtraFactoryMachine<?> origMachine;

    public ExtraAdvancedFactory(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar, ExtraMachine.ExtraFactoryMachine<?> origMachine, ExtraFactoryTier tier) {
        super(tileEntityRegistrar, (ILangEntry)MekanismLang.DESCRIPTION_FACTORY, origMachine.getAdvancedFactoryType());
        this.origMachine = origMachine;
        this.setMachineData(tier);
        this.add(new Attribute[]{new AttributeGui(containerRegistrar, null), new ExtraAttributeTier<ExtraFactoryTier>(tier)});
        if (tier.ordinal() < ExtraEnumUtils.EXTRA_FACTORY_TIERS.length - 1) {
            this.add(new Attribute[]{new ExtraAttributeUpgradeable(() -> ExtraAdvancedFactoryBlocks.getAdvancedFactory(ExtraEnumUtils.EXTRA_FACTORY_TIERS[tier.ordinal() + 1], origMachine.getAdvancedFactoryType()))});
        }
    }

    private void setMachineData(ExtraFactoryTier tier) {
        this.setFrom((BlockTypeTile)this.origMachine, new Class[]{AttributeSound.class, AttributeAdvancedFactoryType.class, AttributeUpgradeSupport.class});
        AttributeEnergy origEnergy = (AttributeEnergy)this.origMachine.get(AttributeEnergy.class);
        if (origEnergy != null) {
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = new AttributeEnergy(() -> ((AttributeEnergy)origEnergy).getUsage(), () -> MathUtils.clampToLong((double)(Math.max(origEnergy.getConfigStorage(), origEnergy.getUsage()) * (long)tier.processes * (long)tier.processes)));
            this.add(attributeArray);
        }
    }

    @NotNull
    private static <TILE extends TileEntityExtraAdvancedBase<?>> ExtraAdvancedFactoryBuilder<ExtraAdvancedFactory<TILE>, TILE, ?> getExtraAdvancedFactoryTILEAdvancedFactoryBuilder(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, AdvancedFactoryType type, ExtraFactoryTier tier) {
        Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> supplier = () -> ExtraAdvancedFactoryContainerTypes.ADVANCED_FACTORY;
        ExtraAdvancedFactoryBuilder builder = new ExtraAdvancedFactoryBuilder(new ExtraAdvancedFactory<TILE>(tileEntityRegistrar, supplier, switch (type) {
            default -> throw new MatchException(null, null);
            case AdvancedFactoryType.OXIDIZING -> ExtraAdvancedFactoryBlockTypes.CHEMICAL_OXIDIZER;
            case AdvancedFactoryType.CHEMICAL_INFUSING -> ExtraAdvancedFactoryBlockTypes.CHEMICAL_INFUSER;
            case AdvancedFactoryType.DISSOLVING -> ExtraAdvancedFactoryBlockTypes.CHEMICAL_DISSOLUTION_CHAMBER;
            case AdvancedFactoryType.WASHING -> ExtraAdvancedFactoryBlockTypes.CHEMICAL_WASHER;
            case AdvancedFactoryType.CRYSTALLIZING -> ExtraAdvancedFactoryBlockTypes.CHEMICAL_CRYSTALLIZER;
            case AdvancedFactoryType.PRESSURISED_REACTING -> ExtraAdvancedFactoryBlockTypes.PRESSURIZED_REACTION_CHAMBER;
            case AdvancedFactoryType.CENTRIFUGING -> ExtraAdvancedFactoryBlockTypes.ISOTOPIC_CENTRIFUGE;
            case AdvancedFactoryType.LIQUIFYING -> ExtraAdvancedFactoryBlockTypes.NUTRITIONAL_LIQUIFIER;
        }, tier));
        builder.withComputerSupport(tier.getAdvanceTier().getLowerName() + type.getRegistryNameComponentCapitalized() + "Factory");
        return builder;
    }

    public static class ExtraAdvancedFactoryBuilder<FACTORY extends ExtraAdvancedFactory<TILE>, TILE extends TileEntityExtraAdvancedBase<?>, T extends ExtraMachine.ExtraMachineBuilder<FACTORY, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<FACTORY, TILE, T> {
        protected ExtraAdvancedFactoryBuilder(FACTORY holder) {
            super(holder);
        }

        public static <TILE extends TileEntityExtraAdvancedBase<?>> ExtraAdvancedFactoryBuilder<ExtraAdvancedFactory<TILE>, TILE, ?> createAdvancedFactory(Supplier<?> tileEntityRegistrar, AdvancedFactoryType type, ExtraFactoryTier tier) {
            ExtraAdvancedFactoryBuilder builder = ExtraAdvancedFactory.getExtraAdvancedFactoryTILEAdvancedFactoryBuilder(tileEntityRegistrar, type, tier);
            builder.withCustomShape(AdvancedFactoryBlockShapes.getShape((AdvancedFactoryType)type));
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = switch (type) {
                default -> throw new MatchException(null, null);
                case AdvancedFactoryType.OXIDIZING, AdvancedFactoryType.DISSOLVING, AdvancedFactoryType.CRYSTALLIZING -> AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE;
                case AdvancedFactoryType.CHEMICAL_INFUSING, AdvancedFactoryType.CENTRIFUGING -> AttributeSideConfig.create((TransmissionType[])new TransmissionType[]{TransmissionType.CHEMICAL, TransmissionType.ITEM, TransmissionType.ENERGY});
                case AdvancedFactoryType.WASHING -> AttributeSideConfig.create((TransmissionType[])new TransmissionType[]{TransmissionType.CHEMICAL, TransmissionType.FLUID, TransmissionType.ITEM, TransmissionType.ENERGY});
                case AdvancedFactoryType.PRESSURISED_REACTING -> AttributeSideConfig.create((TransmissionType[])new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL, TransmissionType.FLUID, TransmissionType.ENERGY});
                case AdvancedFactoryType.LIQUIFYING -> AttributeSideConfig.create((TransmissionType[])new TransmissionType[]{TransmissionType.FLUID, TransmissionType.ITEM, TransmissionType.ENERGY});
            };
            builder.with(attributeArray);
            if (type.getBaseMachine().has(AttributeHasBounding.class)) {
                builder.with(new Attribute[]{AttributeHasBounding.ABOVE_ONLY});
            }
            builder.replace(new Attribute[]{new AttributeParticleFX().addDense((ParticleOptions)ParticleTypes.SMOKE, 5, rand -> new Pos3D((double)(rand.nextFloat() * 0.7f - 0.3f), (double)(rand.nextFloat() * 0.1f + 0.7f), (double)(rand.nextFloat() * 0.7f - 0.3f)))});
            return builder;
        }
    }
}

